/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.helper;

import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;

public class StylingHelper {
    public static Component getAffectedEntityNameText(Entity entity) {
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        return Component.literal((String)entity.getName().getString()).setStyle(textStyles.getPrimary());
    }

    public static Component getAffectedEntitiesNumberText(List<? extends Entity> entities) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int affectedCount = 0;
        for (Entity entity : entities) {
            String name = entity.getName().getString();
            int count = 1;
            if (entity instanceof ItemEntity) {
                count = ((ItemEntity)entity).getItem().getCount();
            }
            map.put(name, entity.isAlwaysTicking() ? -1 : map.getOrDefault(name, 0) + count);
            affectedCount += count;
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        MutableComponent mutableComponent = Component.empty();
        boolean isFirst = true;
        for (Map.Entry entry : map.entrySet()) {
            Style entryStyle;
            if (!isFirst) {
                mutableComponent.append("\n");
            }
            boolean isPlayer = (Integer)entry.getValue() == -1;
            Style style = entryStyle = isPlayer ? textStyles.getSecondary() : Style.EMPTY;
            if (!isPlayer) {
                mutableComponent.append(String.valueOf(entry.getValue()) + "x ").setStyle(entryStyle);
            }
            mutableComponent.append((Component)Component.literal((String)((String)entry.getKey())).setStyle(entryStyle));
            isFirst = false;
        }
        return Component.literal((String)String.valueOf(affectedCount)).setStyle(textStyles.getPrimary().withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)mutableComponent)));
    }

    public static Component getAffectedEntitiesNumberText(Map<? extends Entity, String> affected) {
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        MutableComponent hoverText = Component.empty();
        boolean isFirst = true;
        for (Map.Entry<? extends Entity, String> entry : affected.entrySet()) {
            if (!isFirst) {
                hoverText.append("\n");
            }
            Style entryStyle = entry.getKey().isAlwaysTicking() ? textStyles.getSecondary() : Style.EMPTY;
            hoverText.append((Component)Component.literal((String)entry.getKey().getName().getString()).setStyle(entryStyle)).append(": ").append(entry.getValue());
            isFirst = false;
        }
        HoverEvent.ShowText hoverEvent = new HoverEvent.ShowText((Component)hoverText);
        return Component.literal((String)String.valueOf(affected.size())).setStyle(StylingManager.getCurrentStyle().getTextStyles().getPrimary().withHoverEvent((HoverEvent)hoverEvent));
    }

    public static Component getTitle(Component primaryTitle, Component secondaryTitle) {
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = StylingManager.getCurrentStyle().getTextDecorators();
        return Component.literal((String)"\n").append((Component)Component.literal((String)textDecorators.getTitlePrefix()).setStyle(textStyles.getTitlePrimary())).append((Component)Component.literal((String)primaryTitle.getString()).setStyle(textStyles.getTitlePrimary())).append((Component)Component.literal((String)textDecorators.getTitleSeparator()).setStyle(textStyles.getTitleSecondary())).append((Component)Component.literal((String)secondaryTitle.getString()).setStyle(textStyles.getTitleSecondary())).append((Component)Component.literal((String)textDecorators.getTitleSuffix()).setStyle(textStyles.getTitlePrimary()));
    }

    public static Component getButton(Component label, HoverEvent hoverEvent, ClickEvent clickEvent) {
        return StylingHelper.getButton("", label, hoverEvent, clickEvent);
    }

    public static Component getButton(Component label, Style style) {
        return StylingHelper.getButton("", label, style);
    }

    public static Component getButton(String logo, Component label, HoverEvent hoverEvent, ClickEvent clickEvent) {
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        return StylingHelper.getButton(logo, label, textStyles.getButton().withHoverEvent(hoverEvent).withClickEvent(clickEvent));
    }

    public static Component getButton(String logo, Component label, Style style) {
        HelpfulCommandsStyle.TextDecorators textDecorators = StylingManager.getCurrentStyle().getTextDecorators();
        MutableComponent component = Component.empty().setStyle(style);
        component.append(textDecorators.getButtonPrefix());
        if (!logo.isEmpty()) {
            component.append(logo).append(textDecorators.getButtonSeparator());
        }
        component.append(label).append(textDecorators.getButtonSuffix());
        return component;
    }

    public static Component getPositionText(double x, double y, double z) {
        return StylingHelper.getLocationText(x, y, z, "");
    }

    public static Component getLocationText(double x, double y, double z, String dimensionKey) {
        String format = "%.2f";
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        MutableComponent component = Component.empty();
        component.append((Component)Component.literal((String)String.format(format, x)).setStyle(textStyles.getAxisX())).append(" ").append((Component)Component.literal((String)String.format(format, y)).setStyle(textStyles.getAxisY())).append(" ").append((Component)Component.literal((String)String.format(format, z)).setStyle(textStyles.getAxisZ()));
        if (!dimensionKey.isEmpty()) {
            component.append((Component)Component.literal((String)" (").setStyle(textStyles.getSubtle())).append((Component)Component.literal((String)dimensionKey).setStyle(textStyles.getPrimary())).append((Component)Component.literal((String)")").setStyle(textStyles.getSubtle()));
        }
        return component;
    }

    public static Component getLocationText(GlobalPos globalPos) {
        BlockPos blockPos = globalPos.pos();
        return StylingHelper.getLocationText(blockPos.getX(), blockPos.getY(), blockPos.getZ(), globalPos.dimension().location().toString());
    }

    public static Component getLocationText(Vec3 vec3, String dimensionKey) {
        return StylingHelper.getLocationText(vec3.x(), vec3.y(), vec3.z(), dimensionKey);
    }
}

