/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.manager;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.io.JsonIO;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class ConfigManager {
    private static final String FILE_NAME = "config";
    private static JsonIO<HelpfulCommandsConfig> io;
    public static final Map<String, ConfigFieldProperties> DEFAULT_FIELDS;

    public static void initialize(MinecraftServer server) {
        io = new JsonIO<HelpfulCommandsConfig>(server.getWorldPath(LevelResource.ROOT).resolve("helpful_commands4"), FILE_NAME, HelpfulCommandsConfig.class);
        HelpfulCommandsConfig config = ConfigManager.readConfig();
        for (HelpfulCommandsCommand command : ModCommandManager.getCommandList()) {
            ModCommandManager.CommandData data = command.getCommandData();
            if (data.getCategory() == ModCommandManager.CommandCategory.MAIN) continue;
            CommandConfigEntry entry = new CommandConfigEntry();
            entry.state = data.isEnabledByDefault();
            config.command.commands.putIfAbsent(data.getName(), entry);
        }
        io.save(config);
    }

    public static HelpfulCommandsConfig readConfig() {
        return Objects.requireNonNullElse(io.read(), new HelpfulCommandsConfig());
    }

    public static void writeToDisk() {
        io.writeToDisk();
    }

    static {
        DEFAULT_FIELDS = Map.ofEntries(Map.entry("killitemsMaxRange", new ConfigFieldProperties(ConfigFieldProperties.ValueType.Integer, 128, 1.0)), Map.entry("maxHomes", new ConfigFieldProperties(ConfigFieldProperties.ValueType.Integer, 5, 1.0)));
    }

    public static class HelpfulCommandsConfig {
        public final CommandConfig command = new CommandConfig();
        public final StylingConfig styling = new StylingConfig();
        private final Map<String, Object> fields = new HashMap<String, Object>();

        public HelpfulCommandsConfig() {
            for (Map.Entry<String, ConfigFieldProperties> entry : DEFAULT_FIELDS.entrySet()) {
                this.fields.putIfAbsent(entry.getKey(), entry.getValue().defaultValue);
            }
        }

        public void writeField(String key, Object value) {
            this.fields.put(key, value);
            io.save(this);
        }

        public <T> T readField(String key) {
            Object value = this.fields.get(key);
            ConfigFieldProperties properties = DEFAULT_FIELDS.get(key);
            if (properties == null) {
                return null;
            }
            if (value == null) {
                value = properties.defaultValue;
                this.fields.put(key, value);
            }
            switch (properties.valueType.ordinal()) {
                case 1: {
                    if (!(value instanceof Number)) {
                        throw this.invalidType(key, "Integer", value);
                    }
                    Number num = (Number)value;
                    int result = Math.clamp((long)num.intValue(), properties.min.intValue(), properties.max.intValue());
                    return (T)Integer.valueOf(result);
                }
                case 0: {
                    if (!(value instanceof Number)) {
                        throw this.invalidType(key, "Double", value);
                    }
                    Number num = (Number)value;
                    double result = Math.clamp(num.doubleValue(), properties.min, properties.max);
                    return (T)Double.valueOf(result);
                }
                case 2: {
                    if (!(value instanceof Boolean)) {
                        throw this.invalidType(key, "Boolean", value);
                    }
                    Boolean bool = (Boolean)value;
                    return (T)bool;
                }
            }
            throw new IllegalStateException("Unknown valueType for field '" + key + "'");
        }

        private IllegalStateException invalidType(String key, String expected, Object actual) {
            return new IllegalStateException("Config field '" + key + "' expected type " + expected + " but found " + actual.getClass().getSimpleName());
        }

        public boolean setCommandState(String commandName, boolean newState) {
            CommandConfigEntry entry = this.command.commands.getOrDefault(commandName, new CommandConfigEntry());
            if (entry.state == newState) {
                return false;
            }
            entry.state = newState;
            this.command.commands.put(commandName, entry);
            io.save(this);
            return true;
        }

        public boolean getCommandState(String commandName) {
            CommandConfigEntry entry = this.command.commands.getOrDefault(commandName, new CommandConfigEntry());
            return entry.state;
        }

        public void setStyle(String styleName) {
            this.styling.style = styleName;
            io.save(this);
        }

        public String getStyleName() {
            return this.styling.style;
        }
    }

    private static class CommandConfigEntry {
        private boolean state;

        private CommandConfigEntry() {
        }
    }

    public static class CommandConfig {
        private final Map<String, CommandConfigEntry> commands = new HashMap<String, CommandConfigEntry>();
    }

    public static class ConfigFieldProperties {
        public final ValueType valueType;
        public final Object defaultValue;
        public final Double min;
        public final Double max;

        public ConfigFieldProperties(ValueType valueType, Object defaultValue) {
            this(valueType, defaultValue, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public ConfigFieldProperties(ValueType valueType, Object defaultValue, double min) {
            this(valueType, defaultValue, min, Double.POSITIVE_INFINITY);
        }

        public ConfigFieldProperties(ValueType valueType, Object defaultValue, double min, double max) {
            this.valueType = valueType;
            this.defaultValue = defaultValue;
            this.min = min;
            this.max = max;
        }

        public static enum ValueType {
            Double,
            Integer,
            Boolean;

        }
    }

    public static class StylingConfig {
        private String style;
    }
}

