/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.manager;

import com.expecticament.helpfulcommands.HelpfulCommands;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class TranslationManager {
    private static final Gson GSON = new Gson();
    private static final String FALLBACK_LANG = "en_us";
    private static final Map<String, Map<String, String>> CACHED_TRANSLATIONS = new HashMap<String, Map<String, String>>();

    public static String translate(CommandSourceStack commandSourceStack, String key) {
        ServerPlayer player = commandSourceStack.getPlayer();
        String lang = player != null ? player.clientInformation().language().toLowerCase() : FALLBACK_LANG;
        return TranslationManager.translate(lang, key);
    }

    public static String translate(ServerPlayer player, String key) {
        String lang = player.clientInformation().language().toLowerCase();
        return TranslationManager.translate(lang, key);
    }

    public static String translate(String lang, String key) {
        String result;
        Map<String, String> langMap = TranslationManager.readLanguageFile(lang);
        if (langMap != null && (result = langMap.get(key)) != null) {
            return result;
        }
        String fallback = TranslationManager.readLanguageFile(FALLBACK_LANG).get(key);
        if (fallback != null) {
            return fallback;
        }
        return key;
    }

    public static void initialize() {
        CACHED_TRANSLATIONS.clear();
        TranslationManager.readLanguageFile(FALLBACK_LANG);
    }

    public static Map<String, String> readLanguageFile(String lang) {
        if (CACHED_TRANSLATIONS.containsKey(lang)) {
            return CACHED_TRANSLATIONS.get(lang);
        }
        try {
            String path = "/assets/helpful_commands/lang/" + lang + ".json";
            InputStream inputStream = HelpfulCommands.class.getResourceAsStream(path);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            HashMap<String, String> translations = new HashMap<String, String>();
            json.entrySet().forEach(entry -> {
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    translations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            });
            CACHED_TRANSLATIONS.put(lang, translations);
            return translations;
        }
        catch (Exception e) {
            return lang.equals(FALLBACK_LANG) ? new HashMap() : TranslationManager.readLanguageFile(FALLBACK_LANG);
        }
    }

    public static class TextBuilder {
        private final MutableComponent component = Component.literal((String)"");
        private final String language;

        public TextBuilder(ServerPlayer player) {
            this.language = player != null ? player.clientInformation().language().toLowerCase() : TranslationManager.FALLBACK_LANG;
        }

        public TextBuilder(CommandSourceStack commandSourceStack) {
            this(commandSourceStack.getPlayer());
        }

        public TextBuilder appendLiteral(String literalText) {
            this.component.append((Component)Component.literal((String)literalText));
            return this;
        }

        public TextBuilder appendTranslatable(String translationKey, Component ... components) {
            String translated = TranslationManager.translate(this.language, translationKey);
            String[] split = translated.split("%s", -1);
            int count = 0;
            for (String str : split) {
                this.component.append((Component)Component.literal((String)str));
                if (components == null || count >= components.length) continue;
                this.component.append(components[count]);
                ++count;
            }
            return this;
        }

        public TextBuilder appendComponent(Component component) {
            this.component.append(component);
            return this;
        }

        public TextBuilder appendWhitespace() {
            return this.appendLiteral(" ");
        }

        public TextBuilder appendNewline() {
            return this.appendLiteral("\n");
        }

        public TextBuilder setStyle(Style style) {
            this.component.setStyle(style);
            return this;
        }

        public MutableComponent getComponent() {
            return this.component;
        }
    }

    public static class DeprecatedTextBuilder {
        private final MutableComponent component = Component.literal((String)"");
        private final String language;

        @Deprecated
        public DeprecatedTextBuilder(ServerPlayer player) {
            this.language = player != null ? player.clientInformation().language().toLowerCase() : TranslationManager.FALLBACK_LANG;
        }

        @Deprecated
        public DeprecatedTextBuilder(CommandSourceStack commandSourceStack) {
            this(commandSourceStack.getPlayer());
        }

        public DeprecatedTextBuilder appendLiteral(String literalText) {
            return this.appendLiteral(literalText, Style.EMPTY);
        }

        public DeprecatedTextBuilder appendLiteral(String literalText, Style style) {
            this.component.append((Component)Component.literal((String)literalText).setStyle(style));
            return this;
        }

        public DeprecatedTextBuilder appendTranslatable(String translationKey) {
            return this.appendTranslatable(translationKey, Style.EMPTY);
        }

        public DeprecatedTextBuilder appendTranslatable(String translationKey, Style style) {
            String translated = TranslationManager.translate(this.language, translationKey);
            this.component.append((Component)Component.literal((String)translated).setStyle(style));
            return this;
        }

        public DeprecatedTextBuilder appendComponent(Component component) {
            this.component.append(component);
            return this;
        }

        public DeprecatedTextBuilder appendWhitespace() {
            return this.appendLiteral(" ", Style.EMPTY);
        }

        public DeprecatedTextBuilder appendNewline() {
            return this.appendLiteral("\n", Style.EMPTY);
        }

        public DeprecatedTextBuilder setStyle(Style style) {
            this.component.setStyle(style);
            return this;
        }

        public MutableComponent getComponent() {
            return this.component;
        }
    }
}

