/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.style;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;

public abstract class HelpfulCommandsStyle {
    public abstract String getDisplayName();

    public String getDescriptionTranslationKey() {
        return "styling.style." + this.getDisplayName() + ".description";
    }

    public abstract TextStyles getTextStyles();

    public abstract TextDecorators getTextDecorators();

    public static abstract class TextDecorators {
        public String getTitlePrefix() {
            return "\u00ab ";
        }

        public String getTitleSeparator() {
            return " || ";
        }

        public String getTitleSuffix() {
            return " \u00bb";
        }

        public String getBulletPoint() {
            return "\u2022 ";
        }

        public String getSeparator() {
            return " | ";
        }

        public String getButtonPrefix() {
            return "[";
        }

        public String getButtonSuffix() {
            return "]";
        }

        public String getButtonSeparator() {
            return " ";
        }

        public String getDisabled() {
            return "\u274c";
        }

        public String getEnabled() {
            return "\u2714";
        }

        public String getRemove() {
            return "\ud83d\uddd1";
        }

        public String getEdit() {
            return "\ud83d\udd8d";
        }

        public String getTeleport() {
            return "\u27a1";
        }

        public String getCategoryStartingChar() {
            return "\u250f";
        }

        public String getCategoryTrailingChar() {
            return "\u2520\u203a ";
        }

        public String getCategoryEndingChar() {
            return "\u2517\u203a ";
        }
    }

    public static abstract class TextStyles {
        public Style getSuccess() {
            return Style.EMPTY.withColor(ChatFormatting.GREEN);
        }

        public Style getWarning() {
            return Style.EMPTY.withColor(ChatFormatting.YELLOW);
        }

        public Style getPrimary() {
            return Style.EMPTY.withColor(ChatFormatting.GOLD);
        }

        public Style getSecondary() {
            return Style.EMPTY.withColor(ChatFormatting.AQUA);
        }

        public Style getTertiary() {
            return Style.EMPTY.withColor(ChatFormatting.YELLOW);
        }

        public Style getSubtle() {
            return Style.EMPTY.withColor(ChatFormatting.GRAY);
        }

        public Style getDangerousAction() {
            return Style.EMPTY.withColor(ChatFormatting.RED);
        }

        public Style getButton() {
            return this.getPrimary();
        }

        public Style getTitlePrimary() {
            return this.getPrimary().withBold(Boolean.valueOf(true));
        }

        public Style getTitleSecondary() {
            return this.getSecondary();
        }

        public Style getAffectedNeutral() {
            return Style.EMPTY.withColor(ChatFormatting.YELLOW);
        }

        public Style getAffectedPositive() {
            return Style.EMPTY.withColor(ChatFormatting.GREEN);
        }

        public Style getAffectedNegative() {
            return Style.EMPTY.withColor(ChatFormatting.RED);
        }

        public Style getAvailable() {
            return Style.EMPTY.withColor(ChatFormatting.GREEN);
        }

        public Style getUnavailable() {
            return Style.EMPTY.withColor(ChatFormatting.RED);
        }

        public Style getEnabled() {
            return Style.EMPTY.withColor(ChatFormatting.GREEN);
        }

        public Style getDisabled() {
            return Style.EMPTY.withColor(ChatFormatting.RED);
        }

        public Style getAxisX() {
            return Style.EMPTY.withColor(ChatFormatting.RED);
        }

        public Style getAxisY() {
            return Style.EMPTY.withColor(ChatFormatting.GREEN);
        }

        public Style getAxisZ() {
            return Style.EMPTY.withColor(ChatFormatting.BLUE);
        }
    }
}

