/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands;

import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.manager.ConfigManager;
import com.expecticament.helpfulcommands.manager.HomeManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.manager.WarpManager;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelpfulCommands {
    public static final String MOD_ID = "helpful_commands";
    public static final String FOLDER_NAME = "helpful_commands4";
    private static String modVersion;
    public static final Logger LOGGER;

    public static void init(String version) {
        modVersion = version;
    }

    public static void onServerStarting(MinecraftServer server) {
        ConfigManager.initialize(server);
        StylingManager.initialize();
        HomeManager.initialize(server);
        WarpManager.initialize(server);
        TranslationManager.initialize();
        ServerLevelHelper.initialize(server);
        LOGGER.info("");
        LOGGER.info("H   H  CCCCC  | ");
        LOGGER.info("H   H  C      |  Thank you for using");
        LOGGER.info("HHHHH  C      |  Helpful Commands");
        LOGGER.info("H   H  C      |  " + modVersion);
        LOGGER.info("H   H  CCCCC  | ");
        LOGGER.info("");
    }

    public static void save(MinecraftServer minecraftServer) {
        ConfigManager.writeToDisk();
        HomeManager.writeToDisk();
        WarpManager.writeToDisk();
    }

    public static String getModVersion() {
        return modVersion;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

