/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.abilities;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1656;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CMD_god
extends HelpfulCommandsCommand {
    public CMD_god(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"state", (ArgumentType)BoolArgumentType.bool()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).requires(src -> this.canExecute((class_2168)src, "other"))).executes(ctx -> this.execute((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"state"), class_2186.method_9312((CommandContext)ctx, (String)"players"))))).executes(ctx -> this.execute((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"state"))))).executes(this::execute));
    }

    @Override
    public boolean canExecuteBaseCommand(class_2168 source) {
        return this.canExecute(source) || this.canExecute(source, "other");
    }

    private int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.execute(ctx, null, null);
    }

    private int execute(CommandContext<class_2168> ctx, Boolean state) throws CommandSyntaxException {
        return this.execute(ctx, state, null);
    }

    private int execute(CommandContext<class_2168> ctx, Boolean state, Collection<class_3222> players) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        ArrayList targets = new ArrayList(Objects.requireNonNullElse(players, List.of()));
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.method_9225().method_64395().method_8355(class_1928.field_19400);
        if (targets.isEmpty() || targets.size() == 1 && sourcePlayer != null && targets.contains(sourcePlayer)) {
            if (sourcePlayer == null) {
                throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)class_2561.method_43470((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
            }
            this.toggleInvulnerabilityAndSendMessage(sourcePlayer, src, state, textStyles, commandFeedback, true, true);
            return 1;
        }
        List<class_3222> affected = targets.stream().filter(p -> this.toggleInvulnerabilityAndSendMessage((class_3222)p, src, state, textStyles, commandFeedback, p == sourcePlayer, false)).toList();
        if (affected.isEmpty()) {
            throw class_2186.field_9856.create();
        }
        class_5250 stateText = class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.god.output.success." + String.valueOf(state).toLowerCase()));
        class_5250 affectedText = class_2561.method_43473();
        if (affected.size() == 1) {
            affectedText.method_10852(StylingHelper.getAffectedEntityNameText((class_1297)affected.getFirst()));
        } else {
            affectedText.method_10852(StylingHelper.getAffectedEntitiesNumberText(affected)).method_27693(" ").method_27693(TranslationManager.translate(src, "commands.helpful_commands.god.output.success.multiple"));
        }
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.god.output.success.other", new class_2561[]{stateText, affectedText});
        textBuilder.setStyle(textStyles.getSuccess());
        src.method_9226(textBuilder::getComponent, true);
        return affected.size();
    }

    private boolean toggleInvulnerabilityAndSendMessage(class_3222 player, class_2168 commandSourceStack, Boolean state, HelpfulCommandsStyle.TextStyles textStyles, boolean commandFeedback, boolean isSource, boolean feedbackSource) {
        boolean finalState;
        class_1656 abilities = player.method_31549();
        boolean bl = state != null ? state : (finalState = !abilities.field_7480);
        if (finalState != abilities.field_7480) {
            abilities.field_7480 = finalState;
            player.method_7355();
            if (commandFeedback) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(player);
                textBuilder.setStyle(isSource ? (finalState ? textStyles.getAffectedPositive() : textStyles.getAffectedNeutral()) : textStyles.getAffectedNeutral());
                textBuilder.appendTranslatable("commands.helpful_commands.god.output.success.affected", new class_2561[]{class_2561.method_43470((String)TranslationManager.translate(player, "commands.helpful_commands.god.output.success." + String.valueOf(finalState).toLowerCase()))});
                if (isSource) {
                    if (feedbackSource) {
                        commandSourceStack.method_9226(textBuilder::getComponent, true);
                    }
                } else {
                    player.method_64398((class_2561)textBuilder.getComponent());
                }
            }
            return true;
        }
        return false;
    }
}

