/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.itemsAndInventory;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_9334;

public class CMD_rename
extends HelpfulCommandsCommand {
    public CMD_rename(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"new_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.execute((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"new_name")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).requires(src -> this.canExecute((class_2168)src, "other"))).executes(ctx -> this.execute((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"new_name"), class_2186.method_9312((CommandContext)ctx, (String)"players"))))));
    }

    @Override
    public boolean canExecuteBaseCommand(class_2168 source) {
        return this.canExecute(source) || this.canExecute(source, "other");
    }

    private int execute(CommandContext<class_2168> ctx, String newName) throws CommandSyntaxException {
        return this.execute(ctx, newName, null);
    }

    private int execute(CommandContext<class_2168> ctx, String newName, Collection<class_3222> players) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        ArrayList targets = new ArrayList(Objects.requireNonNullElse(players, List.of()));
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.method_9225().method_64395().method_8355(class_1928.field_19400);
        if (targets.isEmpty() || targets.size() == 1 && sourcePlayer != null && targets.contains(sourcePlayer)) {
            if (sourcePlayer == null) {
                throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)class_2561.method_43470((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
            }
            this.renameAndSendMessage(sourcePlayer, src, newName, textStyles, commandFeedback, true, true);
            return 1;
        }
        HashMap<class_3222, String> affected = new HashMap<class_3222, String>();
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            class_3222 player;
            class_1799 itemStack = this.renameAndSendMessage(player, src, newName, textStyles, commandFeedback, (player = (class_3222)iterator.next()) == sourcePlayer, false);
            if (itemStack.method_7960()) continue;
            affected.put(player, itemStack.method_63693().getString());
        }
        if (affected.isEmpty()) {
            throw class_2186.field_9856.create();
        }
        class_5250 newItemNameComponent = class_2561.method_43470((String)newName).method_10862(textStyles.getPrimary());
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.setStyle(textStyles.getSuccess());
        if (newName.isEmpty()) {
            textBuilder.appendTranslatable("commands.helpful_commands.rename.remove.output.success.other.part1").appendWhitespace();
            if (affected.size() == 1) {
                affectedPlayerNameText = StylingHelper.getAffectedEntityNameText((class_1297)affected.keySet().iterator().next());
                class_5250 itemNameText = class_2561.method_43470((String)((String)affected.values().iterator().next())).method_10862(textStyles.getPrimary());
                textBuilder.appendComponent(affectedPlayerNameText).appendTranslatable("commands.helpful_commands.rename.remove.output.success.other.part2.single").appendWhitespace().appendComponent((class_2561)itemNameText);
            } else {
                textBuilder.appendComponent(StylingHelper.getAffectedEntitiesNumberText(affected)).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.remove.output.success.other.part2.multiple");
            }
        } else {
            textBuilder.appendTranslatable("commands.helpful_commands.rename.output.success.other.part1").appendWhitespace();
            if (affected.size() == 1) {
                affectedPlayerNameText = StylingHelper.getAffectedEntityNameText((class_1297)affected.keySet().iterator().next());
                class_5250 itemNameText = class_2561.method_43470((String)((String)affected.values().iterator().next())).method_10862(textStyles.getPrimary());
                textBuilder.appendComponent(affectedPlayerNameText).appendTranslatable("commands.helpful_commands.rename.output.success.other.part2.single").appendWhitespace().appendComponent((class_2561)itemNameText).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.self.part2").appendWhitespace().appendComponent((class_2561)newItemNameComponent);
            } else {
                textBuilder.appendComponent(StylingHelper.getAffectedEntitiesNumberText(affected)).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.other.part2.multiple").appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.self.part2").appendWhitespace().appendComponent((class_2561)newItemNameComponent);
            }
        }
        src.method_9226(textBuilder::getComponent, true);
        return affected.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private class_1799 renameAndSendMessage(class_3222 player, class_2168 commandSourceStack, String newName, HelpfulCommandsStyle.TextStyles textStyles, boolean commandFeedback, boolean isSource, boolean feedbackSource) {
        String oldItemName;
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7960()) return class_1799.field_8037;
        class_2561 oldCustomName = itemStack.method_65130();
        String string = oldItemName = oldCustomName != null ? oldCustomName.getString() : itemStack.method_63693().getString();
        if (oldItemName.equals(newName)) {
            return class_1799.field_8037;
        }
        class_5250 oldItemNameComponent = class_2561.method_43470((String)oldItemName).method_10862(textStyles.getPrimary());
        class_5250 newItemNameComponent = class_2561.method_43470((String)newName).method_10862(textStyles.getPrimary());
        boolean remove = newName.isEmpty();
        if (remove) {
            if (itemStack.method_58694(class_9334.field_49631) == null) return class_1799.field_8037;
            itemStack.method_57381(class_9334.field_49631);
        } else {
            itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)newName));
        }
        if (!commandFeedback) return itemStack;
        if (isSource) {
            if (!feedbackSource) return itemStack;
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
            textBuilder.setStyle(textStyles.getAffectedPositive());
            if (remove) {
                textBuilder.appendTranslatable("commands.helpful_commands.rename.remove.output.success.self").appendWhitespace().appendComponent((class_2561)oldItemNameComponent);
            } else {
                textBuilder.appendTranslatable("commands.helpful_commands.rename.output.success.self.part1").appendWhitespace().appendComponent((class_2561)oldItemNameComponent).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.self.part2").appendWhitespace().appendComponent((class_2561)newItemNameComponent);
            }
            commandSourceStack.method_9226(textBuilder::getComponent, true);
            return itemStack;
        } else {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
            textBuilder.setStyle(textStyles.getAffectedNeutral());
            if (remove) {
                textBuilder.appendTranslatable("commands.helpful_commands.rename.remove.output.success.affected.part1").appendWhitespace().appendComponent((class_2561)oldItemNameComponent).appendTranslatable("commands.helpful_commands.rename.remove.output.success.affected.part2");
            } else {
                textBuilder.appendTranslatable("commands.helpful_commands.rename.output.success.affected.part1").appendWhitespace().appendComponent((class_2561)oldItemNameComponent).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.affected.part2").appendWhitespace().appendComponent((class_2561)newItemNameComponent);
            }
            player.method_64398((class_2561)textBuilder.getComponent());
        }
        return itemStack;
    }
}

