/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.main;

import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.PermissionHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ConfigManager;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.expecticament.helpfulcommands.suggestionProvider.HelpfulCommandsCommandSuggestionProvider;
import com.expecticament.helpfulcommands.suggestionProvider.StyleSuggestionProvider;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import java.net.URI;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CMD_hc
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType INVALID_HC_COMMAND = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType STYLE_DOESNT_EXIST = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType STYLE_ALREADY_IN_USE = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType COMMAND_NOT_CONFIGURABLE = new SimpleCommandExceptionType((Message)class_2561.method_43473());

    public CMD_hc(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        LiteralArgumentBuilder configField = class_2170.method_9247((String)"field");
        configField.requires(src -> PermissionHelper.canConfigure(src, "field"));
        for (Map.Entry<String, ConfigManager.ConfigFieldProperties> entry : ConfigManager.DEFAULT_FIELDS.entrySet()) {
            String name = entry.getKey();
            ConfigManager.ConfigFieldProperties properties = entry.getValue();
            LiteralArgumentBuilder field = class_2170.method_9247((String)entry.getKey());
            LiteralArgumentBuilder setArgument = class_2170.method_9247((String)"set");
            switch (properties.valueType) {
                case Double: {
                    setArgument.then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)properties.min, (double)properties.max)).executes(ctx -> this.setConfigField((CommandContext<class_2168>)ctx, name, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value"))));
                    break;
                }
                case Integer: {
                    setArgument.then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)properties.min.intValue(), (int)properties.max.intValue())).executes(ctx -> this.setConfigField((CommandContext<class_2168>)ctx, name, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"))));
                    break;
                }
                case Boolean: {
                    setArgument.then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.setConfigField((CommandContext<class_2168>)ctx, name, BoolArgumentType.getBool((CommandContext)ctx, (String)"value"))));
                }
            }
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)field.then((ArgumentBuilder)setArgument)).then(class_2170.method_9247((String)"reset").executes(ctx -> this.setConfigField((CommandContext<class_2168>)ctx, name, properties.defaultValue)))).then(class_2170.method_9247((String)"query").executes(ctx -> this.queryConfigField((CommandContext<class_2168>)ctx, name)));
            configField.then((ArgumentBuilder)field);
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandData.getName()).then(class_2170.method_9247((String)"about").executes(this::about))).then(class_2170.method_9247((String)"commandList").executes(ctx -> this.commandList((CommandContext<class_2168>)ctx, dispatcher)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(PermissionHelper::canConfigure)).executes(this::config)).then((ArgumentBuilder)configField)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"command").requires(src -> PermissionHelper.canConfigure(src, "command") || PermissionHelper.canConfigure(src, "command.state"))).then(class_2170.method_9247((String)"state").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.word()).requires(src -> PermissionHelper.canConfigure(src, "command.state"))).suggests((SuggestionProvider)new HelpfulCommandsCommandSuggestionProvider()).then(class_2170.method_9244((String)"new_state", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.setCommandState((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"command"), BoolArgumentType.getBool((CommandContext)ctx, (String)"new_state"))))).executes(ctx -> this.queryCommandState((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"command"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"styling").requires(src -> PermissionHelper.canConfigure(src, "styling"))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"style").then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"style_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new StyleSuggestionProvider()).executes(ctx -> this.setStyle((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"style_name")))))).then(class_2170.method_9247((String)"query").executes(this::queryStyle)))))).executes(this::about));
    }

    @Override
    public boolean canExecuteBaseCommand(class_2168 source) {
        return true;
    }

    private int about(CommandContext<class_2168> ctx) {
        class_5250 modrinthComponent;
        class_5250 curseForgeComponent;
        class_5250 gitHubComponent;
        class_5250 docsComponent;
        class_5250 authorComponent;
        class_2168 src = (class_2168)ctx.getSource();
        boolean isPlayer = src.method_43737();
        HelpfulCommandsStyle hcStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = hcStyle.getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = hcStyle.getTextDecorators();
        class_2568.class_10613 linkHoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "hover.helpful_commands.clickToOpenTheLink")));
        class_2561 quickActionCommandListBtn = StylingHelper.getButton("\ud83d\udcc3", (class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.actions.commandList")), (class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.hover.commandList"))), (class_2558)new class_2558.class_10609("/hc commandList"));
        class_2561 quickActionConfigureBtn = StylingHelper.getButton("\ud83d\udd27", (class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.actions.config")), (class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.hover.config"))), (class_2558)new class_2558.class_10609("/hc config"));
        String linkSeparator = isPlayer ? " " + textDecorators.getBulletPoint() : "\n";
        String authorLink = "https://expecticament.com";
        String docsLink = "https://helpfulcommands.expecticament.com";
        String gitHubLink = "https://github.com/Expecticament/helpful-commands";
        String curseForgeLink = "https://www.curseforge.com/minecraft/mc-mods/helpful-commands";
        String modrinthLink = "https://modrinth.com/mod/helpful-commands";
        if (isPlayer) {
            authorComponent = class_2561.method_43470((String)"Expecticament").method_10862(textStyles.getSecondary().method_30938(Boolean.valueOf(true)).method_10949((class_2568)linkHoverEvent).method_10958((class_2558)new class_2558.class_10608(URI.create(authorLink))));
            docsComponent = class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.docs")).method_10862(textStyles.getSecondary().method_30938(Boolean.valueOf(true)).method_10949((class_2568)linkHoverEvent).method_10958((class_2558)new class_2558.class_10608(URI.create(docsLink))));
            gitHubComponent = class_2561.method_43470((String)"GitHub").method_10862(textStyles.getSecondary().method_30938(Boolean.valueOf(true)).method_10949((class_2568)linkHoverEvent).method_10958((class_2558)new class_2558.class_10608(URI.create(gitHubLink))));
            curseForgeComponent = class_2561.method_43470((String)"CurseForge").method_10862(textStyles.getSecondary().method_30938(Boolean.valueOf(true)).method_10949((class_2568)linkHoverEvent).method_10958((class_2558)new class_2558.class_10608(URI.create(curseForgeLink))));
            modrinthComponent = class_2561.method_43470((String)"Modrinth").method_10862(textStyles.getSecondary().method_30938(Boolean.valueOf(true)).method_10949((class_2568)linkHoverEvent).method_10958((class_2558)new class_2558.class_10608(URI.create(modrinthLink))));
        } else {
            authorComponent = class_2561.method_43470((String)"Expecticament (%s)".formatted(authorLink));
            docsComponent = class_2561.method_43470((String)("\n" + TranslationManager.translate(src, "commands.helpful_commands.hc.about.docs"))).method_27693(": %s".formatted(docsLink));
            gitHubComponent = class_2561.method_43470((String)"GitHub: %s".formatted(gitHubLink));
            curseForgeComponent = class_2561.method_43470((String)"CurseForge: %s".formatted(curseForgeLink));
            modrinthComponent = class_2561.method_43470((String)"Modrinth: %s".formatted(modrinthLink));
        }
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.appendComponent(StylingHelper.getTitle((class_2561)class_2561.method_43470((String)"Helpful Commands"), (class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.title")))).appendNewline().appendWhitespace().appendTranslatable("modmenu.descriptionTranslation.helpful_commands").appendNewline().appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("commands.helpful_commands.hc.about.version", textStyles.getTertiary()).appendWhitespace().appendLiteral(HelpfulCommands.getModVersion(), textStyles.getSecondary()).appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("commands.helpful_commands.hc.about.author", textStyles.getTertiary()).appendWhitespace().appendComponent((class_2561)authorComponent).appendNewline().appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("commands.helpful_commands.hc.about.links", textStyles.getTertiary()).appendWhitespace().appendComponent((class_2561)docsComponent).appendLiteral(linkSeparator).appendComponent((class_2561)gitHubComponent).appendLiteral(linkSeparator).appendComponent((class_2561)curseForgeComponent).appendLiteral(linkSeparator).appendComponent((class_2561)modrinthComponent).appendNewline().appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("commands.helpful_commands.hc.about.actions", textStyles.getTertiary());
        if (isPlayer) {
            textBuilder.appendWhitespace().appendComponent(quickActionCommandListBtn);
            if (PermissionHelper.canConfigure(src)) {
                textBuilder.appendWhitespace().appendComponent(quickActionConfigureBtn);
            }
        } else {
            textBuilder.appendNewline().appendTranslatable("commands.helpful_commands.hc.about.actions.commandList").appendLiteral(": /hc commandList").appendNewline().appendTranslatable("commands.helpful_commands.hc.about.actions.config").appendLiteral(": /hc config");
        }
        src.method_45068((class_2561)textBuilder.getComponent());
        return 1;
    }

    private int commandList(CommandContext<class_2168> ctx, CommandDispatcher<class_2168> dispatcher) {
        class_2168 src = (class_2168)ctx.getSource();
        HelpfulCommandsStyle hcStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = hcStyle.getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = hcStyle.getTextDecorators();
        class_2583 categoryStyle = textStyles.getTertiary();
        boolean toggleStateCommandPermission = PermissionHelper.canConfigure(src, "command.state");
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.appendComponent(StylingHelper.getTitle((class_2561)class_2561.method_43470((String)"Helpful Commands"), (class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.commandList.title"))));
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        for (Map.Entry<ModCommandManager.CommandCategory, List<HelpfulCommandsCommand>> entry : ModCommandManager.getCommandListByCategory().entrySet()) {
            if (entry.getKey().equals((Object)ModCommandManager.CommandCategory.MAIN)) continue;
            textBuilder.appendNewline().appendLiteral(textDecorators.getCategoryStartingChar(), categoryStyle).appendTranslatable("command.category.helpful_commands." + entry.getKey().toString().toLowerCase(), categoryStyle);
            HelpfulCommandsCommand lastCommand = entry.getValue().getLast();
            for (HelpfulCommandsCommand command : entry.getValue()) {
                ModCommandManager.CommandData cmdData = command.getCommandData();
                boolean enabled = config.getCommandState(cmdData.getName());
                boolean hasPerms = command.canExecuteBaseCommand(src);
                boolean canUse = enabled && hasPerms;
                textBuilder.appendNewline().appendLiteral(command.equals(lastCommand) ? textDecorators.getCategoryEndingChar() : textDecorators.getCategoryTrailingChar(), categoryStyle);
                if (toggleStateCommandPermission) {
                    class_2568 cmdStateHoverEvent = this.getCommandStateHoverEvent(src, textStyles, cmdData.getName(), enabled);
                    class_2558.class_10609 cmdStateClickEvent = new class_2558.class_10609("/hc config command state " + cmdData.getName() + " " + String.valueOf(!enabled).toLowerCase());
                    class_2583 cmdStateStyle = (enabled ? textStyles.getEnabled() : textStyles.getDisabled()).method_10949(cmdStateHoverEvent).method_10958((class_2558)cmdStateClickEvent);
                    textBuilder.appendComponent(StylingHelper.getButton((class_2561)class_2561.method_43470((String)(enabled ? textDecorators.getEnabled() : textDecorators.getDisabled())), cmdStateStyle)).appendWhitespace();
                }
                class_2568 cmdNameHoverEvent = this.getCommandHoverEvent(src, dispatcher, textStyles, command, hasPerms, enabled);
                class_2558.class_10610 cmdNameClickEvent = canUse ? new class_2558.class_10610("/" + cmdData.getName() + " ") : null;
                class_2583 cmdNameStyle = (canUse ? textStyles.getAvailable() : textStyles.getUnavailable()).method_10949(cmdNameHoverEvent).method_10958((class_2558)cmdNameClickEvent);
                textBuilder.appendLiteral("/" + cmdData.getName(), cmdNameStyle);
            }
        }
        src.method_45068((class_2561)textBuilder.getComponent());
        return 1;
    }

    private class_2568 getCommandHoverEvent(class_2168 src, CommandDispatcher<class_2168> dispatcher, HelpfulCommandsStyle.TextStyles textStyles, HelpfulCommandsCommand command, boolean hasPerms, boolean enabled) {
        String commandName = command.getCommandData().getName();
        boolean canUse = enabled && hasPerms;
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.appendLiteral("/" + commandName, canUse ? textStyles.getAvailable() : textStyles.getUnavailable()).appendNewline().appendTranslatable("commands.helpful_commands." + commandName + ".description");
        if (canUse) {
            Map usages;
            class_5250 usagesText = class_2561.method_43473().method_10862(textStyles.getSubtle());
            CommandNode node = dispatcher.getRoot().getChild(commandName);
            if (node != null && !(usages = dispatcher.getSmartUsage(node, (Object)src)).isEmpty()) {
                usagesText.method_27693("\n");
                for (String usage : usages.values()) {
                    usagesText.method_10852((class_2561)class_2561.method_43470((String)("\n/" + commandName + " " + usage)));
                }
            }
            textBuilder.appendComponent((class_2561)usagesText);
        } else {
            textBuilder.appendNewline().appendNewline().appendTranslatable("commands.helpful_commands.hc.commandList.cantUse", textStyles.getUnavailable()).appendWhitespace().appendLiteral(TranslationManager.translate(src, !enabled ? "error.helpful_commands.commandDisabled" : "error.helpful_commands.notPermitted").toLowerCase(), textStyles.getUnavailable());
        }
        return new class_2568.class_10613((class_2561)textBuilder.getComponent());
    }

    private class_2568 getCommandStateHoverEvent(class_2168 source, HelpfulCommandsStyle.TextStyles textStyles, String commandName, boolean currentState) {
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(source);
        textBuilder.appendTranslatable("helpful_commands.common." + (currentState ? "enabled" : "disabled"), currentState ? textStyles.getEnabled() : textStyles.getDisabled()).appendNewline().appendNewline().appendTranslatable("commands.helpful_commands.hc.commandList.clickToToggleCommand.part1").appendWhitespace().appendTranslatable("commands.helpful_commands.hc.commandList.clickToToggleCommand.part2." + String.valueOf(currentState).toLowerCase()).appendWhitespace().appendLiteral("/" + commandName, textStyles.getPrimary()).appendWhitespace().appendTranslatable("commands.helpful_commands.hc.commandList.clickToToggleCommand.part3");
        return new class_2568.class_10613((class_2561)textBuilder.getComponent());
    }

    private int config(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        boolean isPlayer = src.method_43737();
        HelpfulCommandsStyle currentStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = currentStyle.getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = currentStyle.getTextDecorators();
        class_5250 bulletPoint = class_2561.method_43470((String)textDecorators.getBulletPoint()).method_10862(textStyles.getTertiary());
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendComponent(StylingHelper.getTitle((class_2561)class_2561.method_43470((String)"Helpful Commands"), (class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.title"))));
        if (PermissionHelper.canConfigure(src, "command") || PermissionHelper.canConfigure(src, "command.state")) {
            textBuilder.appendNewline().appendNewline().appendComponent((class_2561)bulletPoint).appendComponent((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.command.title")).method_10862(textStyles.getTertiary())).appendNewline().appendWhitespace().appendTranslatable("commands.helpful_commands.hc.config.command.description", new class_2561[]{class_2561.method_43470((String)"/hc config command").method_10862(textStyles.getSecondary().method_10958((class_2558)new class_2558.class_10610("/hc config command ")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "hover.helpful_commands.clickToPasteCommand")))))});
            if (isPlayer) {
                class_2561 commandListBtn = StylingHelper.getButton("\ud83d\udcc3", (class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.actions.commandList")), (class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.hover.commandList"))), (class_2558)new class_2558.class_10609("/hc commandList"));
                textBuilder.appendNewline().appendWhitespace().appendTranslatable("Tip: Use %s for quick and easy command configuration", commandListBtn);
            }
        }
        if (PermissionHelper.canConfigure(src, "field")) {
            textBuilder.appendNewline().appendNewline().appendComponent((class_2561)bulletPoint).appendComponent((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.field.title")).method_10862(textStyles.getTertiary())).appendNewline().appendWhitespace().appendTranslatable("commands.helpful_commands.hc.config.field.description", new class_2561[]{class_2561.method_43470((String)"/hc config field").method_10862(textStyles.getSecondary().method_10958((class_2558)new class_2558.class_10610("/hc config field ")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "hover.helpful_commands.clickToPasteCommand")))))});
        }
        if (PermissionHelper.canConfigure(src, "styling")) {
            textBuilder.appendNewline().appendNewline().appendComponent((class_2561)bulletPoint).appendComponent((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.styling.title")).method_10862(textStyles.getTertiary())).appendNewline().appendWhitespace().appendTranslatable("commands.helpful_commands.hc.config.styling.description", new class_2561[]{class_2561.method_43470((String)"/hc config styling").method_10862(textStyles.getSecondary().method_10958((class_2558)new class_2558.class_10610("/hc config styling ")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "hover.helpful_commands.clickToPasteCommand")))))});
        }
        src.method_45068((class_2561)textBuilder.getComponent());
        return 1;
    }

    private int setStyle(CommandContext<class_2168> ctx, String styleName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle currentStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = currentStyle.getTextStyles();
        class_5250 styleNameText = class_2561.method_43470((String)styleName).method_10862(textStyles.getPrimary());
        if (currentStyle.getDisplayName().equals(styleName)) {
            throw new CommandSyntaxException((CommandExceptionType)STYLE_ALREADY_IN_USE, (Message)new TranslationManager.TextBuilder(src).appendTranslatable("commands.helpful_commands.hc.config.styling.style.set.error.styleAlreadyInUse", new class_2561[]{styleNameText}).getComponent());
        }
        try {
            StylingManager.setCurrentStyle(styleName);
            currentStyle = StylingManager.getCurrentStyle();
            textStyles = currentStyle.getTextStyles();
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.hc.config.styling.style.set", new class_2561[]{styleNameText}).setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
            return 1;
        }
        catch (StylingManager.StyleDoesntExistException e) {
            throw new CommandSyntaxException((CommandExceptionType)STYLE_DOESNT_EXIST, (Message)new TranslationManager.TextBuilder(src).appendTranslatable("commands.helpful_commands.hc.config.styling.style.set.error.styleDoesntExist", new class_2561[]{styleNameText}).getComponent());
        }
    }

    private int queryStyle(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle currentStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = currentStyle.getTextStyles();
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.hc.config.styling.style.query", new class_2561[]{class_2561.method_43470((String)currentStyle.getDisplayName()).method_10862(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
        src.method_9226(textBuilder::getComponent, true);
        return 1;
    }

    private int setCommandState(CommandContext<class_2168> ctx, String command, boolean newState) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean valid = false;
        for (HelpfulCommandsCommand hcCmd : ModCommandManager.getCommandList()) {
            ModCommandManager.CommandData data = hcCmd.getCommandData();
            if (!data.getName().equals(command)) continue;
            if (data.getCategory() == ModCommandManager.CommandCategory.MAIN) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.error.commandNotConfigurable", new class_2561[]{class_2561.method_43470((String)command).method_10862(textStyles.getPrimary())});
                throw new CommandSyntaxException((CommandExceptionType)COMMAND_NOT_CONFIGURABLE, (Message)textBuilder.getComponent());
            }
            valid = true;
            break;
        }
        if (!valid) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.error.invalidCommand", new class_2561[]{class_2561.method_43470((String)command).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)INVALID_HC_COMMAND, (Message)textBuilder.getComponent());
        }
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        if (config.setCommandState(command, newState)) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.state.set", new class_2561[]{class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.command.state." + String.valueOf(newState).toLowerCase())), class_2561.method_43470((String)("/" + command)).method_10862(textStyles.getPrimary())});
            textBuilder.setStyle(newState ? textStyles.getEnabled() : textStyles.getDisabled());
            ModCommandManager.sendCommandsToEveryone(src);
            src.method_9226(textBuilder::getComponent, true);
            return 1;
        }
        return 0;
    }

    private int queryCommandState(CommandContext<class_2168> ctx, String command) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean valid = false;
        for (HelpfulCommandsCommand hcCmd : ModCommandManager.getCommandList()) {
            ModCommandManager.CommandData data = hcCmd.getCommandData();
            if (!data.getName().equals(command)) continue;
            if (data.getCategory() == ModCommandManager.CommandCategory.MAIN) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.error.commandNotConfigurable", new class_2561[]{class_2561.method_43470((String)("/" + command)).method_10862(textStyles.getPrimary())});
                throw new CommandSyntaxException((CommandExceptionType)COMMAND_NOT_CONFIGURABLE, (Message)textBuilder.getComponent());
            }
            valid = true;
            break;
        }
        if (!valid) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.error.invalidCommand", new class_2561[]{class_2561.method_43470((String)("/" + command)).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)INVALID_HC_COMMAND, (Message)textBuilder.getComponent());
        }
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        boolean state = config.getCommandState(command);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.state.query", new class_2561[]{class_2561.method_43470((String)("/" + command)).method_10862(textStyles.getPrimary()), class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.command.state." + String.valueOf(state).toLowerCase()).toLowerCase())});
        textBuilder.setStyle(state ? textStyles.getEnabled() : textStyles.getDisabled());
        src.method_9226(textBuilder::getComponent, true);
        return 1;
    }

    private int setConfigField(CommandContext<class_2168> ctx, String field, Object newValue) {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        config.writeField(field, newValue);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.hc.config.field.set", new class_2561[]{class_2561.method_43470((String)field).method_10862(textStyles.getPrimary()), class_2561.method_43470((String)String.valueOf(newValue)).method_10862(textStyles.getPrimary())});
        textBuilder.setStyle(textStyles.getSuccess());
        src.method_9226(textBuilder::getComponent, true);
        return 1;
    }

    private int queryConfigField(CommandContext<class_2168> ctx, String field) {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        Object value = config.readField(field);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.hc.config.field.query", new class_2561[]{class_2561.method_43470((String)field).method_10862(textStyles.getPrimary()), class_2561.method_43470((String)String.valueOf(value)).method_10862(textStyles.getPrimary())});
        textBuilder.setStyle(textStyles.getSuccess());
        src.method_9226(textBuilder::getComponent, true);
        return 1;
    }
}

