/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.movementAndTeleportation;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CMD_dimension
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType FAILED_TO_TELEPORT = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType ALREADY_IN_DIMENSION = new SimpleCommandExceptionType((Message)class_2561.method_43473());

    public CMD_dimension(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).requires(src -> this.canExecute((class_2168)src, "other"))).executes(ctx -> this.executeOther((CommandContext<class_2168>)ctx, class_2181.method_9289((CommandContext)ctx, (String)"dimension"), class_2186.method_9317((CommandContext)ctx, (String)"entities"))))).executes(ctx -> this.executeSelf((CommandContext<class_2168>)ctx, class_2181.method_9289((CommandContext)ctx, (String)"dimension")))));
    }

    @Override
    public boolean canExecuteBaseCommand(class_2168 source) {
        return this.canExecute(source) || this.canExecute(source, "other");
    }

    private int executeSelf(CommandContext<class_2168> ctx, class_3218 serverLevel) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        int result = this.switchDimension((class_1297)sourcePlayer, serverLevel);
        class_2561 dimensionText = this.getDimensionText(serverLevel, textStyles);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (result == 1) {
            textBuilder.appendTranslatable("commands.helpful_commands.dimension.error.alreadyInDimension", dimensionText);
            throw new CommandSyntaxException((CommandExceptionType)ALREADY_IN_DIMENSION, (Message)textBuilder.getComponent());
        }
        if (result == 2) {
            textBuilder.appendTranslatable("commands.helpful_commands.dimension.error.failedToTeleport", dimensionText);
            throw new CommandSyntaxException((CommandExceptionType)FAILED_TO_TELEPORT, (Message)textBuilder.getComponent());
        }
        textBuilder.appendTranslatable("commands.helpful_commands.dimension.success.self", dimensionText);
        textBuilder.setStyle(textStyles.getSuccess());
        src.method_9226(textBuilder::getComponent, true);
        return 1;
    }

    private int executeOther(CommandContext<class_2168> ctx, class_3218 serverLevel, Collection<? extends class_1297> entities) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        if (sourcePlayer != null && entities.size() == 1 && entities.contains(sourcePlayer)) {
            return this.executeSelf(ctx, serverLevel);
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.method_9225().method_64395().method_8355(class_1928.field_19400);
        class_2561 dimensionText = this.getDimensionText(serverLevel, textStyles);
        List<class_1297> affected = entities.stream().filter(entity -> this.switchDimension((class_1297)entity, serverLevel) == 0).peek(entity -> {
            class_3222 player;
            if (entity.method_31747() && commandFeedback && (player = (class_3222)entity) != sourcePlayer) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(player);
                textBuilder.appendTranslatable("commands.helpful_commands.dimension.success.affected", dimensionText).setStyle(textStyles.getAffectedNeutral());
                player.method_64398((class_2561)textBuilder.getComponent());
            }
        }).toList();
        if (affected.isEmpty()) {
            throw class_2186.field_9863.create();
        }
        class_5250 affectedText = class_2561.method_43473();
        if (affected.size() == 1) {
            affectedText.method_10852(StylingHelper.getAffectedEntityNameText(affected.getFirst()));
        } else {
            affectedText.method_10852(StylingHelper.getAffectedEntitiesNumberText(affected)).method_27693(" ").method_27693(TranslationManager.translate(src, "commands.helpful_commands.dimension.success.other.multiple"));
        }
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.dimension.success.other", new class_2561[]{affectedText, dimensionText}).setStyle(textStyles.getSuccess());
        src.method_9226(textBuilder::getComponent, true);
        return affected.size();
    }

    private int switchDimension(class_1297 entity, class_3218 serverLevel) {
        if (entity.method_73183() == serverLevel) {
            return 1;
        }
        class_243 pos = entity.method_73189();
        return entity.method_48105(serverLevel, pos.method_10216(), pos.method_10214(), pos.method_10215(), new HashSet(), entity.method_36454(), entity.method_36455(), false) ? 0 : 2;
    }

    private class_2561 getDimensionText(class_3218 serverLevel, HelpfulCommandsStyle.TextStyles textStyles) {
        return class_2561.method_43470((String)ServerLevelHelper.getLevelLocation(serverLevel)).method_10862(textStyles.getPrimary());
    }
}

