/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.movementAndTeleportation;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.HomeManager;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.expecticament.helpfulcommands.suggestionProvider.HomeNameSuggestionProvider;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2374;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class CMD_home
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType HOME_DOESNT_EXIST = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType HOME_ALREADY_EXISTS = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType HOME_LIMIT_EXCEEDED = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType SAME_NAME_PROVIDED = new SimpleCommandExceptionType((Message)class_2561.method_43473());

    public CMD_home(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        HomeNameSuggestionProvider homeNameSuggestionProvider = new HomeNameSuggestionProvider();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tp").requires(ctx -> this.canExecute((class_2168)ctx, "tp"))).then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)homeNameSuggestionProvider).executes(ctx -> this.teleport((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name")))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.addHome((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)homeNameSuggestionProvider).executes(ctx -> this.removeHome((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name")))))).then(class_2170.method_9247((String)"edit").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)homeNameSuggestionProvider).then(class_2170.method_9247((String)"name").then(class_2170.method_9244((String)"new_name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.editHomeName((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name"), StringArgumentType.getString((CommandContext)ctx, (String)"new_name")))))).then(class_2170.method_9247((String)"location").executes(ctx -> this.editHomeLocation((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name"))))))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"home_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)homeNameSuggestionProvider).executes(ctx -> this.homeInfo((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name"))))));
    }

    @Override
    public boolean canExecuteBaseCommand(class_2168 source) {
        return this.canExecute(source) || this.canExecute(source, "tp");
    }

    private int teleport(CommandContext<class_2168> ctx, String homeName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.Home home = HomeManager.getHome(sourcePlayer, homeName);
            try {
                class_3218 level = ServerLevelHelper.getLevel(home.dimension);
                sourcePlayer.method_48105(level, home.x, home.y, home.z, class_2709.field_54094, sourcePlayer.method_36454(), sourcePlayer.method_36455(), false);
                TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
                textBuilder.appendTranslatable("commands.helpful_commands.home.teleport.output.success.part1").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary()).appendWhitespace().appendTranslatable("commands.helpful_commands.home.teleport.output.success.part2");
                textBuilder.setStyle(textStyles.getSuccess());
                src.method_9226(textBuilder::getComponent, true);
            }
            catch (ServerLevelHelper.UnknownServerLevelException e) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("error.helpful_commands.unknownDimension", new class_2561[]{class_2561.method_43470((String)home.dimension).method_10862(textStyles.getPrimary())});
                throw new CommandSyntaxException((CommandExceptionType)UNKNOWN_DIMENSION, (Message)textBuilder.getComponent());
            }
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int addHome(CommandContext<class_2168> ctx, String homeName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.addHome(sourcePlayer, homeName);
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.add.output.success").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary());
            textBuilder.setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
        }
        catch (HomeManager.HomeAlreadyExistsException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeAlreadyExists");
            throw new CommandSyntaxException((CommandExceptionType)HOME_ALREADY_EXISTS, (Message)textBuilder.getComponent());
        }
        catch (HomeManager.HomeLimitExceededException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.add.output.error.homeLimitExceeded");
            throw new CommandSyntaxException((CommandExceptionType)HOME_LIMIT_EXCEEDED, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int removeHome(CommandContext<class_2168> ctx, String homeName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.removeHome(sourcePlayer, homeName);
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.remove.output.success").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary());
            textBuilder.setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editHomeName(CommandContext<class_2168> ctx, String homeName, String newName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.editHomeName(sourcePlayer, homeName, newName);
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.edit.name.output.success.part1").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary()).appendWhitespace().appendTranslatable("commands.helpful_commands.home.edit.name.output.success.part2").appendWhitespace().appendLiteral(newName, textStyles.getPrimary());
            textBuilder.setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        catch (HomeManager.SameHomeNameProvided e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.edit.name.output.error.sameName");
            throw new CommandSyntaxException((CommandExceptionType)SAME_NAME_PROVIDED, (Message)textBuilder.getComponent());
        }
        catch (HomeManager.HomeAlreadyExistsException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(newName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeAlreadyExists");
            throw new CommandSyntaxException((CommandExceptionType)HOME_ALREADY_EXISTS, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editHomeLocation(CommandContext<class_2168> ctx, String homeName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.editHomeLocation(sourcePlayer, homeName, (class_2374)sourcePlayer.method_73189(), sourcePlayer.method_51469());
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.edit.location.output.success.part1").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary()).appendWhitespace().appendTranslatable("commands.helpful_commands.home.edit.location.output.success.part2");
            textBuilder.setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int homeInfo(CommandContext<class_2168> ctx, String homeName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = StylingManager.getCurrentStyle().getTextDecorators();
        try {
            HomeManager.Home home = HomeManager.getHome(sourcePlayer, homeName);
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            class_2568.class_10613 tpBtnHoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(sourcePlayer, "hover.helpful_commands.clickToTeleport")));
            class_2558.class_10609 tpBtnClickEvent = new class_2558.class_10609("/home tp " + homeName);
            class_2583 tpBtnStyle = textStyles.getSecondary().method_10949((class_2568)tpBtnHoverEvent).method_10958((class_2558)tpBtnClickEvent);
            class_2568.class_10613 editBtnHoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(sourcePlayer, "hover.helpful_commands.clickToEdit")));
            class_2558.class_10610 editBtnClickEvent = new class_2558.class_10610("/home edit " + homeName + " ");
            class_2583 editBtnStyle = textStyles.getTertiary().method_10949((class_2568)editBtnHoverEvent).method_10958((class_2558)editBtnClickEvent);
            class_2568.class_10613 removeBtnHoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(sourcePlayer, "hover.helpful_commands.clickToRemove")));
            class_2558.class_10609 removeBtnClickEvent = new class_2558.class_10609("/home remove " + homeName);
            class_2583 removeBtnStyle = textStyles.getDangerousAction().method_10949((class_2568)removeBtnHoverEvent).method_10958((class_2558)removeBtnClickEvent);
            textBuilder.appendComponent(StylingHelper.getTitle((class_2561)class_2561.method_43470((String)TranslationManager.translate(sourcePlayer, "commands.helpful_commands.home.info.title")), (class_2561)class_2561.method_43470((String)homeName))).appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("helpful_commands.common.position", textStyles.getTertiary()).appendLiteral(": ", textStyles.getTertiary()).appendComponent(StylingHelper.getPositionText(home.x, home.y, home.z)).appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("helpful_commands.common.dimension", textStyles.getTertiary()).appendLiteral(": ", textStyles.getTertiary()).appendLiteral(home.dimension, textStyles.getSecondary()).appendNewline().appendNewline();
            if (src.method_43737() && this.canExecute(src, "tp")) {
                textBuilder.appendComponent(StylingHelper.getButton(textDecorators.getTeleport(), (class_2561)class_2561.method_43470((String)TranslationManager.translate(sourcePlayer, "helpful_commands.common.teleport")), tpBtnStyle)).appendWhitespace();
            }
            textBuilder.appendComponent(StylingHelper.getButton((class_2561)class_2561.method_43470((String)textDecorators.getEdit()), editBtnStyle)).appendWhitespace().appendComponent(StylingHelper.getButton((class_2561)class_2561.method_43470((String)textDecorators.getRemove()), removeBtnStyle));
            src.method_45068((class_2561)textBuilder.getComponent());
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }
}

