/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.movementAndTeleportation;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.HashSet;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5217;
import net.minecraft.class_7157;

public class CMD_spawn
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType FAILED_TO_TELEPORT = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType PLAYER_SPAWN_NOT_SET = new SimpleCommandExceptionType((Message)class_2561.method_43473());

    public CMD_spawn(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"player").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tp").requires(src -> this.canExecute((class_2168)src, "player.tp"))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(src -> this.canExecute((class_2168)src, "player.tp.other"))).executes(ctx -> this.executePlayerTp((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"))))).executes(ctx -> this.executePlayerTp((CommandContext<class_2168>)ctx, null)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"query").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(src -> this.canExecute((class_2168)src, "player.query.other"))).executes(ctx -> this.executePlayerQuery((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"))))).executes(ctx -> this.executePlayerQuery((CommandContext<class_2168>)ctx, null))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"world").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tp").requires(src -> this.canExecute((class_2168)src, "world.tp"))).executes(this::executeWorldTp))).then(class_2170.method_9247((String)"query").executes(this::executeWorldQuery))));
    }

    @Override
    public boolean canExecuteBaseCommand(class_2168 source) {
        return this.canExecute(source) || this.canExecute(source, "player.tp") || this.canExecute(source, "player.tp.other") || this.canExecute(source, "player.query.other") || this.canExecute(source, "world.tp");
    }

    private int executePlayerTp(CommandContext<class_2168> ctx, class_3222 otherPlayer) throws CommandSyntaxException {
        int result;
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        boolean self = false;
        if (otherPlayer == null || otherPlayer == sourcePlayer) {
            otherPlayer = sourcePlayer;
            self = true;
        }
        if ((result = this.teleportToPlayerSpawn(sourcePlayer, otherPlayer)) == 1) {
            if (self) {
                textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.playerSpawnNotSet.self", new class_2561[0]);
            } else {
                textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.playerSpawnNotSet.other", StylingHelper.getAffectedEntityNameText((class_1297)otherPlayer));
            }
            throw new CommandSyntaxException((CommandExceptionType)PLAYER_SPAWN_NOT_SET, (Message)textBuilder.getComponent());
        }
        if (result == 2) {
            textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.failedToTeleport", new class_2561[0]);
            throw new CommandSyntaxException((CommandExceptionType)FAILED_TO_TELEPORT, (Message)textBuilder.getComponent());
        }
        if (self) {
            textBuilder.appendTranslatable("commands.helpful_commands.spawn.player.tp.self.own", new class_2561[0]);
        } else {
            textBuilder.appendTranslatable("commands.helpful_commands.spawn.player.tp.self.other", StylingHelper.getAffectedEntityNameText((class_1297)otherPlayer));
        }
        textBuilder.setStyle(textStyles.getSuccess());
        src.method_9226(textBuilder::getComponent, true);
        return 1;
    }

    private int executeWorldTp(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (!this.teleportToWorldSpawn(sourcePlayer, sourcePlayer.method_51469())) {
            textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.failedToTeleport", new class_2561[0]);
            throw new CommandSyntaxException((CommandExceptionType)FAILED_TO_TELEPORT, (Message)textBuilder.getComponent());
        }
        textBuilder.appendTranslatable("commands.helpful_commands.spawn.world.tp", new class_2561[0]).setStyle(textStyles.getSuccess());
        src.method_9226(textBuilder::getComponent, true);
        return 1;
    }

    private int executePlayerQuery(CommandContext<class_2168> ctx, class_3222 otherPlayer) throws CommandSyntaxException {
        class_3222.class_10766 respawnConfig;
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (otherPlayer == null && sourcePlayer == null) {
            throw class_2168.field_9824.create();
        }
        boolean self = false;
        if (otherPlayer == null || otherPlayer == sourcePlayer) {
            otherPlayer = sourcePlayer;
            self = true;
        }
        if ((respawnConfig = otherPlayer.method_67564()) == null) {
            if (self) {
                textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.playerSpawnNotSet.self", new class_2561[0]);
            } else {
                textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.playerSpawnNotSet.other", StylingHelper.getAffectedEntityNameText((class_1297)otherPlayer));
            }
            throw new CommandSyntaxException((CommandExceptionType)PLAYER_SPAWN_NOT_SET, (Message)textBuilder.getComponent());
        }
        src.method_45068(this.buildInfoComponent(respawnConfig.comp_4913(), src, otherPlayer.method_5477().getString(), self));
        return 1;
    }

    private int executeWorldQuery(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        src.method_45068(this.buildInfoComponent(src.method_9225().method_74854(), src, "", false));
        return 1;
    }

    private class_2561 buildInfoComponent(class_5217.class_12064 respawnData, class_2168 src, String playerName, boolean isOwnSpawn) {
        HelpfulCommandsStyle currentStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = currentStyle.getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = currentStyle.getTextDecorators();
        boolean isPlayer = !playerName.isEmpty();
        class_2568.class_10613 tpBtnHoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "hover.helpful_commands.clickToTeleport")));
        class_2558.class_10609 tpBtnClickEvent = new class_2558.class_10609("/spawn " + (String)(isPlayer ? "player tp" + (String)(isOwnSpawn ? "" : " " + playerName) : "world tp"));
        class_2583 tpBtnStyle = textStyles.getSecondary().method_10949((class_2568)tpBtnHoverEvent).method_10958((class_2558)tpBtnClickEvent);
        class_243 pos = respawnData.method_74897().method_46558();
        String dimensionLocation = respawnData.method_74894().method_29177().toString();
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendComponent(StylingHelper.getTitle((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.spawn.info.title")), (class_2561)class_2561.method_43470((String)(isPlayer ? playerName : TranslationManager.translate(src, "commands.helpful_commands.spawn.info.title.world"))))).appendNewline().appendLiteral(textDecorators.getBulletPoint()).appendTranslatable("helpful_commands.common.position", new class_2561[0]).appendLiteral(": ").appendComponent(StylingHelper.getPositionText(pos.method_10216(), pos.method_10214(), pos.method_10215())).appendNewline().appendLiteral(textDecorators.getBulletPoint()).appendTranslatable("helpful_commands.common.dimension", new class_2561[0]).appendLiteral(": ").appendComponent((class_2561)class_2561.method_43470((String)dimensionLocation).method_10862(textStyles.getSecondary()));
        if (src.method_43737()) {
            String string = isPlayer ? (isOwnSpawn ? "player.tp" : "player.tp.other") : "world.tp";
            if (this.canExecute(src, string)) {
                textBuilder.appendNewline().appendNewline().appendComponent(StylingHelper.getButton(textDecorators.getTeleport(), (class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "helpful_commands.common.teleport")), tpBtnStyle));
            }
        }
        textBuilder.setStyle(textStyles.getTertiary());
        return textBuilder.getComponent();
    }

    private int teleportToPlayerSpawn(class_3222 teleportedPlayer, class_3222 otherPlayer) throws CommandSyntaxException {
        class_3218 serverLevel;
        class_3222.class_10766 respawnConfig = otherPlayer.method_67564();
        if (respawnConfig == null) {
            return 1;
        }
        class_5217.class_12064 respawnData = respawnConfig.comp_4913();
        String dimensionLocation = respawnData.method_74894().method_29177().toString();
        try {
            serverLevel = ServerLevelHelper.getLevel(dimensionLocation);
        }
        catch (ServerLevelHelper.UnknownServerLevelException e) {
            HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
            TranslationManager.TextBuilder eTextBuilder = new TranslationManager.TextBuilder(teleportedPlayer);
            eTextBuilder.appendTranslatable("error.helpful_commands.unknownDimension", new class_2561[]{class_2561.method_43470((String)dimensionLocation).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)UNKNOWN_DIMENSION, (Message)eTextBuilder.getComponent());
        }
        class_243 pos = respawnData.method_74897().method_46558();
        return teleportedPlayer.method_48105(serverLevel, pos.method_10216(), pos.method_10214(), pos.method_10215(), new HashSet(), respawnData.comp_4916(), respawnData.comp_4917(), false) ? 0 : 2;
    }

    private boolean teleportToWorldSpawn(class_3222 teleportedPlayer, class_3218 serverLevel) throws CommandSyntaxException {
        class_5217.class_12064 respawnData = serverLevel.method_74854();
        String dimensionLocation = respawnData.method_74894().method_29177().toString();
        try {
            serverLevel = ServerLevelHelper.getLevel(dimensionLocation);
        }
        catch (ServerLevelHelper.UnknownServerLevelException e) {
            HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
            TranslationManager.TextBuilder eTextBuilder = new TranslationManager.TextBuilder(teleportedPlayer);
            eTextBuilder.appendTranslatable("error.helpful_commands.unknownDimension", new class_2561[]{class_2561.method_43470((String)dimensionLocation).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)UNKNOWN_DIMENSION, (Message)eTextBuilder.getComponent());
        }
        class_243 pos = respawnData.method_74897().method_46558();
        return teleportedPlayer.method_48105(serverLevel, pos.method_10216(), pos.method_10214(), pos.method_10215(), new HashSet(), respawnData.comp_4916(), respawnData.comp_4917(), false);
    }
}

