/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.movementAndTeleportation;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.manager.WarpManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.expecticament.helpfulcommands.suggestionProvider.WarpDescriptionSuggestionProvider;
import com.expecticament.helpfulcommands.suggestionProvider.WarpNameSuggestionProvider;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_2374;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CMD_warp
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType WARP_DOESNT_EXIST = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType WARP_ALREADY_EXISTS = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType SAME_NAME_PROVIDED = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType NO_POSITION_PROVIDED = new SimpleCommandExceptionType((Message)class_2561.method_43473());
    protected static final SimpleCommandExceptionType NO_DIMENSION_PROVIDED = new SimpleCommandExceptionType((Message)class_2561.method_43473());

    public CMD_warp(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        WarpNameSuggestionProvider warpNameSuggestionProvider = new WarpNameSuggestionProvider();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tp").requires(src -> this.canExecute((class_2168)src, "tp"))).then((ArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"warp_name", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).requires(src -> this.canExecute((class_2168)src, "tp.other", 2))).executes(ctx -> this.teleport((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), class_2186.method_9317((CommandContext)ctx, (String)"entities"))))).executes(ctx -> this.teleport((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name")))).suggests((SuggestionProvider)warpNameSuggestionProvider)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> this.canExecute((class_2168)src, "manage", 3))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"warp_name", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"description", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.addWarp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"description")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9737()).executes(ctx -> this.addWarp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"description"), (class_2374)class_2277.method_9736((CommandContext)ctx, (String)"position")))).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> this.addWarp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"description"), (class_2374)class_2277.method_9736((CommandContext)ctx, (String)"position"), class_2181.method_9289((CommandContext)ctx, (String)"dimension"))))))).executes(ctx -> this.addWarp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> this.canExecute((class_2168)src, "manage", 3))).then((ArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"warp_name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.removeWarp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name")))).suggests((SuggestionProvider)warpNameSuggestionProvider)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").requires(src -> this.canExecute((class_2168)src, "manage", 3))).then((ArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"warp_name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9247((String)"name").then(class_2170.method_9244((String)"new_name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.editWarpName((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"new_name")))))).then(class_2170.method_9247((String)"description").then((ArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"new_description", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.editWarpDescription((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"new_description")))).suggests((SuggestionProvider)new WarpDescriptionSuggestionProvider())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"location").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"new_position", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"new_dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> this.editWarpLocation((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), (class_2374)class_2277.method_9736((CommandContext)ctx, (String)"new_position"), class_2181.method_9289((CommandContext)ctx, (String)"new_dimension"))))).executes(ctx -> this.editWarpLocation((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), (class_2374)class_2277.method_9736((CommandContext)ctx, (String)"new_position"))))).executes(ctx -> this.editWarpLocation((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"))))).suggests((SuggestionProvider)warpNameSuggestionProvider)))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"warp_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)warpNameSuggestionProvider).executes(ctx -> this.warpInfo((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"))))));
    }

    @Override
    public boolean canExecuteBaseCommand(class_2168 source) {
        return this.canExecute(source) || this.canExecute(source, "tp") || this.canExecute(source, "tp.other") || this.canExecute(source, "manage");
    }

    private int teleport(CommandContext<class_2168> ctx, String warpName) throws CommandSyntaxException {
        return this.teleport(ctx, warpName, null);
    }

    private int teleport(CommandContext<class_2168> ctx, String warpName, Collection<? extends class_1297> entities) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        ArrayList<class_3222> targets = new ArrayList<class_3222>(Objects.requireNonNullElse(entities, List.of()));
        if (targets.isEmpty() && sourcePlayer == null) {
            throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)class_2561.method_43470((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
        }
        if (entities == null) {
            targets.add(sourcePlayer);
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.Warp warp = WarpManager.getWarp(warpName);
            try {
                class_3218 dimension = ServerLevelHelper.getLevel(warp.dimension);
                boolean commandFeedback = src.method_9225().method_64395().method_8355(class_1928.field_19400);
                List<class_1297> affected = targets.stream().filter(e -> e.method_48105(dimension, warp.x, warp.y, warp.z, class_2709.field_54094, e.method_36454(), e.method_36455(), false)).peek(e -> {
                    if (e.method_31747() && e != sourcePlayer && commandFeedback) {
                        class_3222 plr = (class_3222)e;
                        TranslationManager.TextBuilder affectedMsgTextBuilder = new TranslationManager.TextBuilder(src);
                        affectedMsgTextBuilder.appendTranslatable("commands.helpful_commands.warp.teleport.output.success.affected", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())}).setStyle(textStyles.getAffectedNeutral());
                        plr.method_64398((class_2561)affectedMsgTextBuilder.getComponent());
                    }
                }).toList();
                if (affected.isEmpty()) {
                    throw class_2186.field_9863.create();
                }
                boolean multiple = affected.size() > 1;
                boolean self = affected.contains(sourcePlayer);
                src.method_9226(() -> this.buildTeleportFeedbackMessage(src, multiple, self, warpName, affected), true);
                return affected.size();
            }
            catch (ServerLevelHelper.UnknownServerLevelException e2) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("error.helpful_commands.unknownDimension", new class_2561[]{class_2561.method_43470((String)warp.dimension).method_10862(textStyles.getPrimary())});
                throw new CommandSyntaxException((CommandExceptionType)UNKNOWN_DIMENSION, (Message)textBuilder.getComponent());
            }
        }
        catch (WarpManager.WarpDoesntExistException e3) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
    }

    private class_2561 buildTeleportFeedbackMessage(class_2168 src, boolean multiple, boolean self, String warpName, List<class_1297> affected) {
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        class_5250 warpNameText = class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary());
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (multiple) {
            textBuilder.appendTranslatable("commands.helpful_commands.warp.teleport.output.success.others", new class_2561[]{StylingHelper.getAffectedEntitiesNumberText(affected), warpNameText});
        } else if (self) {
            textBuilder.appendTranslatable("commands.helpful_commands.warp.teleport.output.success.self", new class_2561[]{warpNameText});
        } else {
            textBuilder.appendTranslatable("commands.helpful_commands.warp.teleport.output.success.others", new class_2561[]{StylingHelper.getAffectedEntityNameText(affected.getFirst()), warpNameText});
        }
        textBuilder.setStyle(textStyles.getSuccess());
        return textBuilder.getComponent();
    }

    private int addWarp(CommandContext<class_2168> ctx, String warpName) throws CommandSyntaxException {
        return this.addWarp(ctx, warpName, "", null, null);
    }

    private int addWarp(CommandContext<class_2168> ctx, String warpName, String warpDescription) throws CommandSyntaxException {
        return this.addWarp(ctx, warpName, warpDescription, null, null);
    }

    private int addWarp(CommandContext<class_2168> ctx, String warpName, String warpDescription, class_2374 position) throws CommandSyntaxException {
        return this.addWarp(ctx, warpName, warpDescription, position, null);
    }

    private int addWarp(CommandContext<class_2168> ctx, String warpName, String warpDescription, class_2374 position, class_3218 serverLevel) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        if (position == null) {
            if (sourcePlayer == null) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.specifyPosition", new class_2561[0]);
                throw new CommandSyntaxException((CommandExceptionType)NO_POSITION_PROVIDED, (Message)textBuilder.getComponent());
            }
            position = sourcePlayer.method_73189();
        }
        if (serverLevel == null) {
            if (sourcePlayer == null) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.specifyDimension", new class_2561[0]);
                throw new CommandSyntaxException((CommandExceptionType)NO_DIMENSION_PROVIDED, (Message)textBuilder.getComponent());
            }
            serverLevel = sourcePlayer.method_51469();
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.addWarp(warpName, warpDescription, position, serverLevel);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.add.output.success", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpAlreadyExistsException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpAlreadyExists", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_ALREADY_EXISTS, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int removeWarp(CommandContext<class_2168> ctx, String warpName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.removeWarp(warpName);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.remove.output.success", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editWarpName(CommandContext<class_2168> ctx, String warpName, String newName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.editWarpName(warpName, newName);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.edit.name.output.success", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary()), class_2561.method_43470((String)newName).method_10862(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        catch (WarpManager.SameWarpNameProvided e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.edit.name.output.error.sameName", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)SAME_NAME_PROVIDED, (Message)textBuilder.getComponent());
        }
        catch (WarpManager.WarpAlreadyExistsException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpAlreadyExists", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_ALREADY_EXISTS, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editWarpDescription(CommandContext<class_2168> ctx, String warpName, String newDescription) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.editWarpDescription(warpName, newDescription);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.edit.description.output.success", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editWarpLocation(CommandContext<class_2168> ctx, String warpName) throws CommandSyntaxException {
        return this.editWarpLocation(ctx, warpName, null, null);
    }

    private int editWarpLocation(CommandContext<class_2168> ctx, String warpName, class_2374 newPosition) throws CommandSyntaxException {
        return this.editWarpLocation(ctx, warpName, newPosition, null);
    }

    private int editWarpLocation(CommandContext<class_2168> ctx, String warpName, class_2374 newPosition, class_3218 newServerLevel) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        if (newPosition == null) {
            if (sourcePlayer == null) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.specifyPosition", new class_2561[0]);
                throw new CommandSyntaxException((CommandExceptionType)NO_POSITION_PROVIDED, (Message)textBuilder.getComponent());
            }
            newPosition = sourcePlayer.method_73189();
        }
        if (newServerLevel == null) {
            if (sourcePlayer == null) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.specifyDimension", new class_2561[0]);
                throw new CommandSyntaxException((CommandExceptionType)NO_DIMENSION_PROVIDED, (Message)textBuilder.getComponent());
            }
            newServerLevel = sourcePlayer.method_51469();
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.editWarpLocation(warpName, newPosition, newServerLevel);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.edit.location.output.success", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.method_9226(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int warpInfo(CommandContext<class_2168> ctx, String warpName) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = StylingManager.getCurrentStyle().getTextDecorators();
        try {
            WarpManager.Warp warp = WarpManager.getWarp(warpName);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            class_2568.class_10613 tpBtnHoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "hover.helpful_commands.clickToTeleport")));
            class_2558.class_10609 tpBtnClickEvent = new class_2558.class_10609("/warp tp " + warpName);
            class_2583 tpBtnStyle = textStyles.getSecondary().method_10949((class_2568)tpBtnHoverEvent).method_10958((class_2558)tpBtnClickEvent);
            class_2568.class_10613 editBtnHoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "hover.helpful_commands.clickToEdit")));
            class_2558.class_10610 editBtnClickEvent = new class_2558.class_10610("/warp edit " + warpName + " ");
            class_2583 editBtnStyle = textStyles.getTertiary().method_10949((class_2568)editBtnHoverEvent).method_10958((class_2558)editBtnClickEvent);
            class_2568.class_10613 removeBtnHoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "hover.helpful_commands.clickToRemove")));
            class_2558.class_10609 removeBtnClickEvent = new class_2558.class_10609("/warp remove " + warpName);
            class_2583 removeBtnStyle = textStyles.getDangerousAction().method_10949((class_2568)removeBtnHoverEvent).method_10958((class_2558)removeBtnClickEvent);
            class_5250 bulletPointComponent = class_2561.method_43470((String)textDecorators.getBulletPoint()).method_10862(textStyles.getTertiary());
            class_5250 colonComponent = class_2561.method_43470((String)": ").method_10862(textStyles.getTertiary());
            textBuilder.appendComponent(StylingHelper.getTitle((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.warp.info.title")), (class_2561)class_2561.method_43470((String)warpName)));
            if (!warp.description.isEmpty() && !warp.description.equals(" ")) {
                textBuilder.appendNewline().appendComponent((class_2561)bulletPointComponent).appendComponent((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "helpful_commands.common.description")).method_10862(textStyles.getTertiary())).appendComponent((class_2561)colonComponent).appendLiteral(warp.description);
            }
            textBuilder.appendNewline().appendComponent((class_2561)bulletPointComponent).appendComponent((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "helpful_commands.common.position")).method_10862(textStyles.getTertiary())).appendComponent((class_2561)colonComponent).appendComponent(StylingHelper.getPositionText(warp.x, warp.y, warp.z)).appendNewline().appendComponent((class_2561)bulletPointComponent).appendComponent((class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "helpful_commands.common.dimension")).method_10862(textStyles.getTertiary())).appendComponent((class_2561)colonComponent).appendComponent((class_2561)class_2561.method_43470((String)warp.dimension).method_10862(textStyles.getSecondary()));
            if (!src.method_43737()) {
                textBuilder.appendNewline().appendNewline().appendLiteral(TranslationManager.translate(src, "helpful_commands.common.teleport") + ": /warp tp %s <entities>".formatted(warpName)).appendNewline().appendLiteral(TranslationManager.translate(src, "helpful_commands.common.edit") + ": /warp edit %s ...".formatted(warpName)).appendNewline().appendLiteral(TranslationManager.translate(src, "helpful_commands.common.remove") + ": /warp remove %s".formatted(warpName));
            } else {
                boolean canTp = this.canExecute(src, "tp");
                boolean canManage = this.canExecute(src, "manage", 3);
                if (canTp || canManage) {
                    textBuilder.appendNewline().appendNewline();
                    if (canTp) {
                        textBuilder.appendComponent(StylingHelper.getButton(textDecorators.getTeleport(), (class_2561)class_2561.method_43470((String)TranslationManager.translate(src, "helpful_commands.common.teleport")), tpBtnStyle)).appendWhitespace();
                    }
                    if (canManage) {
                        textBuilder.appendComponent(StylingHelper.getButton((class_2561)class_2561.method_43470((String)textDecorators.getEdit()), editBtnStyle)).appendWhitespace().appendComponent(StylingHelper.getButton((class_2561)class_2561.method_43470((String)textDecorators.getRemove()), removeBtnStyle));
                    }
                }
            }
            src.method_45068((class_2561)textBuilder.getComponent());
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new class_2561[]{class_2561.method_43470((String)warpName).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }
}

