/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.playersAndEntities;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CMD_coords
extends HelpfulCommandsCommand {
    public CMD_coords(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"broadcast").requires(src -> this.canExecute((class_2168)src, "broadcast", 2) || this.canExecute((class_2168)src, "broadcast.other", 2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(src -> this.canExecute((class_2168)src, "broadcast.other", 2))).executes(ctx -> this.broadcast((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"))))).executes(this::broadcast))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"share").requires(src -> this.canExecute((class_2168)src, "share"))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(ctx -> this.share((CommandContext<class_2168>)ctx, class_2186.method_9312((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"query").requires(src -> this.canExecute((class_2168)src, "query", 2) || this.canExecute((class_2168)src, "query.other", 2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(src -> this.canExecute((class_2168)src, "query.other", 2))).executes(ctx -> this.query((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"))))).executes(this::execute))).executes(this::execute));
    }

    @Override
    public boolean canExecuteBaseCommand(class_2168 source) {
        return this.canExecute(source) || this.canExecute(source, "broadcast", 2) || this.canExecute(source, "broadcast.other", 2) || this.canExecute(source, "share") || this.canExecute(source, "query", 2) || this.canExecute(source, "query.other", 2);
    }

    private int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        String dimensionKey = ServerLevelHelper.getLevelLocation(sourcePlayer.method_51469());
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.coords.output.success.self", StylingHelper.getLocationText(sourcePlayer.method_73189(), dimensionKey));
        src.method_9226(textBuilder::getComponent, true);
        return 1;
    }

    private int broadcast(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.broadcast(ctx, null);
    }

    private int broadcast(CommandContext<class_2168> ctx, class_3222 player) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        if (player == null && sourcePlayer == null) {
            throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)class_2561.method_43470((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
        }
        if (player == null) {
            player = sourcePlayer;
        }
        String dimensionKey = ServerLevelHelper.getLevelLocation(player.method_51469());
        ArrayList playerList = new ArrayList(player.method_51469().method_8503().method_3760().method_14571());
        if (playerList.isEmpty()) {
            throw class_2186.field_9856.create();
        }
        for (class_3222 plr : playerList) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(plr);
            textBuilder.appendTranslatable("commands.helpful_commands.coords.output.success.other", StylingHelper.getAffectedEntityNameText((class_1297)player), StylingHelper.getLocationText(player.method_73189(), dimensionKey));
            plr.method_64398((class_2561)textBuilder.getComponent());
        }
        if (sourcePlayer == null) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.coords.output.success.other", StylingHelper.getAffectedEntityNameText((class_1297)player), StylingHelper.getLocationText(player.method_73189(), dimensionKey));
            src.method_45068((class_2561)textBuilder.getComponent());
        }
        return 1;
    }

    private int share(CommandContext<class_2168> ctx, Collection<class_3222> players) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validatePlayerOnly(src);
        ArrayList<class_3222> playerList = new ArrayList<class_3222>(players);
        playerList.remove(sourcePlayer);
        if (playerList.isEmpty()) {
            throw class_2186.field_9856.create();
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        String dimensionKey = ServerLevelHelper.getLevelLocation(sourcePlayer.method_51469());
        for (class_3222 player : playerList) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(player);
            textBuilder.appendTranslatable("commands.helpful_commands.coords.share.output.success.affected", StylingHelper.getAffectedEntityNameText((class_1297)sourcePlayer), StylingHelper.getLocationText(sourcePlayer.method_73189(), dimensionKey));
            player.method_64398((class_2561)textBuilder.getComponent());
        }
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(sourcePlayer);
        textBuilder.setStyle(textStyles.getSuccess());
        class_5250 affected = class_2561.method_43473();
        if (playerList.size() == 1) {
            affected.method_10852(StylingHelper.getAffectedEntityNameText((class_1297)playerList.getFirst()));
        } else {
            affected.method_10852(StylingHelper.getAffectedEntitiesNumberText(playerList)).method_27693(TranslationManager.translate(src, "commands.helpful_commands.coords.share.output.success.multiple"));
        }
        textBuilder.appendTranslatable("commands.helpful_commands.coords.share.output.success.other", new class_2561[]{affected});
        src.method_9226(textBuilder::getComponent, true);
        return playerList.size();
    }

    private int query(CommandContext<class_2168> ctx, class_3222 player) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        if (player == sourcePlayer) {
            return this.execute(ctx);
        }
        String dimensionKey = ServerLevelHelper.getLevelLocation(player.method_51469());
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.coords.output.success.other", StylingHelper.getAffectedEntityNameText((class_1297)player), StylingHelper.getLocationText(player.method_73189(), dimensionKey));
        src.method_9226(textBuilder::getComponent, true);
        return 1;
    }
}

