/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.world;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ConfigManager;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2293;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class CMD_killitems
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType RANGE_CONFIG_VALUE_EXCEEDED = new SimpleCommandExceptionType((Message)class_2561.method_43473());

    public CMD_killitems(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"range_cubic", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"filter", (ArgumentType)class_2293.method_9801((class_7157)buildContext)).executes(ctx -> this.execute((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range_cubic"), (Predicate<class_1799>)class_2293.method_9804((CommandContext)ctx, (String)"filter"))))).executes(ctx -> this.execute((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range_cubic"))))).executes(this::execute));
    }

    @Override
    public boolean canExecuteBaseCommand(class_2168 source) {
        return this.canExecute(source);
    }

    private int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.execute(ctx, 0, null);
    }

    private int execute(CommandContext<class_2168> ctx, int range) throws CommandSyntaxException {
        return this.execute(ctx, range, null);
    }

    private int execute(CommandContext<class_2168> ctx, int range, Predicate<class_1799> itemPredicate) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 sourcePlayer = this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        int maxRange = (Integer)config.readField("killitemsMaxRange");
        if (range < 1) {
            range = Math.clamp(64L, 1, maxRange);
        } else if (range > maxRange) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.killitems.configValueExceeded", new class_2561[]{class_2561.method_43470((String)String.valueOf(maxRange)).method_10862(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)RANGE_CONFIG_VALUE_EXCEEDED, (Message)textBuilder.getComponent());
        }
        class_3218 level = src.method_9225();
        class_243 center = sourcePlayer != null ? sourcePlayer.method_73189() : src.method_9225().method_74854().method_74897().method_46558();
        class_238 aabb = new class_238(center.field_1352 - (double)range, center.field_1351 - (double)range, center.field_1350 - (double)range, center.field_1352 + (double)range, center.field_1351 + (double)range, center.field_1350 + (double)range);
        List itemEntities = level.method_8390(class_1542.class, aabb, itemEntity -> itemPredicate == null || itemPredicate.test(itemEntity.method_6983()));
        boolean multiple = false;
        for (class_1542 itemEntity2 : itemEntities) {
            if (!multiple && itemEntity2.method_6983().method_7947() > 1) {
                multiple = true;
            }
            itemEntity2.method_31472();
        }
        if (itemEntities.isEmpty()) {
            throw new CommandSyntaxException((CommandExceptionType)NO_ITEMS_FOUND, (Message)class_2561.method_43470((String)TranslationManager.translate(src, "error.helpful_commands.noItemsFound")));
        }
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.killitems", new class_2561[]{StylingHelper.getAffectedEntitiesNumberText(itemEntities), class_2561.method_43470((String)TranslationManager.translate(src, "commands.helpful_commands.killitems." + (itemEntities.size() == 1 && !multiple ? "single" : "multiple")))});
        textBuilder.setStyle(textStyles.getSuccess());
        src.method_9226(textBuilder::getComponent, true);
        return itemEntities.size();
    }
}

