/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;

public class GenericIO {
    private final Path fullPath;
    private byte[] cachedData = null;

    public GenericIO(Path directoryPath, String fileName, String fileExtension) {
        this.fullPath = directoryPath.resolve(fileName + fileExtension);
    }

    public void save(byte[] data) {
        this.cachedData = data;
    }

    public void writeToDisk() {
        if (this.cachedData == null) {
            return;
        }
        this.writeToDisk(this.cachedData);
    }

    public void writeToDisk(byte[] data) {
        if (data == null) {
            return;
        }
        try {
            Files.createDirectories(this.fullPath.getParent(), new FileAttribute[0]);
            Files.write(this.fullPath, data, new OpenOption[0]);
            this.cachedData = Arrays.copyOf(data, data.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] read() {
        if (this.cachedData != null) {
            return this.cachedData;
        }
        try {
            if (!Files.exists(this.fullPath, new LinkOption[0])) {
                return null;
            }
            this.cachedData = Files.readAllBytes(this.fullPath);
            return this.cachedData;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

