/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.manager;

import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.io.JsonIO;
import com.expecticament.helpfulcommands.manager.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class HomeManager {
    private static final String FILE_NAME = "homes";
    private static JsonIO<Homes> io;

    public static void initialize(MinecraftServer server) {
        io = new JsonIO<Homes>(server.method_27050(class_5218.field_24188).resolve("helpful_commands4"), FILE_NAME, Homes.class);
    }

    public static void addHome(class_3222 player, String homeName) throws HomeAlreadyExistsException, HomeLimitExceededException {
        Homes homes = Objects.requireNonNullElse(io.read(), new Homes());
        Map<String, Home> playerHomes = HomeManager.getHomesForPlayer(player, homes);
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        int maxHomes = (Integer)config.readField("maxHomes");
        if (playerHomes.size() >= maxHomes) {
            throw new HomeLimitExceededException(player);
        }
        if (playerHomes.putIfAbsent(homeName, new Home((class_2374)player.method_73189(), player.method_51469())) == null) {
            homes.entries.put(player.method_5667(), playerHomes);
            io.save(homes);
            return;
        }
        throw new HomeAlreadyExistsException(player, homeName);
    }

    public static void removeHome(class_3222 player, String homeName) throws HomeDoesntExistException {
        Homes homes = Objects.requireNonNullElse(io.read(), new Homes());
        Map<String, Home> playerHomes = HomeManager.getHomesForPlayer(player, homes);
        if (playerHomes.remove(homeName) != null) {
            homes.entries.put(player.method_5667(), playerHomes);
            io.save(homes);
            return;
        }
        throw new HomeDoesntExistException(player, homeName);
    }

    public static void editHomeName(class_3222 player, String homeName, String newName) throws SameHomeNameProvided, HomeDoesntExistException, HomeAlreadyExistsException {
        if (homeName.equals(newName)) {
            throw new SameHomeNameProvided(newName);
        }
        Homes homes = Objects.requireNonNullElse(io.read(), new Homes());
        Map<String, Home> playerHomes = HomeManager.getHomesForPlayer(player, homes);
        if (playerHomes.containsKey(newName)) {
            throw new HomeAlreadyExistsException(player, newName);
        }
        Home prev = playerHomes.remove(homeName);
        if (prev != null) {
            playerHomes.put(newName, prev);
            homes.entries.put(player.method_5667(), playerHomes);
            io.save(homes);
            return;
        }
        throw new HomeDoesntExistException(player, homeName);
    }

    public static void editHomeLocation(class_3222 player, String homeName, class_2374 newPosition, class_3218 newServerLevel) throws HomeDoesntExistException {
        Homes homes = Objects.requireNonNullElse(io.read(), new Homes());
        Map<String, Home> playerHomes = HomeManager.getHomesForPlayer(player, homes);
        Home home = playerHomes.get(homeName);
        if (home != null) {
            home.x = newPosition.method_10216();
            home.y = newPosition.method_10214();
            home.z = newPosition.method_10215();
            home.dimension = ServerLevelHelper.getLevelLocation(newServerLevel);
            playerHomes.put(homeName, home);
            homes.entries.put(player.method_5667(), playerHomes);
            io.save(homes);
            return;
        }
        throw new HomeDoesntExistException(player, homeName);
    }

    public static boolean hasHome(class_3222 player, String homeName) {
        Homes homes = Objects.requireNonNullElse(io.read(), new Homes());
        Map<String, Home> playerHomes = HomeManager.getHomesForPlayer(player, homes);
        return playerHomes.containsKey(homeName);
    }

    public static Home getHome(class_3222 player, String homeName) throws HomeDoesntExistException {
        Homes homes = Objects.requireNonNullElse(io.read(), new Homes());
        Map<String, Home> playerHomes = HomeManager.getHomesForPlayer(player, homes);
        Home home = playerHomes.get(homeName);
        if (home != null) {
            return home;
        }
        throw new HomeDoesntExistException(player, homeName);
    }

    public static Map<String, Home> getHomesForPlayer(class_3222 player) {
        return HomeManager.getHomesForPlayer(player, Objects.requireNonNullElse(io.read(), new Homes()));
    }

    private static Map<String, Home> getHomesForPlayer(class_3222 player, Homes homes) {
        return Objects.requireNonNullElse(homes.entries.get(player.method_5667()), new HashMap());
    }

    public static void writeToDisk() {
        io.writeToDisk();
    }

    private static class Homes {
        private final Map<UUID, Map<String, Home>> entries = new HashMap<UUID, Map<String, Home>>();

        private Homes() {
        }
    }

    public static class HomeLimitExceededException
    extends Exception {
        public HomeLimitExceededException(class_3222 player) {
            super("Player %s (%s) can't create any more homes".formatted(player.method_5477().getString(), player.method_5845()));
        }
    }

    public static class Home {
        public double x;
        public double y;
        public double z;
        public String dimension;

        public Home(class_2374 position, class_3218 serverLevel) {
            this.x = position.method_10216();
            this.y = position.method_10214();
            this.z = position.method_10215();
            this.dimension = ServerLevelHelper.getLevelLocation(serverLevel);
        }
    }

    public static class HomeAlreadyExistsException
    extends Exception {
        public HomeAlreadyExistsException(class_3222 player, String homeName) {
            super("Player %s (%s) already has a home with this name: %s".formatted(player.method_5477().getString(), player.method_5845(), homeName));
        }
    }

    public static class HomeDoesntExistException
    extends Exception {
        public HomeDoesntExistException(class_3222 player, String homeName) {
            super("Player %s (%s) doesn't have a home with this name: %s".formatted(player.method_5477().getString(), player.method_5845(), homeName));
        }
    }

    public static class SameHomeNameProvided
    extends Exception {
        public SameHomeNameProvided(String newName) {
            super("The new home name is the same as the old one: %s".formatted(newName));
        }
    }
}

