/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.manager;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.abilities.CMD_fly;
import com.expecticament.helpfulcommands.command.abilities.CMD_god;
import com.expecticament.helpfulcommands.command.itemsAndInventory.CMD_invsee;
import com.expecticament.helpfulcommands.command.itemsAndInventory.CMD_rename;
import com.expecticament.helpfulcommands.command.itemsAndInventory.CMD_repair;
import com.expecticament.helpfulcommands.command.itemsAndInventory.CMD_smelt;
import com.expecticament.helpfulcommands.command.main.CMD_hc;
import com.expecticament.helpfulcommands.command.movementAndTeleportation.CMD_deathpos;
import com.expecticament.helpfulcommands.command.movementAndTeleportation.CMD_dimension;
import com.expecticament.helpfulcommands.command.movementAndTeleportation.CMD_home;
import com.expecticament.helpfulcommands.command.movementAndTeleportation.CMD_spawn;
import com.expecticament.helpfulcommands.command.movementAndTeleportation.CMD_warp;
import com.expecticament.helpfulcommands.command.playersAndEntities.CMD_coords;
import com.expecticament.helpfulcommands.command.playersAndEntities.CMD_extinguish;
import com.expecticament.helpfulcommands.command.playersAndEntities.CMD_feed;
import com.expecticament.helpfulcommands.command.playersAndEntities.CMD_gm;
import com.expecticament.helpfulcommands.command.playersAndEntities.CMD_hat;
import com.expecticament.helpfulcommands.command.playersAndEntities.CMD_heal;
import com.expecticament.helpfulcommands.command.playersAndEntities.CMD_ignite;
import com.expecticament.helpfulcommands.command.social.CMD_coinflip;
import com.expecticament.helpfulcommands.command.world.CMD_killitems;
import com.expecticament.helpfulcommands.command.world.TimeCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class ModCommandManager {
    private static List<HelpfulCommandsCommand> commands;
    private static LinkedHashMap<CommandCategory, List<HelpfulCommandsCommand>> commandsByCategory;

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 selection) {
        commands = new ArrayList<HelpfulCommandsCommand>();
        commandsByCategory = new LinkedHashMap();
        commands.add(new CMD_hc(new CommandData("hc", CommandCategory.MAIN)));
        commands.add(new CMD_fly(new CommandData("fly", CommandCategory.ABILITIES)));
        commands.add(new CMD_god(new CommandData("god", CommandCategory.ABILITIES)));
        commands.add(new CMD_invsee(new CommandData("invsee", CommandCategory.ITEMS_AND_INVENTORY)));
        commands.add(new CMD_rename(new CommandData("rename", CommandCategory.ITEMS_AND_INVENTORY)));
        commands.add(new CMD_repair(new CommandData("repair", CommandCategory.ITEMS_AND_INVENTORY)));
        commands.add(new CMD_smelt(new CommandData("smelt", CommandCategory.ITEMS_AND_INVENTORY)));
        commands.add(new CMD_deathpos(new CommandData("deathpos", CommandCategory.MOVEMENT_AND_TELEPORTATION)));
        commands.add(new CMD_dimension(new CommandData("dimension", CommandCategory.MOVEMENT_AND_TELEPORTATION)));
        commands.add(new CMD_home(new CommandData("home", CommandCategory.MOVEMENT_AND_TELEPORTATION)));
        commands.add(new CMD_spawn(new CommandData("spawn", CommandCategory.MOVEMENT_AND_TELEPORTATION)));
        commands.add(new CMD_warp(new CommandData("warp", CommandCategory.MOVEMENT_AND_TELEPORTATION, true, 0)));
        commands.add(new CMD_coords(new CommandData("coords", CommandCategory.PLAYERS_AND_ENTITIES, true, 0)));
        commands.add(new CMD_extinguish(new CommandData("extinguish", CommandCategory.PLAYERS_AND_ENTITIES)));
        commands.add(new CMD_feed(new CommandData("feed", CommandCategory.PLAYERS_AND_ENTITIES)));
        commands.add(new CMD_gm(new CommandData("gm", CommandCategory.PLAYERS_AND_ENTITIES)));
        commands.add(new CMD_hat(new CommandData("hat", CommandCategory.PLAYERS_AND_ENTITIES, true, 0)));
        commands.add(new CMD_heal(new CommandData("heal", CommandCategory.PLAYERS_AND_ENTITIES)));
        commands.add(new CMD_ignite(new CommandData("ignite", CommandCategory.PLAYERS_AND_ENTITIES)));
        commands.add(new CMD_coinflip(new CommandData("coinflip", CommandCategory.SOCIAL, true, 0)));
        commands.add(new TimeCommand(new CommandData("day", CommandCategory.WORLD), 1000));
        commands.add(new TimeCommand(new CommandData("night", CommandCategory.WORLD), 13000));
        commands.add(new CMD_killitems(new CommandData("killitems", CommandCategory.WORLD)));
        for (HelpfulCommandsCommand command : commands) {
            command.register(dispatcher, buildContext, selection);
            CommandCategory category = command.getCommandData().getCategory();
            commandsByCategory.computeIfAbsent(category, k -> new ArrayList()).add(command);
        }
    }

    public static List<HelpfulCommandsCommand> getCommandList() {
        return commands;
    }

    public static LinkedHashMap<CommandCategory, List<HelpfulCommandsCommand>> getCommandListByCategory() {
        return commandsByCategory;
    }

    public static void sendCommandsToEveryone(class_2168 src) {
        MinecraftServer server = src.method_9211();
        for (class_3222 i : server.method_3760().method_14571()) {
            server.method_3734().method_9241(i);
        }
    }

    public static class CommandData {
        private final String name;
        private final CommandCategory category;
        private final boolean defaultState;
        private final int defaultOpLevel;

        public CommandData(String name, CommandCategory category) {
            this(name, category, true, 2);
        }

        public CommandData(String name, CommandCategory category, boolean defaultState) {
            this(name, category, defaultState, 2);
        }

        public CommandData(String name, CommandCategory category, boolean defaultState, int defaultOpLevel) {
            this.name = name;
            this.category = category;
            this.defaultState = defaultState;
            this.defaultOpLevel = defaultOpLevel;
        }

        public String getName() {
            return this.name;
        }

        public CommandCategory getCategory() {
            return this.category;
        }

        public boolean isEnabledByDefault() {
            return this.defaultState;
        }

        public int getDefaultOpLevel() {
            return this.defaultOpLevel;
        }
    }

    public static enum CommandCategory {
        MAIN,
        ABILITIES,
        ITEMS_AND_INVENTORY,
        MOVEMENT_AND_TELEPORTATION,
        PLAYERS_AND_ENTITIES,
        WORLD,
        SOCIAL,
        UNCATEGORIZED;

    }
}

