/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.manager;

import com.expecticament.helpfulcommands.manager.ConfigManager;
import com.expecticament.helpfulcommands.style.DefaultStyle;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.expecticament.helpfulcommands.style.MinimalStyle;
import java.util.ArrayList;
import java.util.List;

public class StylingManager {
    private static final List<HelpfulCommandsStyle> styleList = new ArrayList<HelpfulCommandsStyle>();
    private static HelpfulCommandsStyle currentStyle;

    public static void initialize() {
        DefaultStyle defaultStyle = new DefaultStyle();
        styleList.add(defaultStyle);
        styleList.add(new MinimalStyle());
        try {
            HelpfulCommandsStyle configStyle = StylingManager.getStyleByName(ConfigManager.readConfig().getStyleName());
            StylingManager.setCurrentStyle(configStyle == null ? defaultStyle.getDisplayName() : configStyle.getDisplayName());
        }
        catch (StyleDoesntExistException styleDoesntExistException) {
            // empty catch block
        }
    }

    public static HelpfulCommandsStyle getStyle(String styleName) throws StyleDoesntExistException {
        for (HelpfulCommandsStyle style : styleList) {
            if (!style.getDisplayName().equals(styleName)) continue;
            return style;
        }
        throw new StyleDoesntExistException(styleName);
    }

    public static HelpfulCommandsStyle getCurrentStyle() {
        return currentStyle;
    }

    public static HelpfulCommandsStyle getStyleByName(String styleName) {
        for (HelpfulCommandsStyle style : styleList) {
            if (!style.getDisplayName().equals(styleName)) continue;
            return style;
        }
        return null;
    }

    public static List<HelpfulCommandsStyle> getAllStyles() {
        return new ArrayList<HelpfulCommandsStyle>(styleList);
    }

    public static void setCurrentStyle(String styleName) throws StyleDoesntExistException {
        currentStyle = StylingManager.getStyle(styleName);
        ConfigManager.readConfig().setStyle(styleName);
    }

    public static class StyleDoesntExistException
    extends Exception {
        public StyleDoesntExistException(String styleName) {
            super("%s: style doesn't exist!".formatted(styleName));
        }
    }
}

