/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.manager;

import com.expecticament.helpfulcommands.HelpfulCommands;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class TranslationManager {
    private static final Gson GSON = new Gson();
    private static final String FALLBACK_LANG = "en_us";
    private static final Map<String, Map<String, String>> CACHED_TRANSLATIONS = new HashMap<String, Map<String, String>>();

    public static String translate(class_2168 commandSourceStack, String key) {
        class_3222 player = commandSourceStack.method_44023();
        String lang = player != null ? player.method_53823().comp_1951().toLowerCase() : FALLBACK_LANG;
        return TranslationManager.translate(lang, key);
    }

    public static String translate(class_3222 player, String key) {
        String lang = player.method_53823().comp_1951().toLowerCase();
        return TranslationManager.translate(lang, key);
    }

    public static String translate(String lang, String key) {
        String result;
        Map<String, String> langMap = TranslationManager.readLanguageFile(lang);
        if (langMap != null && (result = langMap.get(key)) != null) {
            return result;
        }
        String fallback = TranslationManager.readLanguageFile(FALLBACK_LANG).get(key);
        if (fallback != null) {
            return fallback;
        }
        return key;
    }

    public static void initialize() {
        CACHED_TRANSLATIONS.clear();
        TranslationManager.readLanguageFile(FALLBACK_LANG);
    }

    public static Map<String, String> readLanguageFile(String lang) {
        if (CACHED_TRANSLATIONS.containsKey(lang)) {
            return CACHED_TRANSLATIONS.get(lang);
        }
        try {
            String path = "/assets/helpful_commands/lang/" + lang + ".json";
            InputStream inputStream = HelpfulCommands.class.getResourceAsStream(path);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            HashMap<String, String> translations = new HashMap<String, String>();
            json.entrySet().forEach(entry -> {
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    translations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            });
            CACHED_TRANSLATIONS.put(lang, translations);
            return translations;
        }
        catch (Exception e) {
            return lang.equals(FALLBACK_LANG) ? new HashMap() : TranslationManager.readLanguageFile(FALLBACK_LANG);
        }
    }

    public static class TextBuilder {
        private final class_5250 component = class_2561.method_43470((String)"");
        private final String language;

        public TextBuilder(class_3222 player) {
            this.language = player != null ? player.method_53823().comp_1951().toLowerCase() : TranslationManager.FALLBACK_LANG;
        }

        public TextBuilder(class_2168 commandSourceStack) {
            this(commandSourceStack.method_44023());
        }

        public TextBuilder appendLiteral(String literalText) {
            this.component.method_10852((class_2561)class_2561.method_43470((String)literalText));
            return this;
        }

        public TextBuilder appendTranslatable(String translationKey, class_2561 ... components) {
            String translated = TranslationManager.translate(this.language, translationKey);
            String[] split = translated.split("%s", -1);
            int count = 0;
            for (String str : split) {
                this.component.method_10852((class_2561)class_2561.method_43470((String)str));
                if (components == null || count >= components.length) continue;
                this.component.method_10852(components[count]);
                ++count;
            }
            return this;
        }

        public TextBuilder appendComponent(class_2561 component) {
            this.component.method_10852(component);
            return this;
        }

        public TextBuilder appendWhitespace() {
            return this.appendLiteral(" ");
        }

        public TextBuilder appendNewline() {
            return this.appendLiteral("\n");
        }

        public TextBuilder setStyle(class_2583 style) {
            this.component.method_10862(style);
            return this;
        }

        public class_5250 getComponent() {
            return this.component;
        }
    }

    public static class DeprecatedTextBuilder {
        private final class_5250 component = class_2561.method_43470((String)"");
        private final String language;

        @Deprecated
        public DeprecatedTextBuilder(class_3222 player) {
            this.language = player != null ? player.method_53823().comp_1951().toLowerCase() : TranslationManager.FALLBACK_LANG;
        }

        @Deprecated
        public DeprecatedTextBuilder(class_2168 commandSourceStack) {
            this(commandSourceStack.method_44023());
        }

        public DeprecatedTextBuilder appendLiteral(String literalText) {
            return this.appendLiteral(literalText, class_2583.field_24360);
        }

        public DeprecatedTextBuilder appendLiteral(String literalText, class_2583 style) {
            this.component.method_10852((class_2561)class_2561.method_43470((String)literalText).method_10862(style));
            return this;
        }

        public DeprecatedTextBuilder appendTranslatable(String translationKey) {
            return this.appendTranslatable(translationKey, class_2583.field_24360);
        }

        public DeprecatedTextBuilder appendTranslatable(String translationKey, class_2583 style) {
            String translated = TranslationManager.translate(this.language, translationKey);
            this.component.method_10852((class_2561)class_2561.method_43470((String)translated).method_10862(style));
            return this;
        }

        public DeprecatedTextBuilder appendComponent(class_2561 component) {
            this.component.method_10852(component);
            return this;
        }

        public DeprecatedTextBuilder appendWhitespace() {
            return this.appendLiteral(" ", class_2583.field_24360);
        }

        public DeprecatedTextBuilder appendNewline() {
            return this.appendLiteral("\n", class_2583.field_24360);
        }

        public DeprecatedTextBuilder setStyle(class_2583 style) {
            this.component.method_10862(style);
            return this;
        }

        public class_5250 getComponent() {
            return this.component;
        }
    }
}

