/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.manager;

import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.io.JsonIO;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class WarpManager {
    private static final String FILE_NAME = "warps";
    private static JsonIO<Warps> io;

    public static void addWarp(String warpName, String description, class_2374 position, class_3218 serverLevel) throws WarpAlreadyExistsException {
        Warps warps = Objects.requireNonNullElse(io.read(), new Warps());
        if (warps.entries.putIfAbsent(warpName, new Warp(description, position, serverLevel)) == null) {
            io.save(warps);
            return;
        }
        throw new WarpAlreadyExistsException(warpName);
    }

    public static void removeWarp(String warpName) throws WarpDoesntExistException {
        Warps warps = Objects.requireNonNullElse(io.read(), new Warps());
        if (warps.entries.remove(warpName) != null) {
            io.save(warps);
            return;
        }
        throw new WarpDoesntExistException(warpName);
    }

    public static void editWarpName(String warpName, String newName) throws SameWarpNameProvided, WarpDoesntExistException, WarpAlreadyExistsException {
        if (warpName.equals(newName)) {
            throw new SameWarpNameProvided(newName);
        }
        Warps warps = Objects.requireNonNullElse(io.read(), new Warps());
        if (!warps.entries.containsKey(warpName)) {
            throw new WarpDoesntExistException(warpName);
        }
        if (warps.entries.containsKey(newName)) {
            throw new WarpAlreadyExistsException(newName);
        }
        Warp warp = warps.entries.remove(warpName);
        warps.entries.put(newName, warp);
        io.save(warps);
    }

    public static void editWarpDescription(String warpName, String newDescription) throws WarpDoesntExistException {
        Warps warps = Objects.requireNonNullElse(io.read(), new Warps());
        Warp warp = warps.entries.get(warpName);
        if (warp != null) {
            warp.description = newDescription;
            io.save(warps);
            return;
        }
        throw new WarpDoesntExistException(warpName);
    }

    public static void editWarpLocation(String warpName, class_2374 newPosition, class_3218 newServerLevel) throws WarpDoesntExistException {
        Warps warps = Objects.requireNonNullElse(io.read(), new Warps());
        Warp warp = warps.entries.get(warpName);
        if (warp != null) {
            warp.x = newPosition.method_10216();
            warp.y = newPosition.method_10214();
            warp.z = newPosition.method_10215();
            warp.dimension = ServerLevelHelper.getLevelLocation(newServerLevel);
            io.save(warps);
            return;
        }
        throw new WarpDoesntExistException(warpName);
    }

    public static boolean exists(String warpName) {
        Warps warps = Objects.requireNonNullElse(io.read(), new Warps());
        return warps.entries.containsKey(warpName);
    }

    public static Warp getWarp(String warpName) throws WarpDoesntExistException {
        Warps warps = Objects.requireNonNullElse(io.read(), new Warps());
        Warp warp = warps.entries.get(warpName);
        if (warp != null) {
            return warp;
        }
        throw new WarpDoesntExistException(warpName);
    }

    public static Map<String, Warp> getWarps() {
        return Objects.requireNonNullElse(WarpManager.io.read(), new Warps()).entries;
    }

    public static void initialize(MinecraftServer server) {
        io = new JsonIO<Warps>(server.method_27050(class_5218.field_24188).resolve("helpful_commands4"), FILE_NAME, Warps.class);
    }

    public static void writeToDisk() {
        io.writeToDisk();
    }

    private static class Warps {
        private final Map<String, Warp> entries = new HashMap<String, Warp>();

        private Warps() {
        }
    }

    public static class Warp {
        public String description;
        public double x;
        public double y;
        public double z;
        public String dimension;

        public Warp(String description, class_2374 position, class_3218 serverLevel) {
            this.description = description;
            this.x = position.method_10216();
            this.y = position.method_10214();
            this.z = position.method_10215();
            this.dimension = ServerLevelHelper.getLevelLocation(serverLevel);
        }
    }

    public static class WarpAlreadyExistsException
    extends Exception {
        public WarpAlreadyExistsException(String warpName) {
            super("Warp with this name already exists: %s".formatted(warpName));
        }
    }

    public static class WarpDoesntExistException
    extends Exception {
        public WarpDoesntExistException(String warpName) {
            super("Warp with this name doesn't exist: %s".formatted(warpName));
        }
    }

    public static class SameWarpNameProvided
    extends Exception {
        public SameWarpNameProvided(String newName) {
            super("The new warp name is the same as the old one: %s".formatted(newName));
        }
    }
}

