package com.expecticament.helpfulcommands.command.abilities;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1656;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CMD_god implements IHelpfulCommandsCommand {
    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
            .then(class_2170.method_9244("target(s)", class_2186.method_9308())
                    .then(class_2170.method_9244("state", BoolArgumentType.bool())
                            .executes(ctx -> execute(ctx, class_2186.method_9312(ctx,"target(s)"), BoolArgumentType.getBool(ctx,"state")))
                    )
                    .executes(ctx -> execute(ctx, class_2186.method_9312(ctx,"target(s)")))
            )
            .executes(CMD_god::execute)
            .requires(src -> ModCommandManager.canUseCommand(src, cmd))
        );
    }

    private static int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return execute(ctx, null, null);
    }

    private static int execute(CommandContext<class_2168> ctx, Collection<? extends class_3222> targets) throws CommandSyntaxException {
        return execute(ctx, targets, null);
    }

    private static int execute(CommandContext<class_2168> ctx, Collection<? extends class_3222> targets, Boolean state) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        if(!src.method_43737() && targets == null){
            src.method_9213(class_2561.method_43471("error.specifyTargets"));
            return 0;
        }

        class_3222 plr = src.method_44023();

        if(targets == null || (targets.size() == 1 && targets.contains(plr))) {
            boolean result = toggleGod(plr, state);
            if(result) {
                boolean newState = plr.method_31549().field_7480;
                class_2583 style = newState ? HelpfulCommands.style.enabled : HelpfulCommands.style.disabled;
                src.method_9226(()-> class_2561.method_43471("commands.god.success.self." + newState).method_10862(style),true);

                return Command.SINGLE_SUCCESS;
            } else {
                src.method_9213(class_2561.method_43471("error.nothingChanged"));
                return 0;
            }
        }

        boolean commandFeedback = src.method_9225().method_64395().method_8355(class_1928.field_19400);
        Map<class_1297, Boolean> map = new HashMap<>();
        for(class_3222 i : targets) {
            if(toggleGod(i, state)) {
                boolean newState = i.method_31549().field_7480;

                map.put(i, newState);

                if(commandFeedback && i != plr) {
                    class_2583 style = newState ? HelpfulCommands.style.enabled : HelpfulCommands.style.disabled;
                    i.method_64398(class_2561.method_43471("commands.god.success.self." + newState).method_10862(style));
                }
            }
        }

        int affectedCount = map.size();

        if(affectedCount < 1) {
            src.method_9213(class_2561.method_43471("error.didntFindTargets"));
            return 0;
        }

        if(commandFeedback) {
            class_5250 finalCount = class_2561.method_43470(String.valueOf(affectedCount)).method_10862(HelpfulCommands.style.primary
                    .method_10949(ModCommandManager.targetMapToHoverEvent(map))
            );
            String translationKey = "commands.god.success.other";
            if(state != null) {
                translationKey+="." + state;
            }
            final String finalTranslationKey = translationKey;
            src.method_9226(() -> class_2561.method_43469(finalTranslationKey, finalCount).method_10862(HelpfulCommands.style.success), true);
        }

        return affectedCount;
    }

    private static boolean toggleGod(class_3222 player, Boolean state) {
        class_1656 abilities = player.method_31549();
        boolean before = abilities.field_7480;
        abilities.field_7480 = (state != null) ? state : !abilities.field_7480;

        player.method_7355();

        return before != abilities.field_7480;
    }
}