package com.expecticament.helpfulcommands.command.entities;

import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;

public class CMD_dmg implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register(class_2170.method_9247(cmd.name)
                .requires(src-> ModCommandManager.canUseCommand(src, cmd))
                .then(class_2170.method_9244("target(s)", class_2186.method_9306())
                        .then(class_2170.method_9244("amount", FloatArgumentType.floatArg(0f))
                                .executes(context -> execute(context, class_2186.method_9317(context, "target(s)"), FloatArgumentType.getFloat(context, "amount"), context.getSource().method_9225().method_48963().method_48830()))
                                .then(class_2170.method_9244("damageType", class_7733.method_45603(registryAccess, class_7924.field_42534))
                                        .executes(context -> execute(context, class_2186.method_9317(context, "target(s)"), FloatArgumentType.getFloat(context, "amount"), new class_1282(class_7733.method_45602(context, "damageType", class_7924.field_42534))))
                                        .then(class_2170.method_9247("at")
                                                .then(class_2170.method_9244("location", class_2277.method_9737())
                                                        .executes(context -> execute(context, class_2186.method_9317(context, "target(s)"), FloatArgumentType.getFloat(context, "amount"), new class_1282(class_7733.method_45602(context, "damageType", class_7924.field_42534), class_2277.method_9736(context, "location")))))
                                        )
                                        .then(class_2170.method_9247("by")
                                                .then(class_2170.method_9244("entity", class_2186.method_9309())
                                                        .executes(context -> execute(context, class_2186.method_9317(context, "target(s)"), FloatArgumentType.getFloat(context, "amount"), new class_1282(class_7733.method_45602(context, "damageType", class_7924.field_42534), class_2186.method_9313(context, "entity"))))
                                                        .then(class_2170.method_9247("from")
                                                                .then(class_2170.method_9244("cause", class_2186.method_9309())
                                                                        .executes(context -> execute(context, class_2186.method_9317(context, "target(s)"), FloatArgumentType.getFloat(context, "amount"), new class_1282(class_7733.method_45602(context, "damageType", class_7924.field_42534), class_2186.method_9313(context, "entity"), class_2186.method_9313(context, "cause"))))
                                                                )
                                                        )
                                                )
                                        )
                                )
                        )
                )
        );
    }

    private static int execute(CommandContext<class_2168> ctx, Collection<? extends class_1297> targets, float amount, class_1282 damageSource) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        if(!src.method_43737() && targets == null){
            src.method_9213(class_2561.method_43471("error.specifyTargets"));
            return 0;
        }

        class_3222 plr = src.method_44023();
        class_3218 world = src.method_9225();

        if(targets == null || (targets.size() == 1 && targets.contains(plr))) {
            if(plr.method_64397(world, damageSource, amount)) {
                src.method_9226(() -> class_2561.method_43469("commands.dmg.success.self", class_2561.method_43470(String.valueOf(amount)).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.success), true);
                return Command.SINGLE_SUCCESS;
            } else {
                src.method_9213(class_2561.method_43471("commands.dmg.error.invulnerable.self"));
                return 0;
            }
        }

        boolean commandFeedback = src.method_9225().method_64395().method_8355(class_1928.field_19400);
        ArrayList<class_1297> list = new ArrayList<>();
        for(class_1297 i : targets) {
            if (i.method_64397(world, damageSource, amount)) {
                list.add(i);
            }
        }

        int affectedCount = list.size();

        if(affectedCount < 1) {
            src.method_9213(class_2561.method_43471("error.didntFindTargets"));
            return 0;
        }

        if(commandFeedback) {
            class_5250 finalCount = class_2561.method_43470(String.valueOf(affectedCount)).method_10862(HelpfulCommands.style.primary
                    .method_10949(ModCommandManager.targetListToHoverEvent(list))
            );
            src.method_9226(() -> class_2561.method_43469("commands.dmg.success.other", class_2561.method_43470(String.valueOf(amount)).method_10862(HelpfulCommands.style.primary), finalCount).method_10862(HelpfulCommands.style.success), true);
        }

        return affectedCount;
    }
}
