package com.expecticament.helpfulcommands.command.entities;

import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7157;
import net.minecraft.class_9334;

public class CMD_hat implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                .executes(CMD_hat::execute)
                .then(class_2170.method_9244("target", class_2186.method_9308())
                        .executes(ctx -> execute(ctx, class_2186.method_9312(ctx, "target")))
                        .then(class_2170.method_9244("item", class_2287.method_9776(registryAccess))
                                .executes(ctx -> execute(ctx, class_2186.method_9312(ctx, "target"), class_2287.method_9777(ctx, "item").method_9781(1, true)))
                        )
                )
                .requires(src -> ModCommandManager.canUseCommand(src, cmd))
        );
    }

    private static int execute(CommandContext<class_2168> ctx) {
        Collection<class_3222> collection = new ArrayList<>();
        collection.add(ctx.getSource().method_44023());
        return execute(ctx, collection, null);
    }

    private static int execute(CommandContext<class_2168> ctx, Collection<? extends class_3222> targets) {
        return execute(ctx, targets, null);
    }

    private static int execute(CommandContext<class_2168> ctx, Collection<? extends class_3222> targets, class_1799 specifiedItemStack) {
        class_2168 src = ctx.getSource();

        class_3222 plr = src.method_44023();

        class_1799 itemStack = specifiedItemStack;

        final class_2561 targetAmountText = getTargetAmountText(new ArrayList<>(targets));

        if(specifiedItemStack == null) {
            if(!src.method_43737()) {
                src.method_9213(class_2561.method_43471("error.inGameOnly"));
                return -1;
            }
            class_1799 handItemStack = plr.method_6047();
            if(handItemStack == null || handItemStack == class_1799.field_8037) {
                src.method_9213(class_2561.method_43471("error.nothingInMainHand"));
                return -1;
            }
            itemStack = handItemStack.method_7972();

            if (!plr.method_68878() && !plr.method_64475(HelpfulCommands.defaultCommandLevel)) {
                if(targets.size() > itemStack.method_7947()) {
                    src.method_9213(class_2561.method_43469("commands.hat.error.notEnough", getItemNameText(handItemStack), targetAmountText));
                    return -1;
                }

                handItemStack.method_7939(handItemStack.method_7947() - targets.size());
            }
        }

        itemStack.method_7939(1);

        boolean isSelfOnly = (targets.size() == 1 && targets.contains(plr));
        boolean isAir = (itemStack.method_7909() == class_1802.field_8162);

        final class_2561 itemNameText = getItemNameText(itemStack);

        for(class_3222 i : targets) {
            i.method_31548().method_5447(39, itemStack.method_7972());
            i.method_17356(class_3417.field_14883.comp_349(), class_3419.field_15248, 1, 1);
            if(i != plr) {
                if(isAir) {
                    i.method_64398(class_2561.method_43471("commands.hat.removed.self").method_10862(HelpfulCommands.style.tertiary));
                }
                else {
                    i.method_64398(class_2561.method_43469("commands.hat.success.self", itemNameText).method_10862(HelpfulCommands.style.tertiary));
                }
            }
        }

        if(!isSelfOnly) {
            if(isAir) {
                src.method_9226(()-> class_2561.method_43469("commands.hat.removed.other", targetAmountText).method_10862(HelpfulCommands.style.success), true);
            } else {
                src.method_9226(()-> class_2561.method_43469("commands.hat.success.other", itemNameText, targetAmountText).method_10862(HelpfulCommands.style.success), true);
            }
        } else {
            if(isAir) {
                plr.method_64398(class_2561.method_43471("commands.hat.removed.self").method_10862(HelpfulCommands.style.success));
            }  else {
                plr.method_64398(class_2561.method_43469("commands.hat.success.self", itemNameText).method_10862(HelpfulCommands.style.success));
            }
        }

        return Command.SINGLE_SUCCESS;
    }

    private static class_2561 getTargetAmountText(List<class_3222> targets) {
        StringBuilder names = new StringBuilder();
        for(class_3222 i : targets) {
            names.append(i.method_5476().getString());
            if(i != targets.getLast()) {
                names.append("\n");
            }
        }

        return class_2561.method_43470(String.valueOf(targets.size())).method_10862(HelpfulCommands.style.primary.method_10949(
                new class_2568.class_10613(class_2561.method_43470(names.toString()))
        ));
    }

    private static class_2561 getItemNameText(class_1799 itemStack) {
        String name = (itemStack.method_58694(class_9334.field_49631) == null) ? itemStack.method_63693().getString() : itemStack.method_65130().getString();
        return class_2561.method_43470(name).method_10862(HelpfulCommands.style.primary);
    }
}
