package com.expecticament.helpfulcommands.command.main;

import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.util.ConfigManager;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.text.*;
import java.net.URI;
import java.util.LinkedList;
import java.util.Map;

public class CMD_hc implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;
    static class_2170.class_5364 _environment;

    public static void init(ModCommandManager.ModCommand newData){
        cmd=newData;
    }
    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        LiteralArgumentBuilder<class_2168> cmdManagement=class_2170.method_9247("manageCommand");
        for(ModCommandManager.ModCommand i : ModCommandManager.commands){
            if(i.category==ModCommandManager.ModCommandCategory.Main) continue;
            LiteralArgumentBuilder<class_2168> literalCommand=class_2170.method_9247(i.name)
                    .then(class_2170.method_9247("toggleEnabled")
                            .executes(ctx-> toggleCommandState(ctx,i))
                            .then(class_2170.method_9244("state", BoolArgumentType.bool())
                                    .executes(ctx -> toggleCommandState(ctx, i, BoolArgumentType.getBool(ctx, "state"))))
                    )
                    .then(class_2170.method_9247("togglePublic")
                            .executes(ctx-> toggleCommandPublicState(ctx,i))
                            .then(class_2170.method_9244("state", BoolArgumentType.bool())
                                    .executes(ctx -> toggleCommandPublicState(ctx, i, BoolArgumentType.getBool(ctx, "state"))))
                    );
            cmdManagement.then(literalCommand);
        }
        cmdManagement.requires(Permissions.require(HelpfulCommands.modID+".config.manageCommand",HelpfulCommands.defaultConfigEditLevel));

        LiteralArgumentBuilder<class_2168> fieldManagement=class_2170.method_9247("manageField");
        for(Map.Entry<String, ConfigManager.ModConfigFieldEntry> i : ConfigManager.defaultConfigFieldEntries.entrySet()){
            LiteralArgumentBuilder<class_2168> literalField=class_2170.method_9247(i.getKey())
                    .then(class_2170.method_9247("query")
                            .executes(ctx-> queryConfigField(ctx,i.getKey()))
                    )
                    .then(class_2170.method_9247("set")
                            .then(i.getValue().configCommandArgument
                                    .executes(ctx->{
                                        i.getValue().context=ctx;
                                        try {
                                            return editConfigEntry(ctx,i.getKey(),i.getValue().getValue.call());
                                        } catch (Exception e) {
                                            ctx.getSource().method_9213(class_2561.method_43470("Error"));
                                            return 0;
                                        }
                                    })
                            )
                    );
            fieldManagement.then(literalField);
        }
        fieldManagement.requires(Permissions.require(HelpfulCommands.modID+".config.manageField",HelpfulCommands.defaultConfigEditLevel));

        dispatcher.register(class_2170.method_9247(cmd.name)
                .then(class_2170.method_9247("about")
                        .executes(CMD_hc::printModInfo)
                )
                .then(class_2170.method_9247("commandList")
                        .executes(CMD_hc::printCommandList)
                )
                .then(class_2170.method_9247("config")
                        .then(cmdManagement)
                        .then(fieldManagement)
                        .executes(CMD_hc::printModConfig)
                        .requires(src-> Permissions.check(src,HelpfulCommands.modID+".config",HelpfulCommands.defaultConfigEditLevel) || Permissions.check(src,HelpfulCommands.modID+".config.manageCommand",HelpfulCommands.defaultConfigEditLevel) || Permissions.check(src,HelpfulCommands.modID+".config.manageField",HelpfulCommands.defaultConfigEditLevel))
                )
                .executes(CMD_hc::printModInfo)
        );

        _environment=environment;
    }

    private static class_5250 getHeader(String translationKey,boolean isPlayer){
        class_5250 ret=class_2561.method_43473().method_10862(HelpfulCommands.style.primary);
        if(isPlayer) ret.method_10852(class_2561.method_43470("« ").method_27692(class_124.field_1067));
        else ret.method_10852(class_2561.method_43470("<- "));
        ret
                .method_10852(class_2561.method_43470(HelpfulCommands.modName).method_27692(class_124.field_1067))
                .method_10852(class_2561.method_43470(" || ").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43471(translationKey).method_10862(HelpfulCommands.style.secondary))
        ;
        if(isPlayer) ret.method_10852(class_2561.method_43470(" »").method_27692(class_124.field_1067));
        else ret.method_10852(class_2561.method_43470(" ->"));
        ret.method_27693("\n");

        return ret;
    }

    private static int printModInfo(CommandContext<class_2168> ctx) throws CommandSyntaxException{
        class_2168 source=ctx.getSource();

        boolean hasConfigFieldPermissions=Permissions.check(source,HelpfulCommands.modID+".config.manageField",HelpfulCommands.defaultConfigEditLevel);

        class_5250 mainBlock=class_2561.method_43473().method_10862(HelpfulCommands.style.simpleText);
        mainBlock
                .method_10852(class_2561.method_43470(" "))
                .method_10852(class_2561.method_43471("mod.description"))
                .method_10852(class_2561.method_43470("\n "))
                .method_10852(class_2561.method_43469("mod.version",HelpfulCommands.modVersion,"Expecticament").method_10862(HelpfulCommands.style.inactive))
                .method_10852(class_2561.method_43470("\n\n"))
        ;

        class_2583 buttonStyle=HelpfulCommands.style.secondary;
        class_5250 buttonCommandList=class_2561.method_43473()
                .method_10852(class_2561.method_43471("commandList.title"))
                .method_10862(buttonStyle
                        .method_10958(new class_2558.class_10609("/hc commandList"))
                        .method_10949(new class_2568.class_10613(class_2561.method_43471("about.commandList.tooltip")))
                );
        class_5250 buttonConfig=class_2561.method_43473()
                .method_10852(class_2561.method_43471("config.title"))
                .method_10862(buttonStyle
                        .method_10958(new class_2558.class_10609("/hc config"))
                        .method_10949(new class_2568.class_10613(class_2561.method_43471("about.config.tooltip")))
                );
        class_5250 buttonDocumentation=class_2561.method_43471("about.documentation").method_10862(buttonStyle
                .method_10958(new class_2558.class_10608(URI.create("https://helpfulcommands.expecticament.com/")))
                .method_10949(new class_2568.class_10613(class_2561.method_43471("about.documentation.tooltip")))
        );
        class_5250 buttonGitHub=class_2561.method_43470("GitHub").method_10862(buttonStyle
                .method_10958(new class_2558.class_10608(URI.create("https://github.com/Expecticament/helpful-commands")))
                .method_10949(new class_2568.class_10613(class_2561.method_43471("about.github.tooltip")))
        );
        class_5250 buttonCurseForge=class_2561.method_43470("CurseForge").method_10862(buttonStyle
                .method_10958(new class_2558.class_10608(URI.create("https://www.curseforge.com/minecraft/mc-mods/helpful-commands")))
                .method_10949(new class_2568.class_10613(class_2561.method_43471("about.curseforge.tooltip")))
        );
        class_5250 buttonModrinth=class_2561.method_43470("Modrinth").method_10862(buttonStyle
                .method_10958(new class_2558.class_10608(URI.create("https://modrinth.com/mod/helpful-commands")))
                .method_10949(new class_2568.class_10613(class_2561.method_43471("about.modrinth.tooltip")))
        );
        class_5250 buttons=class_2561.method_43473();
        if(ctx.getSource().method_43737()) {
            buttons
                    .method_10852(class_2561.method_43470("〚"))
                    .method_10852(buttonCommandList);
            if(hasConfigFieldPermissions){
                buttons
                        .method_10852(class_2561.method_43470(" • "))
                        .method_10852(buttonConfig)
                ;
            }
            buttons
                    .method_10852(class_2561.method_43470("〛"))
                    .method_10852(class_2561.method_43470("\n〚"))
                    .method_10852(buttonDocumentation)
                    .method_10852(class_2561.method_43470(" • "))
                    .method_10852(buttonGitHub)
                    .method_10852(class_2561.method_43470(" • "))
                    .method_10852(buttonCurseForge)
                    .method_10852(class_2561.method_43470(" • "))
                    .method_10852(buttonModrinth)
                    .method_10852(class_2561.method_43470("〛"))
            ;
        } else{
            buttons
                    .method_10852(buttonCommandList)
                    .method_10852(class_2561.method_43470(": /hc commandList\n"))
                    .method_10852(buttonConfig)
                    .method_10852(class_2561.method_43470(": /hc config\n"))
                    .method_10852(buttonGitHub)
                    .method_10852(class_2561.method_43470(": https://github.com/Expecticament/helpful-commands \n"))
                    .method_10852(buttonDocumentation)
                    .method_10852(class_2561.method_43470(": https://helpfulcommands.expecticament.com/ \n"))
                    .method_10852(buttonCurseForge)
                    .method_10852(class_2561.method_43470(": https://www.curseforge.com/minecraft/mc-mods/helpful-commands \n"))
                    .method_10852(buttonModrinth)
                    .method_10852(class_2561.method_43470(": https://modrinth.com/mod/helpful-commands \n"))
            ;
        }

        class_5250 msg=class_2561.method_43473()
                .method_10852(class_2561.method_43470("\n"))
                .method_10852(getHeader("about.title",ctx.getSource().method_43737()))
                .method_10852(mainBlock)
                .method_10852(buttons)
        ;
        source.method_45068(msg);

        return Command.SINGLE_SUCCESS;
    }

    private static int printCommandList(CommandContext<class_2168> ctx) throws CommandSyntaxException{
        class_2168 source=ctx.getSource();

        boolean executedByPlayer=ctx.getSource().method_43737();

        class_5250 header=class_2561.method_43473().method_10862(HelpfulCommands.style.simpleText);
        if(executedByPlayer) header.method_10852(class_2561.method_43470("[• "));
        boolean hasPerms=Permissions.check(source,HelpfulCommands.modID+".config.manageCommand",HelpfulCommands.defaultConfigEditLevel); // Determine whether we should print "Enabled/Disabled"(true) or "You can/can't use"(false)
        if(hasPerms){
            class_5250 pub=class_2561.method_43471("commandList.command.public").method_10862(HelpfulCommands.style.secondary);
            class_5250 res=class_2561.method_43471("commandList.command.restricted").method_10862(HelpfulCommands.style.inactive);
            class_5250 enabled=class_2561.method_43471("commandList.command.enabled").method_10862(HelpfulCommands.style.enabled);
            class_5250 disabled=class_2561.method_43471("commandList.command.disabled").method_10862(HelpfulCommands.style.disabled);
            header
                    .method_10852(pub)
                    .method_10852(class_2561.method_43470("/"))
                    .method_10852(res)
                    .method_10852(class_2561.method_43470(" | "))
            ;
            if(executedByPlayer){
                header
                        .method_10852(enabled)
                        .method_10852(class_2561.method_43470("/"))
                        .method_10852(disabled)
                ;
            } else{
                header
                        .method_10852(class_2561.method_43470("[+]"))
                        .method_10852(enabled)
                        .method_27693(" / [-]")
                        .method_10852(disabled)
                ;
            }
        } else{
            header
                    .method_10852(class_2561.method_43471("commandList.command.usage.you"))
                    .method_10852(class_2561.method_43470(" "))
                    .method_10852(class_2561.method_43471("commandList.command.usage.can").method_10862(HelpfulCommands.style.enabled))
                    .method_10852(class_2561.method_43470("/"))
                    .method_10852(class_2561.method_43471("commandList.command.usage.cant").method_10862(HelpfulCommands.style.disabled))
                    .method_10852(class_2561.method_43470(" "))
                    .method_10852(class_2561.method_43471("commandList.command.usage.use"))
            ;
        }
        if(executedByPlayer) header.method_10852(class_2561.method_43470(" •]"));

        class_5250 commandList=class_2561.method_43473();
        class_2583 charsStyle=HelpfulCommands.style.tertiary;

        ConfigManager.ModConfig cfg=ConfigManager.loadConfig(ctx.getSource().method_9211());

        for(Map.Entry<ModCommandManager.ModCommandCategory, LinkedList<ModCommandManager.ModCommand>> i : ModCommandManager.commandListByCategory.entrySet()){
            if(i.getValue().isEmpty()) continue;
            commandList
                    .method_10852(class_2561.method_43470("\n"))
                    .method_10852(class_2561.method_43470("┏").method_10862(charsStyle))
                    .method_10852(class_2561.method_43471("commands.category."+i.getKey().name().toLowerCase()).method_10862(HelpfulCommands.style.tertiary))
            ;

            for(ModCommandManager.ModCommand j : i.getValue()){
                class_2583 descriptionStyle=HelpfulCommands.style.inactive;
                if(hasPerms) descriptionStyle=getSuggestCommandStyle(j.name).method_27703(HelpfulCommands.style.inactive.method_10973());

                String chars="┠";
                if(j==i.getValue().getLast()) chars="┗";
                commandList.method_10852(class_2561.method_43470("\n"+chars+"› ").method_10862(charsStyle));
                if(hasPerms && j.category!=ModCommandManager.ModCommandCategory.Main){ // If source has permissions, then display command public state
                    class_2568 he=new class_2568.class_10613(class_2561.method_43469("tooltips.clickToToggleCommandPublicState",class_2561.method_43470("/"+j.name).method_10862(HelpfulCommands.style.tertiary)));
                    class_2558 ce=new class_2558.class_10609("/hc config manageCommand "+j.name+" togglePublic");
                    commandList.method_10852(cfg.commands.get(j.name).isPublic ? class_2561.method_43471("commandList.command.public.abbreviation").method_10862(HelpfulCommands.style.secondary.method_10958(ce).method_10949(he)) : class_2561.method_43471("commandList.command.restricted.abbreviation").method_10862(HelpfulCommands.style.inactive.method_10958(ce).method_10949(he)));
                    commandList.method_10852(class_2561.method_43470(" "));
                }
                if(!ctx.getSource().method_43737() && j.category!=ModCommandManager.ModCommandCategory.Main){
                    commandList.method_10852(cfg.commands.getOrDefault(j.name,new ConfigManager.ModConfigCommandEntry()).isEnabled ? class_2561.method_43470("[+] ") : class_2561.method_43470("[-] "));
                }
                commandList
                        .method_10852(class_2561.method_43470(j.name).method_10862(getCommandNameStyle(j,source,cfg,hasPerms)))
                        .method_10852(class_2561.method_43470(": ").method_10852(class_2561.method_43471("commands."+j.name+".description").method_10862(descriptionStyle)))
                ;
            }
        }

        class_5250 msg=class_2561.method_43473()
                .method_10852(class_2561.method_43470("\n"))
                .method_10852(getHeader("commandList.title",ctx.getSource().method_43737()))
                .method_10852(header)
                .method_10852(class_2561.method_43470("\n"))
                .method_10852(commandList)
        ;
        source.method_45068(msg);

        return Command.SINGLE_SUCCESS;
    }

    private static class_2583 getCommandNameStyle(ModCommandManager.ModCommand command, class_2168 src, ConfigManager.ModConfig cfg, boolean hasConfigPerms){
        class_2583 ret;

        boolean commandState=true;
        if(command.category!=ModCommandManager.ModCommandCategory.Main){
            commandState=cfg.commands.getOrDefault(command.name,new ConfigManager.ModConfigCommandEntry()).isEnabled;
        }

        if(hasConfigPerms){
            ret = commandState ? HelpfulCommands.style.enabled : HelpfulCommands.style.disabled;
            if(command.category!=ModCommandManager.ModCommandCategory.Main){
                ret=ret
                        .method_10949(new class_2568.class_10613(class_2561.method_43469("tooltips.clickToToggleCommand",class_2561.method_43470("/"+command.name).method_10862(HelpfulCommands.style.tertiary))))
                        .method_10958(new class_2558.class_10609("/hc config manageCommand "+command.name+" toggleEnabled"));
            }
        } else{
            class_2583 suggestCommand=getSuggestCommandStyle(command.name);
            ret=suggestCommand.method_27703(HelpfulCommands.style.enabled.method_10973());
            class_5250 txt=ModCommandManager.getCantUseCommandReason(src,command);
            if(txt!=null){
                ret=HelpfulCommands.style.error.method_10949(new class_2568.class_10613(txt));
            }
        }
        return ret;
    }

    private static class_2583 getSuggestCommandStyle(String commandName){
        return class_2583.field_24360
                .method_10958(new class_2558.class_10610("/"+commandName+" "))
                .method_10949(new class_2568.class_10613(class_2561.method_43469("tooltips.clickToSuggestCommand",class_2561.method_43470("/"+commandName).method_10862(HelpfulCommands.style.tertiary))))
        ;
    }

    private static int printModConfig(CommandContext<class_2168> ctx) throws CommandSyntaxException{
        class_2168 src=ctx.getSource();

        if(!integratedServerHostCheck(src)){
            return -1;
        }

        if(!Permissions.check(src,HelpfulCommands.modID+".config.manageField",HelpfulCommands.defaultConfigEditLevel)){
            src.method_9213(class_2561.method_43471("error.notAllowedToConfigureFields"));
            return -1;
        }
        boolean isPlayer=src.method_43737();
        ConfigManager.ModConfig cfg=ConfigManager.loadConfig(src.method_9211());

        class_5250 msg=class_2561.method_43470("\n");
        msg
                .method_10852(getHeader("config.title",isPlayer))
                .method_10852(class_2561.method_43470(" "))
                .method_10852(class_2561.method_43469("config.topNotice",class_2561.method_43473().method_10852(isPlayer ? class_2561.method_43473().method_10852(class_2561.method_43470("[").method_10852(class_2561.method_43471("commandList.title").method_27693("]")).method_10862(HelpfulCommands.style.secondary.method_10949(new class_2568.class_10613(class_2561.method_43471("about.commandList.tooltip"))).method_10958(new class_2558.class_10609("/hc commandList")))) : class_2561.method_43470("(/hc commandList)")              )))
        ;
        for(Map.Entry<String, Object> e : cfg.fields.entrySet()){
            msg
                    .method_10852(class_2561.method_43470("\n"))
                    .method_10852(class_2561.method_43470("\n"))
                    .method_10852(class_2561.method_43470("- ").method_10852(class_2561.method_43470(e.getKey()).method_10862(HelpfulCommands.style.primary)))
                    .method_10852(class_2561.method_43470(" | "))
                    .method_10852(class_2561.method_43470(e.getValue().toString()).method_10862(HelpfulCommands.style.tertiary.method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToEditConfigValue"))).method_10958(new class_2558.class_10610("/hc config manageField "+e.getKey()+" set "))))
                    .method_10852(class_2561.method_43470("\n "))
                    .method_10852(class_2561.method_43471("config.field."+e.getKey()+".description").method_10862(HelpfulCommands.style.inactive))
            ;
        }

        src.method_45068(msg);
        return Command.SINGLE_SUCCESS;
    }

    private static int editConfigEntry(CommandContext<class_2168> ctx, String entry, Object value) throws CommandSyntaxException{
        class_2168 src=ctx.getSource();

        if(!integratedServerHostCheck(src)){
            return -1;
        }

        ConfigManager.ModConfig cfg=ConfigManager.loadConfig(src.method_9211());
        if(!cfg.fields.containsKey(entry)){
            src.method_9213(class_2561.method_43469("commands.hc.config.setValue.error.unknownValue",class_2561.method_43470(entry).method_10862(HelpfulCommands.style.primary)));
            return -1;
        }
        cfg.fields.put(entry,value);
        ConfigManager.saveConfig(cfg,src.method_9211());

        src.method_9226(()->class_2561.method_43469("commands.hc.config.setValue.success",class_2561.method_43470(entry).method_10862(HelpfulCommands.style.primary),class_2561.method_43470(String.valueOf(value)).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.success),true);

        ModCommandManager.sendCommandTreeToEveryone(src);

        return Command.SINGLE_SUCCESS;
    }
    private static int queryConfigField(CommandContext<class_2168> ctx, String entry){
        class_2168 src=ctx.getSource();

        if(!integratedServerHostCheck(src)){
            return -1;
        }

        ConfigManager.ModConfig cfg=ConfigManager.loadConfig(src.method_9211());
        if(!cfg.fields.containsKey(entry)){
            src.method_9213(class_2561.method_43469("commands.hc.config.getValue.error.unknownValue",class_2561.method_43470(entry).method_10862(HelpfulCommands.style.primary)));
            return -1;
        }

        src.method_45068(class_2561.method_43469("commands.hc.config.getValue.success",class_2561.method_43470(entry).method_10862(HelpfulCommands.style.primary),class_2561.method_43470(String.valueOf(cfg.fields.get(entry))).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.secondary));

        return Command.SINGLE_SUCCESS;
    }

    private static int toggleCommandState(CommandContext<class_2168> ctx, ModCommandManager.ModCommand cmd){
        class_2168 src=ctx.getSource();

        if(!integratedServerHostCheck(src)){
            return -1;
        }

        ConfigManager.ModConfig cfg=ConfigManager.loadConfig(src.method_9211());
        return toggleCommandState(ctx,cmd,!cfg.commands.getOrDefault(cmd.name,new ConfigManager.ModConfigCommandEntry()).isEnabled);
    }
    private static int toggleCommandState(CommandContext<class_2168> ctx, ModCommandManager.ModCommand cmd, Boolean value){
        class_2168 src=ctx.getSource();

        if(!integratedServerHostCheck(src)){
            return -1;
        }

        ConfigManager.ModConfig cfg=ConfigManager.loadConfig(src.method_9211());
        if(cmd==null){
            src.method_9213(class_2561.method_43471("commands.hc.config.manageCommand.toggleEnabled.error.unknownCommand"));
            return -1;
        }

        cfg.commands.get(cmd.name).isEnabled=value;
        ConfigManager.saveConfig(cfg,src.method_9211());

        class_2583 messageStyle=value ? HelpfulCommands.style.enabled : HelpfulCommands.style.disabled;
        class_2583 commandNameStyle=value ? HelpfulCommands.style.primary.method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToSuggestThisCommand"))).method_10958(new class_2558.class_10610("/"+cmd.name)) : HelpfulCommands.style.primary;
        src.method_9226(()->class_2561.method_43469("commands.hc.config.manageCommand.toggleEnabled.success."+String.valueOf(value).toLowerCase(),class_2561.method_43470("/"+cmd.name).method_10862(commandNameStyle)).method_10862(messageStyle),true);

        ModCommandManager.sendCommandTreeToEveryone(src);

        return Command.SINGLE_SUCCESS;
    }

    private static int toggleCommandPublicState(CommandContext<class_2168> ctx, ModCommandManager.ModCommand cmd){
        class_2168 src=ctx.getSource();

        if(!integratedServerHostCheck(src)){
            return -1;
        }

        ConfigManager.ModConfig cfg=ConfigManager.loadConfig(src.method_9211());
        return toggleCommandPublicState(ctx,cmd,!cfg.commands.getOrDefault(cmd.name,new ConfigManager.ModConfigCommandEntry()).isPublic);
    }
    private static int toggleCommandPublicState(CommandContext<class_2168> ctx, ModCommandManager.ModCommand cmd, Boolean value){
        class_2168 src=ctx.getSource();

        if(!integratedServerHostCheck(src)){
            return -1;
        }

        ConfigManager.ModConfig cfg=ConfigManager.loadConfig(src.method_9211());
        if(cmd==null){
            src.method_9213(class_2561.method_43471("commands.hc.config.manageCommand.togglePublic.error.unknownCommand"));
            return -1;
        }

        cfg.commands.get(cmd.name).isPublic=value;
        ConfigManager.saveConfig(cfg,src.method_9211());

        class_2583 messageStyle=HelpfulCommands.style.success;
        class_2583 commandNameStyle=HelpfulCommands.style.primary.method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToSuggestThisCommand"))).method_10958(new class_2558.class_10610("/"+cmd.name));
        src.method_9226(()->class_2561.method_43469("commands.hc.config.manageCommand.togglePublic.success."+String.valueOf(value).toLowerCase(),class_2561.method_43470("/"+cmd.name
        ).method_10862(commandNameStyle)).method_10862(messageStyle),true);

        ModCommandManager.sendCommandTreeToEveryone(src);

        return Command.SINGLE_SUCCESS;
    }

    private static boolean integratedServerHostCheck(class_2168 src){
        if(_environment==class_2170.class_5364.field_25421) if(src.method_44023()!=null) if(src.method_44023().method_7334()!=src.method_9211().method_43824()){
            src.method_9213(class_2561.method_43471("error.cantEditConfigOnIntegratedIfNotHost"));
            return false;
        }
        return true;
    }
}