package com.expecticament.helpfulcommands.command.teleportation;

import com.expecticament.helpfulcommands.util.ConfigManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import java.util.HashSet;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_239;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class CMD_jump implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd=newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                        .then(class_2170.method_9244("distance", DoubleArgumentType.doubleArg(1))
                                .executes(ctx->execute(ctx, DoubleArgumentType.getDouble(ctx,"distance")))
                                .then(class_2170.method_9244("checkForBlocks",BoolArgumentType.bool())
                                        .executes(ctx->execute(ctx, DoubleArgumentType.getDouble(ctx, "distance"), BoolArgumentType.getBool(ctx, "checkForBlocks")))
                                )
                        )
                .executes(CMD_jump::execute)
                .requires(src->ModCommandManager.canUseCommand(src,cmd))
        );
    }

    private static int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return execute(ctx, -1, false);
    }

    private static int execute(CommandContext<class_2168> ctx, double distance) throws CommandSyntaxException {
        return execute(ctx, distance, false);
    }

    private static int execute(CommandContext<class_2168> ctx, double distance, boolean checkForBlocks) throws CommandSyntaxException {
        class_2168 src=ctx.getSource();

        if(!src.method_43737()) {
            src.method_9213(class_2561.method_43471("error.inGameOnly"));
            return -1;
        }

        class_3222 plr=src.method_44023();
        double posX, posY, posZ;

        double distanceConfigValue = Double.parseDouble(ConfigManager.loadConfig(src.method_9211()).fields.get("jumpDistanceLimit").toString());
        if(distanceConfigValue < 0) distanceConfigValue = 0;

        if(distance<0){
            class_239 hit = getHitResult(plr, plr.method_52371() * 24, distanceConfigValue);
            if(hit!=null && hit.method_17783()==class_239.class_240.field_1332){
                posX = hit.method_17784().method_10216();
                posY = hit.method_17784().method_10214();
                posZ = hit.method_17784().method_10215();
            } else{
                return Command.SINGLE_SUCCESS;
            }
        } else{
            if(Double.compare(distanceConfigValue, 0)!=0){
                if(distance > distanceConfigValue){
                    src.method_9213(class_2561.method_43469("commands.jump.error.distanceLimitExceeded", class_2561.method_43470(String.valueOf(distance)).method_10862(HelpfulCommands.style.primary), class_2561.method_43470(String.valueOf(distanceConfigValue)).method_10862(HelpfulCommands.style.primary)));
                    return -1;
                }
            }

            if(checkForBlocks){
                class_239 hit = getHitResult(plr, distance, distanceConfigValue);
                if(hit!=null && hit.method_17783()==class_239.class_240.field_1332){
                    posX = hit.method_17784().method_10216();
                    posY = hit.method_17784().method_10214();
                    posZ = hit.method_17784().method_10215();
                } else{
                    posX = plr.method_23317() + plr.method_5720().method_10216() * distance;
                    posY = (plr.method_23318() + plr.method_18381(plr.method_18376()) + plr.method_5720().method_10214() * distance) - 1;
                    posZ = plr.method_23321() + plr.method_5720().method_10215() * distance;
                }
            } else{
                posX = plr.method_23317() + plr.method_5720().method_10216() * distance;
                posY = (plr.method_23318() + plr.method_18381(plr.method_18376()) + plr.method_5720().method_10214() * distance) - 1;
                posZ = plr.method_23321() + plr.method_5720().method_10215() * distance;
            }
        }

        teleport(src,posX,posY,posZ);

        return Command.SINGLE_SUCCESS;
    }

    private static class_239 getHitResult(class_3222 plr, double distance, double distanceConfigValue){
        distance = Double.compare(distanceConfigValue, 0)==0 ? distance : Math.clamp(distance, 1.0, distanceConfigValue);
        return plr.method_5745(distance, 0, false);
    }

    private static void teleport(class_2168 src, double posX, double posY, double posZ){
        class_3222 plr=src.method_44023();
        if(plr==null) return;

        plr.method_48105(plr.method_51469(), posX, posY, posZ, new HashSet<>(),plr.method_36454(), plr.method_36455(), false);
        src.method_9226(()->class_2561.method_43469("commands.jump.success",class_2561.method_43470(String.format("%.2f",posX)).method_10862(HelpfulCommands.style.primary),class_2561.method_43470(String.format("%.2f",posY)).method_10862(HelpfulCommands.style.primary),class_2561.method_43470(String.format("%.2f",posZ)).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.secondary
                .method_10958(new class_2558.class_10609("/tp @s "+posX+" "+posY+" "+posZ))
                .method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToTeleportToCoordinates")))
        ),true);
    }
}