package com.expecticament.helpfulcommands.command.utility;

import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_9334;

public class CMD_repair implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd=newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                .then(class_2170.method_9244("target(s)", class_2186.method_9308())
                        .executes(ctx->execute(ctx,class_2186.method_9312(ctx,"target(s)")))
                )
                .executes(CMD_repair::execute)
                .requires(src->ModCommandManager.canUseCommand(src,cmd))
        );
    }

    private static int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException{
        class_2168 source=ctx.getSource();
        if(!source.method_43737()){
            source.method_9213(class_2561.method_43471("error.specifyTargets"));
            return -1;
        }

        class_3222 player=source.method_44023();
        if(player==null) return -1;

        class_1799 itemStack=player.method_6047();
        if(itemStack==null || itemStack.method_7960()){
            source.method_9213(class_2561.method_43471("error.nothingInMainHand"));
            return -1;
        }
        if(!itemStack.method_7963()){
            source.method_9213(class_2561.method_43471("commands.repair.error.notDamageable"));
            return -1;
        }
        if(itemStack.method_7919()==0){
            source.method_9213(class_2561.method_43471("commands.repair.error.notDamaged"));
            return -1;
        }

        itemStack.method_57379(class_9334.field_49629, 0);
        source.method_9226(()-> class_2561.method_43469("commands.repair.success.self", itemStack.method_7964().method_27661().method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.success),true);

        return Command.SINGLE_SUCCESS;
    }

    private static int execute(CommandContext<class_2168> ctx, Collection<? extends class_3222> targets) throws CommandSyntaxException{
        class_2168 source=ctx.getSource();

        int count=0;
        String s="";
        for(class_3222 i : targets){
            class_1799 itemStack=i.method_6047();
            if(itemStack==null || itemStack.method_7960() || !itemStack.method_7963() || itemStack.method_7919()==0){
                continue;
            }
            itemStack.method_57379(class_9334.field_49629, 0);
            s=s+i.method_5477().getString()+" - "+itemStack.method_7964().getString()+"\n";
            count++;
        }
        if(count>0) s=s.substring(0, s.length()-1);

        class_2561 hoverText=class_2561.method_43470(s);

        if(count<=0){
            source.method_9213(class_2561.method_43471("error.didntFindTargets"));
        } else {
            int finalCount=count;
            source.method_9226(() -> class_2561.method_43469("commands.repair.success.other", class_2561.method_43470(String.valueOf(finalCount)).method_10862(HelpfulCommands.style.primary.method_10949(new class_2568.class_10613(hoverText)))).method_10862(HelpfulCommands.style.success), true);
        }

        return Command.SINGLE_SUCCESS;
    }
}
