package com.expecticament.helpfulcommands.command.world;

import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_239;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.util.ConfigManager;

public class CMD_explosion implements IHelpfulCommandsCommand {
    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                .then(class_2170.method_9244("power", IntegerArgumentType.integer(1))
                        .then(class_2170.method_9244("distance", DoubleArgumentType.doubleArg(0))
                                .executes(ctx -> execute(ctx, IntegerArgumentType.getInteger(ctx,"power"), DoubleArgumentType.getDouble(ctx,"distance")))
                        )
                        .executes(ctx -> execute(ctx, IntegerArgumentType.getInteger(ctx,"power")))
                )
                .requires(src -> ModCommandManager.canUseCommand(src, cmd))
        );
    }

    private static int execute(CommandContext<class_2168> ctx, int power) throws CommandSyntaxException {
        return execute(ctx, power, -1);
    }

    private static int execute(CommandContext<class_2168> ctx, int power, double distance) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        int powerLimitConfigValue = (Double.valueOf(ConfigManager.loadConfig(src.method_9211()).fields.get("explosionPowerLimit").toString())).intValue();
        if(powerLimitConfigValue < 1){
            powerLimitConfigValue = 1;
        }
        if(power > powerLimitConfigValue){
            powerLimitExceeded(src, power, powerLimitConfigValue);
            return -1;
        }

        if(!src.method_43737()) {
            src.method_9213(class_2561.method_43471("error.inGameOnly"));
            return -1;
        } else{
            class_3222 plr = src.method_44023();

            if(distance < 0) {
                class_239 hit = plr.method_5745(plr.method_52371() * 16, 0, false);
                if (hit != null && hit.method_17783() == class_239.class_240.field_1332) {
                    double posX = hit.method_17784().method_10216();
                    double posY = hit.method_17784().method_10214();
                    double posZ = hit.method_17784().method_10215();

                    createExplosion(src,power,posX,posY,posZ);
                }
            } else{
                double posX = plr.method_23317() + plr.method_5720().method_10216() * distance;
                double posY = (plr.method_23318() + plr.method_18381(plr.method_18376()) + plr.method_5720().method_10214() * distance) - 1;
                double posZ = plr.method_23321() + plr.method_5720().method_10215() * distance;

                createExplosion(src, power, posX, posY, posZ);
            }
        }

        return Command.SINGLE_SUCCESS;
    }

    private static void powerLimitExceeded(class_2168 src, int specifiedPower, int configValue){
        src.method_9213(class_2561.method_43469("commands.explosion.error.powerLimitExceeded", class_2561.method_43470(String.valueOf(specifiedPower)).method_10862(HelpfulCommands.style.primary), class_2561.method_43470(String.valueOf(configValue)).method_10862(HelpfulCommands.style.primary)));
    }

    private static void createExplosion(class_2168 src, int power, double posX, double posY, double posZ){
        src.method_9225().method_8437(null, posX, posY, posZ, power, class_1937.class_7867.field_40891);

        src.method_9226(() -> class_2561.method_43469("commands.explosion.success", class_2561.method_43470(String.valueOf(power)).method_10862(HelpfulCommands.style.primary), class_2561.method_43470(String.format("%.2f", posX)).method_10862(HelpfulCommands.style.primary), class_2561.method_43470(String.format("%.2f", posY)).method_10862(HelpfulCommands.style.primary), class_2561.method_43470(String.format("%.2f", posZ)).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.secondary
                .method_10958(new class_2558.class_10609("/tp @s " + posX+" " + posY + " " + posZ))
                .method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToTeleportToCoordinates")))
        ),true);
    }
}