/*
 * Decompiled with CFR 0.152.
 */
package dev.erdragh.broomba.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.erdragh.broomba.entity.BroombaEntity;
import dev.erdragh.broomba.entity.BroombaMenu;
import dev.erdragh.broomba.entity.BroombaModel;
import dev.erdragh.broomba.entity.DisabledWhileWithoutBrain;
import dev.erdragh.broomba.entity.HasBrainSensor;
import dev.erdragh.broomba.item.BrainItem;
import dev.erdragh.broomba.item.ItemRegistryKt;
import dev.erdragh.broomba.util.ExtensionsKt;
import dev.erdragh.broomba.util.RestrictedItemStacksResourceHandler;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animatable.processing.AnimationTest;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.TextureLayerGeoLayer;
import software.bernie.geckolib.util.GeckoLibUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0012\u0018\u0000 D2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\u00020\u0004:\u0003BCDB%\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u001f\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001fH\u0002J\u0010\u0010 \u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fH\u0016J\f\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0014J\u0014\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000%0$H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00000'H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00000'H\u0016J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020*H\u0014J \u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u0002042\u0006\u00101\u001a\u0002022\u0006\u00105\u001a\u000206H\u0014J\u0006\u00107\u001a\u000208J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010@\u001a\u00020AH\u0014R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0010*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Ldev/erdragh/broomba/entity/BroombaEntity;", "Lnet/minecraft/world/entity/PathfinderMob;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "Lnet/tslat/smartbrainlib/api/SmartBrainOwner;", "Lnet/minecraft/world/MenuProvider;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "position", "Lnet/minecraft/world/phys/Vec3;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "animatableInstanceCache", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "brainContainer", "dev/erdragh/broomba/entity/BroombaEntity$brainContainer$1", "Ldev/erdragh/broomba/entity/BroombaEntity$brainContainer$1;", "DRIVE_ANIM", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getMainArm", "Lnet/minecraft/world/entity/HumanoidArm;", "registerControllers", "", "controllers", "Lsoftware/bernie/geckolib/animatable/manager/AnimatableManager$ControllerRegistrar;", "driveAnimController", "Lsoftware/bernie/geckolib/animation/PlayState;", "animTest", "Lsoftware/bernie/geckolib/animatable/processing/AnimationTest;", "getAnimatableInstanceCache", "brainProvider", "Lnet/minecraft/world/entity/ai/Brain$Provider;", "getSensors", "", "Lnet/tslat/smartbrainlib/api/core/sensor/ExtendedSensor;", "getCoreTasks", "Lnet/tslat/smartbrainlib/api/core/BrainActivityGroup;", "getIdleTasks", "customServerAiStep", "Lnet/minecraft/server/level/ServerLevel;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "mobInteract", "Lnet/minecraft/world/InteractionResult;", "hand", "Lnet/minecraft/world/InteractionHand;", "hasBrain", "", "load", "input", "Lnet/minecraft/world/level/storage/ValueInput;", "save", "output", "Lnet/minecraft/world/level/storage/ValueOutput;", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "Renderer", "RenderState", "Companion", "Broomba"})
public final class BroombaEntity
extends PathfinderMob
implements GeoEntity,
SmartBrainOwner<BroombaEntity>,
MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final AnimatableInstanceCache animatableInstanceCache;
    @NotNull
    private final brainContainer.1 brainContainer;
    private final RawAnimation DRIVE_ANIM;
    private static final EntityDataAccessor<ItemStack> BRAIN_CONTAINER = SynchedEntityData.defineId(BroombaEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public BroombaEntity(@NotNull EntityType<BroombaEntity> type, @NotNull Level level, @NotNull Vec3 position) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        super(type, level);
        this.setPos(position);
        this.animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        List list = CollectionsKt.listOf(ItemRegistryKt.getBRAIN_ITEM());
        this.brainContainer = new RestrictedItemStacksResourceHandler(this, list){
            final /* synthetic */ BroombaEntity this$0;
            {
                this.this$0 = $receiver;
                super((Collection<? extends ItemLike>)$super_call_param$1, 1);
            }

            protected void onContentsChanged(int index, ItemStack previousContents) {
                Intrinsics.checkNotNullParameter((Object)previousContents, (String)"previousContents");
                BroombaEntity.access$getEntityData$p$s-763718625(this.this$0).set(BroombaEntity.Companion.getBRAIN_CONTAINER(), this.stacks.get(index), true);
                super.onContentsChanged(index, (Object)previousContents);
            }
        };
        this.DRIVE_ANIM = RawAnimation.begin().thenLoop("driving");
    }

    public BroombaEntity(@NotNull EntityType<BroombaEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this(type, level, vec3);
    }

    @NotNull
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController("Driving", 5, this::driveAnimController));
    }

    private final PlayState driveAnimController(AnimationTest<BroombaEntity> animTest) {
        if (animTest.isMoving()) {
            PlayState playState = animTest.setAndContinue(this.DRIVE_ANIM);
            Intrinsics.checkNotNullExpressionValue((Object)playState, (String)"setAndContinue(...)");
            return playState;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @NotNull
    protected Brain.Provider<?> brainProvider() {
        return (Brain.Provider)new SmartBrainProvider((LivingEntity)this);
    }

    @NotNull
    public List<ExtendedSensor<BroombaEntity>> getSensors() {
        Object[] objectArray = new ExtendedSensor[]{new NearbyLivingEntitySensor(), new HurtBySensor(), new HasBrainSensor()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public BrainActivityGroup<BroombaEntity> getCoreTasks() {
        Behavior[] behaviorArray = new Behavior[1];
        ExtendedBehaviour[] extendedBehaviourArray = new ExtendedBehaviour[2];
        extendedBehaviourArray[0] = new DisabledWhileWithoutBrain();
        ExtendedBehaviour[] extendedBehaviourArray2 = new ExtendedBehaviour[]{new LookAtTarget(), new MoveToWalkTarget()};
        extendedBehaviourArray[1] = new AllApplicableBehaviours(extendedBehaviourArray2);
        behaviorArray[0] = new FirstApplicableBehaviour(extendedBehaviourArray);
        BrainActivityGroup brainActivityGroup = BrainActivityGroup.coreTasks((Behavior[])behaviorArray);
        Intrinsics.checkNotNullExpressionValue((Object)brainActivityGroup, (String)"coreTasks(...)");
        return brainActivityGroup;
    }

    @NotNull
    public BrainActivityGroup<BroombaEntity> getIdleTasks() {
        Behavior[] behaviorArray = new Behavior[1];
        ExtendedBehaviour[] extendedBehaviourArray = new ExtendedBehaviour[3];
        extendedBehaviourArray[0] = new DisabledWhileWithoutBrain();
        ExtendedBehaviour[] extendedBehaviourArray2 = new ExtendedBehaviour[]{new SetPlayerLookTarget(), new SetRandomLookTarget()};
        extendedBehaviourArray[1] = new FirstApplicableBehaviour(extendedBehaviourArray2);
        extendedBehaviourArray2 = new ExtendedBehaviour[]{new SetRandomWalkTarget(), new Idle().runFor(BroombaEntity::getIdleTasks$lambda$0)};
        extendedBehaviourArray[2] = new OneRandomBehaviour(extendedBehaviourArray2);
        behaviorArray[0] = new FirstApplicableBehaviour(extendedBehaviourArray);
        BrainActivityGroup brainActivityGroup = BrainActivityGroup.idleTasks((Behavior[])behaviorArray);
        Intrinsics.checkNotNullExpressionValue((Object)brainActivityGroup, (String)"idleTasks(...)");
        return brainActivityGroup;
    }

    protected void customServerAiStep(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.tickBrain((LivingEntity)this);
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new BroombaMenu(containerId, playerInventory, this.brainContainer, this);
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!this.level().isClientSide() && player instanceof ServerPlayer && player.distanceTo((Entity)this) < 3.0f) {
            ((ServerPlayer)player).openMenu((MenuProvider)this, arg_0 -> BroombaEntity.mobInteract$lambda$0(this, arg_0));
        }
        InteractionResult.Success success = InteractionResult.SUCCESS;
        Intrinsics.checkNotNullExpressionValue((Object)success, (String)"SUCCESS");
        return (InteractionResult)success;
    }

    public final boolean hasBrain() {
        return ((ItemStack)this.entityData.get(BRAIN_CONTAINER)).getItem() instanceof BrainItem;
    }

    public void load(@NotNull ValueInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.load(input);
        input.child("brainContainer").ifPresent(arg_0 -> BroombaEntity.load$lambda$1(arg_0 -> BroombaEntity.load$lambda$0(this, arg_0), arg_0));
        this.entityData.set(BRAIN_CONTAINER, (Object)((ItemResource)this.brainContainer.getResource(0)).toStack(), true);
    }

    public boolean save(@NotNull ValueOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.brainContainer.serialize(output.child("brainContainer"));
        return super.save(output);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(BRAIN_CONTAINER, (Object)ItemStack.EMPTY);
    }

    private static final int getIdleTasks$lambda$0(BroombaEntity it) {
        return it.random.nextInt(10, 60);
    }

    private static final void mobInteract$lambda$0(BroombaEntity this$0, RegistryFriendlyByteBuf it) {
        it.writeInt(this$0.getId());
    }

    private static final Unit load$lambda$0(BroombaEntity this$0, ValueInput it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.brainContainer.deserialize(it);
        return Unit.INSTANCE;
    }

    private static final void load$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ SynchedEntityData access$getEntityData$p$s-763718625(BroombaEntity $this) {
        return $this.entityData;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R5\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ldev/erdragh/broomba/entity/BroombaEntity$Companion;", "", "<init>", "()V", "BRAIN_CONTAINER", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Lnet/minecraft/world/item/ItemStack;", "kotlin.jvm.PlatformType", "getBRAIN_CONTAINER", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "Broomba"})
    public static final class Companion {
        private Companion() {
        }

        public final EntityDataAccessor<ItemStack> getBRAIN_CONTAINER() {
            return BRAIN_CONTAINER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J1\u0010\t\u001a\u00020\n\"\n\b\u0000\u0010\u000b*\u0004\u0018\u00010\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00072\b\u0010\r\u001a\u0004\u0018\u0001H\u000bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J+\u0010\u0011\u001a\u0004\u0018\u0001H\u000b\"\n\b\u0000\u0010\u000b*\u0004\u0018\u00010\b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u000b0\u0007H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0014H\u0016R \u0010\u0005\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/erdragh/broomba/entity/BroombaEntity$RenderState;", "Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;", "Lsoftware/bernie/geckolib/renderer/base/GeoRenderState;", "<init>", "()V", "geckolibData", "", "Lsoftware/bernie/geckolib/constant/dataticket/DataTicket;", "", "addGeckolibData", "", "D", "dataTicket", "data", "(Lsoftware/bernie/geckolib/constant/dataticket/DataTicket;Ljava/lang/Object;)V", "hasGeckolibData", "", "getGeckolibData", "(Lsoftware/bernie/geckolib/constant/dataticket/DataTicket;)Ljava/lang/Object;", "getDataMap", "", "Broomba"})
    public static final class RenderState
    extends LivingEntityRenderState
    implements GeoRenderState {
        @NotNull
        private final Map<DataTicket<?>, Object> geckolibData = new LinkedHashMap();

        public <D> void addGeckolibData(@NotNull DataTicket<D> dataTicket, @Nullable D data) {
            Intrinsics.checkNotNullParameter(dataTicket, (String)"dataTicket");
            this.geckolibData.put(dataTicket, data);
        }

        public boolean hasGeckolibData(@NotNull DataTicket<?> dataTicket) {
            Intrinsics.checkNotNullParameter(dataTicket, (String)"dataTicket");
            return this.geckolibData.containsKey(dataTicket);
        }

        @Nullable
        public <D> D getGeckolibData(@NotNull DataTicket<D> dataTicket) {
            Intrinsics.checkNotNullParameter(dataTicket, (String)"dataTicket");
            return (D)this.geckolibData.get(dataTicket);
        }

        @NotNull
        public Map<DataTicket<?>, Object> getDataMap() {
            return this.geckolibData;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R2\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/erdragh/broomba/entity/BroombaEntity$Renderer;", "Lsoftware/bernie/geckolib/renderer/GeoEntityRenderer;", "Ldev/erdragh/broomba/entity/BroombaEntity;", "Ldev/erdragh/broomba/entity/BroombaEntity$RenderState;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "hasBrainTicket", "Lsoftware/bernie/geckolib/constant/dataticket/DataTicket;", "", "kotlin.jvm.PlatformType", "createRenderState", "animatable", "relatedObject", "Ljava/lang/Void;", "Broomba"})
    public static final class Renderer
    extends GeoEntityRenderer<BroombaEntity, RenderState> {
        private final DataTicket<Boolean> hasBrainTicket;

        public Renderer(@NotNull EntityRendererProvider.Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, (GeoModel)new BroombaModel());
            this.hasBrainTicket = DataTicket.create((String)"hasBrain", Boolean.TYPE);
            this.withRenderLayer((GeoRenderLayer)new TextureLayerGeoLayer((GeoRenderer)this, ExtensionsKt.loc("textures/entity/broomba_dome.png"), RenderType.ARMOR_TRANSLUCENT));
            this.withRenderLayer((GeoRenderLayer)new GeoRenderLayer<BroombaEntity, Void, RenderState>(){

                protected ResourceLocation getTextureResource(RenderState renderState) {
                    Intrinsics.checkNotNullParameter((Object)((Object)renderState), (String)"renderState");
                    ResourceLocation resourceLocation = ExtensionsKt.loc("textures/entity/broomba_brain.png");
                    Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"loc(...)");
                    return resourceLocation;
                }

                public void submitRenderTask(RenderState renderState, PoseStack poseStack, BakedGeoModel bakedModel, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor, boolean didRenderModel) {
                    Intrinsics.checkNotNullParameter((Object)((Object)renderState), (String)"renderState");
                    Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
                    Intrinsics.checkNotNullParameter((Object)bakedModel, (String)"bakedModel");
                    Intrinsics.checkNotNullParameter((Object)renderTasks, (String)"renderTasks");
                    Intrinsics.checkNotNullParameter((Object)cameraState, (String)"cameraState");
                    if (!didRenderModel) {
                        return;
                    }
                    DataTicket dataTicket = hasBrainTicket;
                    Intrinsics.checkNotNullExpressionValue((Object)dataTicket, (String)"access$getHasBrainTicket$p(...)");
                    Boolean hasBrain = (Boolean)renderState.getGeckolibData(dataTicket);
                    if (!Intrinsics.areEqual((Object)true, (Object)hasBrain)) {
                        return;
                    }
                    this.renderer.buildRenderTask((GeoRenderState)renderState, poseStack, bakedModel, renderTasks.order(1), cameraState, RenderType.entityCutout((ResourceLocation)this.getTextureResource(renderState)), packedLight, packedOverlay, renderColor);
                }
            });
        }

        @NotNull
        public RenderState createRenderState(@NotNull BroombaEntity animatable, @Nullable Void relatedObject) {
            Intrinsics.checkNotNullParameter((Object)((Object)animatable), (String)"animatable");
            RenderState state = new RenderState();
            DataTicket<Boolean> dataTicket = this.hasBrainTicket;
            Intrinsics.checkNotNullExpressionValue(dataTicket, (String)"hasBrainTicket");
            state.addGeckolibData(dataTicket, animatable.hasBrain());
            return state;
        }
    }
}

