/*
 * Decompiled with CFR 0.152.
 */
package dev.erdragh.broomba.entity;

import dev.erdragh.broomba.entity.BroombaEntity;
import dev.erdragh.broomba.item.ItemRegistryKt;
import dev.erdragh.broomba.ui.MenuTypeRegistryKt;
import dev.erdragh.broomba.util.RestrictedItemStacksResourceHandler;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/erdragh/broomba/entity/BroombaMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "", "playerInv", "Lnet/minecraft/world/entity/player/Inventory;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;)V", "dataInventory", "Ldev/erdragh/broomba/util/RestrictedItemStacksResourceHandler;", "entity", "Ldev/erdragh/broomba/entity/BroombaEntity;", "(ILnet/minecraft/world/entity/player/Inventory;Ldev/erdragh/broomba/util/RestrictedItemStacksResourceHandler;Ldev/erdragh/broomba/entity/BroombaEntity;)V", "Lnet/minecraft/world/entity/Entity;", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "index", "stillValid", "", "Broomba"})
@SourceDebugExtension(value={"SMAP\nBroombaMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroombaMenu.kt\ndev/erdragh/broomba/entity/BroombaMenu\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class BroombaMenu
extends AbstractContainerMenu {
    @Nullable
    private final Entity entity;

    public BroombaMenu(int containerId, @NotNull Inventory playerInv) {
        Intrinsics.checkNotNullParameter((Object)playerInv, (String)"playerInv");
        this(containerId, playerInv, new RestrictedItemStacksResourceHandler((Collection<? extends ItemLike>)CollectionsKt.listOf(ItemRegistryKt.getBRAIN_ITEM()), 1), null);
    }

    public BroombaMenu(int containerId, @NotNull Inventory playerInv, @NotNull RestrictedItemStacksResourceHandler dataInventory, @Nullable BroombaEntity entity) {
        Intrinsics.checkNotNullParameter((Object)playerInv, (String)"playerInv");
        Intrinsics.checkNotNullParameter((Object)((Object)dataInventory), (String)"dataInventory");
        super((MenuType)MenuTypeRegistryKt.getBROOMBA_MENU().get(), containerId);
        if (!(dataInventory.size() == 1)) {
            boolean bl = false;
            String string = "Brain container is not of size 1";
            throw new IllegalArgumentException(string.toString());
        }
        this.entity = (Entity)entity;
        this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)dataInventory, (arg_0, arg_1, arg_2) -> ((RestrictedItemStacksResourceHandler)dataInventory).set(arg_0, arg_1, arg_2), 0, 80, 35));
        this.addStandardInventorySlots((Container)playerInv, 8, 84);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack movedStack = ItemStack.EMPTY;
        Object object = this.slots.get(index);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Slot movedSlot = (Slot)object;
        if (movedSlot.hasItem()) {
            ItemStack rawStack = movedSlot.getItem();
            movedStack = rawStack.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(rawStack, 1, this.slots.size(), true)) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            } else if (!this.moveItemStackTo(rawStack, 0, 1, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            if (rawStack.isEmpty()) {
                movedSlot.setByPlayer(ItemStack.EMPTY);
            } else {
                movedSlot.setChanged();
            }
            movedSlot.onTake(player, rawStack);
        }
        ItemStack itemStack = movedStack;
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.entity == null) {
            return true;
        }
        return this.entity.isAlive() && this.entity.position().distanceTo(player.position()) <= 3.0;
    }
}

