/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.loohp.imageframe.objectholders.PreferenceState;
import com.loohp.imageframe.objectholders.UnsetState;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;

public enum BooleanState implements UnsetState,
PreferenceState
{
    TRUE(new JsonPrimitive(true)),
    FALSE(new JsonPrimitive(false)),
    UNSET(new JsonPrimitive("unset"));

    public static final Map<String, BooleanState> STRING_VALUES_MAP;
    private final JsonElement jsonValue;

    private BooleanState(JsonElement jsonValue) {
        this.jsonValue = jsonValue;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    @Override
    public boolean isUnset() {
        return this.equals(UNSET);
    }

    @Override
    public JsonElement getJsonValue() {
        return this.jsonValue;
    }

    public Boolean getRawValue() {
        switch (this.ordinal()) {
            case 0: {
                return Boolean.TRUE;
            }
            case 1: {
                return Boolean.FALSE;
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    public boolean getRawValue(boolean unsetIsTrue) {
        switch (this.ordinal()) {
            case 0: {
                return Boolean.TRUE;
            }
            case 1: {
                return Boolean.FALSE;
            }
            case 2: {
                return unsetIsTrue;
            }
        }
        return unsetIsTrue;
    }

    public boolean getCalculatedValue(BooleanSupplier unsetValueFunction) {
        switch (this.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return unsetValueFunction.getAsBoolean();
            }
        }
        return unsetValueFunction.getAsBoolean();
    }

    public static BooleanState fromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static BooleanState fromBoolean(Boolean value) {
        return value == null ? UNSET : BooleanState.fromBoolean((boolean)value);
    }

    public static BooleanState fromString(String value) {
        return STRING_VALUES_MAP.getOrDefault(value.toLowerCase(), UNSET);
    }

    public static BooleanState fromJsonValue(JsonElement jsonValue) {
        if (jsonValue.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonValue.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean()) {
                return BooleanState.fromBoolean(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isString()) {
                return BooleanState.fromString(jsonPrimitive.getAsString());
            }
        }
        return UNSET;
    }

    static {
        STRING_VALUES_MAP = Collections.unmodifiableMap(Arrays.stream(BooleanState.values()).collect(Collectors.toMap(e -> e.toString(), e -> e, (x, y) -> y, LinkedHashMap::new)));
    }
}

