/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ImageMapAccessControl {
    public static final UUID EVERYONE = new UUID(-1L, -1L);
    private final ImageMap imageMap;
    private final Map<UUID, ImageMapAccessPermissionType> permissions;

    public ImageMapAccessControl(ImageMap imageMap, Map<UUID, ImageMapAccessPermissionType> hasAccess) {
        this.imageMap = imageMap;
        this.permissions = new ConcurrentHashMap<UUID, ImageMapAccessPermissionType>(hasAccess);
    }

    public ImageMapAccessPermissionType getPermission(UUID player) {
        if (player.equals(this.imageMap.getCreator())) {
            return ImageMapAccessPermissionType.ALL;
        }
        return this.permissions.get(player);
    }

    public ImageMapAccessPermissionType getPermissionForEveryone() {
        return this.getPermission(EVERYONE);
    }

    public Map<UUID, ImageMapAccessPermissionType> getPermissions() {
        return Collections.unmodifiableMap(this.permissions);
    }

    public boolean hasPermission(UUID player, ImageMapAccessPermissionType permissionType) {
        if (permissionType == null) {
            return true;
        }
        if (player.equals(this.imageMap.getCreator())) {
            return true;
        }
        if (!player.equals(EVERYONE) && this.hasPermissionForEveryone(permissionType)) {
            return true;
        }
        ImageMapAccessPermissionType type = this.permissions.get(player);
        if (type == null) {
            return false;
        }
        return type.containsPermission(permissionType);
    }

    public boolean hasPermissionForEveryone(ImageMapAccessPermissionType permissionType) {
        return this.hasPermission(EVERYONE, permissionType);
    }

    public void setPermissionForEveryone(ImageMapAccessPermissionType permissionType) throws Exception {
        this.setPermission(EVERYONE, permissionType);
    }

    protected void setPermissionForEveryoneWithoutSave(ImageMapAccessPermissionType permissionType) {
        this.setPermissionWithoutSave(EVERYONE, permissionType);
    }

    public void setPermission(UUID player, ImageMapAccessPermissionType permissionType) throws Exception {
        this.setPermission(player, permissionType, true);
    }

    protected void setPermissionWithoutSave(UUID player, ImageMapAccessPermissionType permissionType) {
        try {
            this.setPermission(player, permissionType, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void reapply(Map<UUID, ImageMapAccessPermissionType> hasAccess) {
        this.permissions.clear();
        this.permissions.putAll(hasAccess);
    }

    private void setPermission(UUID player, ImageMapAccessPermissionType permissionType, boolean save) throws Exception {
        if (player.equals(this.imageMap.getCreator())) {
            return;
        }
        if (permissionType == null) {
            this.permissions.remove(player);
        } else {
            this.permissions.put(player, permissionType);
        }
        if (save) {
            this.imageMap.save();
        }
    }
}

