/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ImageMapAccessPermissionType {
    public static final ImageMapAccessPermissionType GET = new ImageMapAccessPermissionType("GET", new ImageMapAccessPermissionType[0]);
    public static final ImageMapAccessPermissionType ADJUST_PLAYBACK = new ImageMapAccessPermissionType("ADJUST_PLAYBACK", GET);
    public static final ImageMapAccessPermissionType MARKER = new ImageMapAccessPermissionType("MARKER", GET);
    public static final ImageMapAccessPermissionType EDIT = new ImageMapAccessPermissionType("EDIT", MARKER);
    public static final ImageMapAccessPermissionType EDIT_CLONE = new ImageMapAccessPermissionType("EDIT_CLONE", EDIT);
    public static final ImageMapAccessPermissionType ALL = new ImageMapAccessPermissionType("ALL", EDIT_CLONE);
    public static final ImageMapAccessPermissionType BASE = new ImageMapAccessPermissionType("BASE", new ImageMapAccessPermissionType[0]){

        @Override
        public boolean containsPermission(ImageMapAccessPermissionType type) {
            return TYPES.containsKey(type.name());
        }
    };
    private static final Map<String, ImageMapAccessPermissionType> TYPES = new HashMap<String, ImageMapAccessPermissionType>();
    private final String name;
    private final Set<ImageMapAccessPermissionType> inheritance;

    public static void register(ImageMapAccessPermissionType type) {
        TYPES.put(type.name(), type);
    }

    public static ImageMapAccessPermissionType valueOf(String name) {
        ImageMapAccessPermissionType type = TYPES.get(name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException(name + " is not a registered ImageMapAccessPermissionType");
    }

    public static Map<String, ImageMapAccessPermissionType> values() {
        return Collections.unmodifiableMap(TYPES);
    }

    public ImageMapAccessPermissionType(String name, ImageMapAccessPermissionType ... inheritance) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.inheritance = Collections.unmodifiableSet(new HashSet<ImageMapAccessPermissionType>(Arrays.asList(inheritance)));
    }

    public String name() {
        return this.name;
    }

    public boolean containsPermission(ImageMapAccessPermissionType type) {
        if (this.equals(type)) {
            return true;
        }
        for (ImageMapAccessPermissionType inheritedType : this.inheritance) {
            if (inheritedType.equals(this) || !inheritedType.containsPermission(type)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageMapAccessPermissionType type = (ImageMapAccessPermissionType)o;
        return this.name.equals(type.name) && this.inheritance.equals(type.inheritance);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.inheritance);
    }

    static {
        ImageMapAccessPermissionType.register(GET);
        ImageMapAccessPermissionType.register(ADJUST_PLAYBACK);
        ImageMapAccessPermissionType.register(MARKER);
        ImageMapAccessPermissionType.register(EDIT);
        ImageMapAccessPermissionType.register(EDIT_CLONE);
        ImageMapAccessPermissionType.register(ALL);
    }
}

