/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils;

import com.loohp.imageframe.utils.SizeLimitedByteArrayOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class HTTPRequestUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject getJSONResponse(String link) {
        JSONObject jSONObject;
        URL url = new URL(link);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.addRequestProperty("User-Agent", "Mozilla/5.0");
        connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.addRequestProperty("Pragma", "no-cache");
        if (connection.getResponseCode() != 200) return null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            String reply = reader.lines().collect(Collectors.joining());
            jSONObject = (JSONObject)new JSONParser().parse(reply);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParseException e) {
                return null;
            }
        }
        reader.close();
        return jSONObject;
    }

    public static InputStream getInputStream(String link) throws IOException {
        URLConnection connection = new URL(link).openConnection();
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.addRequestProperty("User-Agent", "Mozilla/5.0");
        connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.addRequestProperty("Pragma", "no-cache");
        return connection.getInputStream();
    }

    public static byte[] download(String link, long sizeLimit) throws IOException {
        try (InputStream is = HTTPRequestUtils.getInputStream(link);){
            int n;
            SizeLimitedByteArrayOutputStream baos = new SizeLimitedByteArrayOutputStream(sizeLimit);
            byte[] byteChunk = new byte[4096];
            while ((n = is.read(byteChunk)) > 0) {
                ((ByteArrayOutputStream)baos).write(byteChunk, 0, n);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static long getContentSize(String link) {
        try {
            URLConnection connection = new URL(link).openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0");
            connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            connection.addRequestProperty("Pragma", "no-cache");
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
            }
            return connection.getContentLengthLong();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public static String getContentType(String link) {
        try {
            URLConnection connection = new URL(link).openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0");
            connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            connection.addRequestProperty("Pragma", "no-cache");
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
            }
            return connection.getContentType();
        }
        catch (IOException e) {
            return "";
        }
    }
}

