/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.invisibleframe;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.ScheduledTask;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.nms.NMS;
import com.loohp.imageframe.utils.MCVersion;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class InvisibleFrameManager
implements Listener {
    public static final NamespacedKey INVISIBLE_GLOW_ITEM_FRAME_CRAFTING_KEY = new NamespacedKey((Plugin)ImageFrame.plugin, "invisible_glow_item_frame");
    public static final NamespacedKey INVISIBLE_KEY = new NamespacedKey((Plugin)ImageFrame.plugin, "invisible");
    private final Map<UUID, Location> removedInvisibleFrames = new ConcurrentHashMap<UUID, Location>();
    private final Set<UUID> knownAreaEffectClouds = ConcurrentHashMap.newKeySet();
    private final AtomicLong itemFramesMadeInvisible = new AtomicLong(0L);
    private final AtomicLong invisibleItemFramesPlaced = new AtomicLong(0L);

    public InvisibleFrameManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImageFrame.plugin);
        if (ImageFrame.version.isNewerOrEqualTo(MCVersion.V1_17)) {
            this.addRecipes();
        }
    }

    public AtomicLong getItemFramesMadeInvisible() {
        return this.itemFramesMadeInvisible;
    }

    public AtomicLong getInvisibleItemFramesPlaced() {
        return this.invisibleItemFramesPlaced;
    }

    private void addRecipes() {
        CraftingRecipe vanillaRecipe;
        ItemStack result = new ItemStack(Material.valueOf((String)"GLOW_ITEM_FRAME"));
        ShapelessRecipe recipe = new ShapelessRecipe(INVISIBLE_GLOW_ITEM_FRAME_CRAFTING_KEY, this.withInvisibleItemFrameData(result)).addIngredient(Material.valueOf((String)"GLOW_INK_SAC")).addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(this.withInvisibleItemFrameData(new ItemStack(Material.ITEM_FRAME))));
        if (ImageFrame.version.isNewerOrEqualTo(MCVersion.V1_20) && (vanillaRecipe = (CraftingRecipe)Bukkit.getRecipesFor((ItemStack)result).stream().filter(r -> r instanceof CraftingRecipe).findFirst().orElse(null)) != null) {
            recipe.setCategory(vanillaRecipe.getCategory());
            recipe.setGroup(vanillaRecipe.getGroup());
        }
        Bukkit.addRecipe((Recipe)recipe);
    }

    public ItemStack withInvisibleItemFrameData(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return itemStack;
        }
        if (this.isInvisibleItemFrame(itemStack)) {
            return itemStack;
        }
        ItemStack modified = NMS.getInstance().withInvisibleItemFrameMeta(itemStack);
        ItemMeta meta = modified.getItemMeta();
        if (meta == null) {
            return itemStack;
        }
        meta.getPersistentDataContainer().set(INVISIBLE_KEY, PersistentDataType.BYTE, (Object)1);
        modified.setItemMeta(meta);
        return modified;
    }

    public boolean isInvisibleItemFrame(ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        return (Byte)meta.getPersistentDataContainer().getOrDefault(INVISIBLE_KEY, PersistentDataType.BYTE, (Object)0) > 0;
    }

    public void setInvisibleItemFrameData(Entity entity) {
        if (entity instanceof ItemFrame) {
            entity.getPersistentDataContainer().set(INVISIBLE_KEY, PersistentDataType.BYTE, (Object)1);
        }
    }

    public boolean isInvisibleItemFrame(Entity entity) {
        return entity instanceof ItemFrame && (Byte)entity.getPersistentDataContainer().getOrDefault(INVISIBLE_KEY, PersistentDataType.BYTE, (Object)0) > 0;
    }

    public void updateInvisibleItemFrame(ItemFrame itemFrame) {
        if (!itemFrame.isValid()) {
            return;
        }
        ItemStack itemStack = itemFrame.getItem();
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            if (ImageFrame.invisibleFrameGlowEmptyFrames) {
                itemFrame.setGlowing(true);
            }
            itemFrame.setVisible(true);
        } else {
            itemFrame.setGlowing(false);
            itemFrame.setVisible(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onGrindstone(PrepareGrindstoneEvent event) {
        GrindstoneInventory inventory = event.getInventory();
        if (this.isInvisibleItemFrame(inventory.getItem(0)) || this.isInvisibleItemFrame(inventory.getItem(1))) {
            event.setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlace(HangingPlaceEvent event) {
        if (!this.isInvisibleItemFrame(event.getItemStack())) {
            return;
        }
        Hanging entity = event.getEntity();
        Location location = entity.getLocation();
        this.setInvisibleItemFrameData((Entity)entity);
        this.invisibleItemFramesPlaced.incrementAndGet();
        Scheduler.runTaskLater((Plugin)ImageFrame.plugin, () -> this.lambda$onPlace$1((Entity)entity), 1L, location);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreak(HangingBreakEvent event) {
        Hanging entity = event.getEntity();
        if (!this.isInvisibleItemFrame((Entity)entity)) {
            return;
        }
        UUID uuid = entity.getUniqueId();
        Location location = entity.getLocation();
        this.removedInvisibleFrames.put(uuid, entity.getLocation());
        Scheduler.runTaskLater((Plugin)ImageFrame.plugin, () -> this.removedInvisibleFrames.remove(uuid), 1L, location);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemSpawn(ItemSpawnEvent event) {
        Item item = event.getEntity();
        ItemStack itemStack = item.getItemStack();
        String type = itemStack.getType().name();
        if (!type.equals("ITEM_FRAME") && !type.equals("GLOW_ITEM_FRAME")) {
            return;
        }
        if (this.isInvisibleItemFrame(itemStack)) {
            return;
        }
        Iterator<Map.Entry<UUID, Location>> itr = this.removedInvisibleFrames.entrySet().iterator();
        while (itr.hasNext()) {
            BoundingBox boundingBox;
            Map.Entry<UUID, Location> entry = itr.next();
            Location location = entry.getValue();
            if (!location.getWorld().equals((Object)item.getWorld()) || !(boundingBox = BoundingBox.of((Location)location, (double)1.0, (double)1.0, (double)1.0)).contains(item.getLocation().toVector())) continue;
            ItemStack modified = this.withInvisibleItemFrameData(itemStack);
            item.setItemStack(modified);
            itr.remove();
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlaceItem(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!this.isInvisibleItemFrame(entity)) {
            return;
        }
        Location location = entity.getLocation();
        Scheduler.runTaskLater((Plugin)ImageFrame.plugin, () -> this.updateInvisibleItemFrame((ItemFrame)entity), 1L, location);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRemoveItem(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!this.isInvisibleItemFrame(entity)) {
            return;
        }
        Location location = entity.getLocation();
        Scheduler.runTaskLater((Plugin)ImageFrame.plugin, () -> this.updateInvisibleItemFrame((ItemFrame)entity), 1L, location);
    }

    public ItemStack splitItemStacks(ItemStack itemStack, int maxSize) {
        if (maxSize < 0) {
            return null;
        }
        int amount = itemStack.getAmount();
        if (amount <= maxSize) {
            return null;
        }
        itemStack.setAmount(maxSize);
        ItemStack splitStack = itemStack.clone();
        splitStack.setAmount(amount - maxSize);
        return splitStack;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        ThrownPotion thrownPotion = event.getEntity();
        if (thrownPotion.getEffects().stream().noneMatch(e -> e.getType().equals(PotionEffectType.INVISIBILITY))) {
            return;
        }
        int conversionsRemaining = ImageFrame.invisibleFrameMaxConversionsPerSplash;
        BoundingBox boundingBox = thrownPotion.getBoundingBox().expand(4.0, 2.0, 4.0);
        for (Entity entity : thrownPotion.getWorld().getNearbyEntities(boundingBox)) {
            Item item;
            ItemStack itemStack;
            String type;
            if (conversionsRemaining == 0) break;
            if (!(entity instanceof Item) || !(type = (itemStack = (item = (Item)entity).getItemStack()).getType().name()).equals("ITEM_FRAME") && !type.equals("GLOW_ITEM_FRAME") || this.isInvisibleItemFrame(itemStack) || !(entity.getLocation().distanceSquared(thrownPotion.getLocation()) < 16.0)) continue;
            ItemStack splitStack = this.splitItemStacks(itemStack, conversionsRemaining);
            Location location = item.getLocation();
            if (itemStack.getAmount() > 0) {
                this.itemFramesMadeInvisible.addAndGet(itemStack.getAmount());
                item.setItemStack(this.withInvisibleItemFrameData(itemStack));
                item.getWorld().playSound(item.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                item.remove();
            }
            Vector velocity = null;
            if (splitStack != null) {
                Item splitItem = thrownPotion.getWorld().dropItem(location, splitStack);
                velocity = splitItem.getVelocity();
                splitItem.setVelocity(new Vector(0, 0, 0));
            }
            if (velocity != null) {
                item.setVelocity(velocity);
            }
            if (conversionsRemaining < 0) continue;
            conversionsRemaining = Math.max(0, conversionsRemaining - itemStack.getAmount());
        }
    }

    private boolean hasInvisibilityEffect(AreaEffectCloud areaEffectCloud) {
        PotionType baseType = areaEffectCloud.getBasePotionType();
        if (baseType != null && baseType.getPotionEffects().stream().anyMatch(e -> e.getType().equals(PotionEffectType.INVISIBILITY))) {
            return true;
        }
        return areaEffectCloud.hasCustomEffect(PotionEffectType.INVISIBILITY);
    }

    private void handleAreaEffectCloud(final AreaEffectCloud areaEffectCloud) {
        final UUID uuid = areaEffectCloud.getUniqueId();
        if (!this.knownAreaEffectClouds.add(uuid)) {
            return;
        }
        final AtomicReference<Object> runnableReference = new AtomicReference<Object>(null);
        final AtomicReference<Object> taskReference = new AtomicReference<Object>(null);
        runnableReference.set(new Runnable(){
            int conversionsRemaining = ImageFrame.invisibleFrameMaxConversionsPerSplash;
            boolean firstTick = true;

            @Override
            public void run() {
                if (this.firstTick) {
                    this.firstTick = false;
                } else if (!areaEffectCloud.isValid()) {
                    ScheduledTask task = (ScheduledTask)taskReference.get();
                    if (task != null) {
                        task.cancel();
                    }
                    InvisibleFrameManager.this.knownAreaEffectClouds.remove(uuid);
                    return;
                }
                taskReference.set(Scheduler.runTaskLater((Plugin)ImageFrame.plugin, (Runnable)runnableReference.get(), 1L, areaEffectCloud.getLocation()));
                if (!InvisibleFrameManager.this.hasInvisibilityEffect(areaEffectCloud)) {
                    return;
                }
                if (areaEffectCloud.getTicksLived() % 5 != 0) {
                    return;
                }
                BoundingBox boundingBox = areaEffectCloud.getBoundingBox();
                for (Entity entity : areaEffectCloud.getWorld().getNearbyEntities(boundingBox)) {
                    Item item;
                    ItemStack itemStack;
                    String type;
                    if (this.conversionsRemaining == 0) break;
                    if (!(entity instanceof Item) || !(type = (itemStack = (item = (Item)entity).getItemStack()).getType().name()).equals("ITEM_FRAME") && !type.equals("GLOW_ITEM_FRAME") || InvisibleFrameManager.this.isInvisibleItemFrame(itemStack)) continue;
                    ItemStack splitStack = InvisibleFrameManager.this.splitItemStacks(itemStack, this.conversionsRemaining);
                    Location location = item.getLocation();
                    if (itemStack.getAmount() > 0) {
                        InvisibleFrameManager.this.itemFramesMadeInvisible.addAndGet(itemStack.getAmount());
                        item.setItemStack(InvisibleFrameManager.this.withInvisibleItemFrameData(itemStack));
                        item.getWorld().playSound(item.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    } else {
                        item.remove();
                    }
                    Vector velocity = null;
                    if (splitStack != null) {
                        Item splitItem = areaEffectCloud.getWorld().dropItem(location, splitStack);
                        velocity = splitItem.getVelocity();
                        splitItem.setVelocity(new Vector(0, 0, 0));
                    }
                    if (velocity != null) {
                        item.setVelocity(velocity);
                    }
                    if (this.conversionsRemaining < 0) continue;
                    this.conversionsRemaining = Math.max(0, this.conversionsRemaining - itemStack.getAmount());
                }
            }
        });
        ((Runnable)runnableReference.get()).run();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionLinger(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AreaEffectCloud) {
            this.handleAreaEffectCloud((AreaEffectCloud)entity);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionLinger(LingeringPotionSplashEvent event) {
        this.handleAreaEffectCloud(event.getAreaEffectCloud());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAreaEffectCloudApply(AreaEffectCloudApplyEvent event) {
        this.handleAreaEffectCloud(event.getEntity());
    }

    private /* synthetic */ void lambda$onPlace$1(Entity entity) {
        this.updateInvisibleItemFrame((ItemFrame)entity);
    }
}

