/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.libs.org.simpleyaml.configuration.file;

import com.loohp.imageframe.libs.org.simpleyaml.configuration.comments.format.CommentFormatter;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.comments.format.YamlCommentFormat;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.comments.format.YamlCommentFormatter;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.comments.format.YamlHeaderFormatter;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.file.FileConfigurationOptions;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.file.YamlConfiguration;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.implementation.api.QuoteStyle;
import com.loohp.imageframe.libs.org.simpleyaml.utils.Validate;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class YamlConfigurationOptions
extends FileConfigurationOptions {
    private int indentList = 2;
    private YamlCommentFormatter commentFormatter;
    private final QuoteStyleDefaults quoteStyleDefaults = new QuoteStyleDefaults();
    private boolean useComments = false;

    protected YamlConfigurationOptions(YamlConfiguration configuration) {
        super(configuration);
        this.headerFormatter(new YamlHeaderFormatter());
    }

    @Override
    public YamlConfiguration configuration() {
        return (YamlConfiguration)super.configuration();
    }

    @Override
    public YamlConfigurationOptions copyDefaults(boolean value) {
        super.copyDefaults(value);
        return this;
    }

    @Override
    public YamlConfigurationOptions pathSeparator(char value) {
        super.pathSeparator(value);
        return this;
    }

    @Override
    public YamlConfigurationOptions charset(Charset charset) {
        super.charset(charset);
        return this;
    }

    @Override
    public YamlConfigurationOptions header(String header) {
        super.header(header);
        return this;
    }

    @Override
    public YamlConfigurationOptions copyHeader(boolean value) {
        super.copyHeader(value);
        return this;
    }

    @Override
    public YamlConfigurationOptions headerFormatter(CommentFormatter headerFormatter) {
        Validate.isTrue(headerFormatter instanceof YamlHeaderFormatter, "The header formatter must inherit YamlHeaderFormatter");
        super.headerFormatter(headerFormatter);
        return this;
    }

    @Override
    public YamlHeaderFormatter headerFormatter() {
        return (YamlHeaderFormatter)super.headerFormatter();
    }

    @Override
    public YamlConfigurationOptions indent(int value) {
        Validate.isTrue(value >= 2, "Indent must be at least 2 characters");
        Validate.isTrue(value <= 9, "Indent cannot be greater than 9 characters");
        super.indent(value);
        return this;
    }

    public int indentList() {
        return this.indentList;
    }

    public YamlConfigurationOptions indentList(int value) {
        Validate.isTrue(value >= 0, "List indent must be at least 0 characters");
        Validate.isTrue(value <= this.indent(), "List indent cannot be greater than the indent");
        this.indentList = value;
        return this;
    }

    public YamlCommentFormatter commentFormatter() {
        if (this.commentFormatter == null) {
            this.commentFormatter = YamlCommentFormat.DEFAULT.commentFormatter();
        }
        return this.commentFormatter;
    }

    public YamlConfigurationOptions commentFormatter(YamlCommentFormatter commentFormatter) {
        this.commentFormatter = commentFormatter;
        return this;
    }

    public YamlConfigurationOptions useComments(boolean useComments) {
        this.useComments = useComments;
        return this;
    }

    public boolean useComments() {
        return this.useComments;
    }

    public QuoteStyleDefaults quoteStyleDefaults() {
        return this.quoteStyleDefaults;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof YamlConfigurationOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        YamlConfigurationOptions that = (YamlConfigurationOptions)o;
        return this.indentList == that.indentList && Objects.equals(this.commentFormatter, that.commentFormatter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.indentList, this.commentFormatter);
    }

    public static final class QuoteStyleDefaults {
        private final Map<Class<?>, QuoteStyle> typeQuoteStyles = new HashMap();
        private QuoteStyle defaultQuoteStyle = QuoteStyleDefaults.defaultQuoteStyle();

        private QuoteStyleDefaults() {
        }

        public QuoteStyle getDefaultQuoteStyle() {
            return this.defaultQuoteStyle;
        }

        public QuoteStyleDefaults setDefaultQuoteStyle(QuoteStyle defaultQuoteStyle) {
            if (defaultQuoteStyle == null) {
                defaultQuoteStyle = QuoteStyleDefaults.defaultQuoteStyle();
            }
            this.defaultQuoteStyle = defaultQuoteStyle;
            return this;
        }

        public QuoteStyleDefaults setQuoteStyle(Class<?> valueClass, QuoteStyle quoteStyle) {
            if (quoteStyle == null) {
                this.typeQuoteStyles.remove(valueClass);
            } else {
                this.typeQuoteStyles.put(valueClass, quoteStyle);
            }
            return this;
        }

        public QuoteStyle getQuoteStyle(Class<?> valueClass) {
            QuoteStyle quoteStyle = this.getExplicitQuoteStyleInstanceOf(valueClass);
            return quoteStyle != null ? quoteStyle : this.getDefaultQuoteStyle();
        }

        public Map<Class<?>, QuoteStyle> getQuoteStyles() {
            return this.typeQuoteStyles;
        }

        QuoteStyle getExplicitQuoteStyleInstanceOf(Class<?> valueClass) {
            QuoteStyle quoteStyle = this.typeQuoteStyles.get(valueClass);
            if (quoteStyle == null && valueClass != null) {
                for (Class<?> superClass : this.typeQuoteStyles.keySet()) {
                    if (!superClass.isAssignableFrom(valueClass)) continue;
                    return this.typeQuoteStyles.get(superClass);
                }
            }
            return quoteStyle;
        }

        private static QuoteStyle defaultQuoteStyle() {
            return QuoteStyle.PLAIN;
        }
    }
}

