/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.listeners;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.objectholders.CombinedMapItemHandler;
import com.loohp.imageframe.utils.ImageFilledMapUtils;
import com.loohp.imageframe.utils.MapUtils;
import com.loohp.imageframe.utils.ModernEventsUtils;
import com.loohp.imageframe.utils.SlotAccessor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class Events
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        ItemStack replacement;
        ItemStack currentItem = event.getCurrentItem();
        MapView currentMapView = MapUtils.getItemMapView(currentItem);
        if (currentMapView != null && ImageFrame.imageMapManager.isMapDeleted(currentMapView) && !ImageFrame.exemptMapIdsFromDeletion.satisfies(currentMapView.getId())) {
            event.setCurrentItem(new ItemStack(Material.MAP, currentItem.getAmount()));
        }
        if ((replacement = ImageFilledMapUtils.processImageFilledMap(event.getCurrentItem())) != null) {
            event.setCurrentItem(replacement);
        }
        boolean isClickingTop = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        boolean isClickingBottom = event.getView().getBottomInventory().equals((Object)event.getClickedInventory());
        Inventory inventory = event.getView().getTopInventory();
        switch (inventory.getType()) {
            case CRAFTING: {
                if (event.getClickedInventory() == null || !InventoryType.CRAFTING.equals((Object)event.getClickedInventory().getType()) || !(CombinedMapItemHandler.isCombinedMaps(event.getCursor()) || isClickingBottom && event.isShiftClick() && CombinedMapItemHandler.isCombinedMaps(event.getCurrentItem()) || isClickingTop && event.getHotbarButton() != -1 && CombinedMapItemHandler.isCombinedMaps(event.getWhoClicked().getInventory().getItem(event.getHotbarButton())) || isClickingTop && event.getClick().equals((Object)ClickType.SWAP_OFFHAND) && CombinedMapItemHandler.isCombinedMaps(event.getWhoClicked().getEquipment().getItemInOffHand())) && !CombinedMapItemHandler.containsCombinedMaps(i -> event.getView().getItem(i), 5)) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case WORKBENCH: {
                if (isClickingTop && CombinedMapItemHandler.isCombinedMaps(event.getCursor()) || isClickingBottom && event.isShiftClick() && CombinedMapItemHandler.isCombinedMaps(event.getCurrentItem()) || isClickingTop && event.getHotbarButton() != -1 && CombinedMapItemHandler.isCombinedMaps(event.getWhoClicked().getInventory().getItem(event.getHotbarButton())) || isClickingTop && event.getClick().equals((Object)ClickType.SWAP_OFFHAND) && CombinedMapItemHandler.isCombinedMaps(event.getWhoClicked().getEquipment().getItemInOffHand()) || CombinedMapItemHandler.containsCombinedMaps(i -> event.getView().getItem(i), 10)) {
                    event.setResult(Event.Result.DENY);
                    break;
                }
                if (event.getRawSlot() != 0) break;
                ItemStack map = event.getView().getItem(5);
                MapView mapView = MapUtils.getItemMapView(map);
                if (mapView == null) {
                    return;
                }
                if (ImageFrame.imageMapManager.getFromMapView(mapView) == null) {
                    return;
                }
                int count = 0;
                for (int i2 = 1; i2 <= 9; ++i2) {
                    ItemStack itemStack;
                    if (i2 == 5 || (itemStack = event.getView().getItem(i2)) == null || !itemStack.getType().equals((Object)Material.PAPER)) continue;
                    ++count;
                }
                if (count < 8) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case CRAFTER: {
                if (!(isClickingTop && CombinedMapItemHandler.isCombinedMaps(event.getCursor()) || isClickingBottom && event.isShiftClick() && CombinedMapItemHandler.isCombinedMaps(event.getCurrentItem()) || isClickingTop && event.getHotbarButton() != -1 && CombinedMapItemHandler.isCombinedMaps(event.getWhoClicked().getInventory().getItem(event.getHotbarButton())) || isClickingTop && event.getClick().equals((Object)ClickType.SWAP_OFFHAND) && CombinedMapItemHandler.isCombinedMaps(event.getWhoClicked().getEquipment().getItemInOffHand())) && !CombinedMapItemHandler.containsCombinedMaps(i -> event.getView().getItem(i), 9)) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case CARTOGRAPHY: {
                if (isClickingTop && CombinedMapItemHandler.isCombinedMaps(event.getCursor()) || isClickingBottom && event.isShiftClick() && CombinedMapItemHandler.isCombinedMaps(event.getCurrentItem()) || isClickingTop && event.getHotbarButton() != -1 && CombinedMapItemHandler.isCombinedMaps(event.getWhoClicked().getInventory().getItem(event.getHotbarButton())) || isClickingTop && event.getClick().equals((Object)ClickType.SWAP_OFFHAND) && CombinedMapItemHandler.isCombinedMaps(event.getWhoClicked().getEquipment().getItemInOffHand()) || CombinedMapItemHandler.containsCombinedMaps(i -> event.getView().getItem(i), 3)) {
                    event.setResult(Event.Result.DENY);
                    break;
                }
                if (event.getRawSlot() != 2) break;
                ItemStack map = event.getView().getItem(0);
                MapView mapView = MapUtils.getItemMapView(map);
                if (mapView == null) {
                    return;
                }
                if (ImageFrame.imageMapManager.getFromMapView(mapView) == null) {
                    return;
                }
                ItemStack item = event.getView().getItem(1);
                if (item == null) {
                    return;
                }
                if (!item.getType().equals((Object)Material.PAPER) && !item.getType().equals((Object)Material.GLASS_PANE)) break;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDrag(InventoryDragEvent event) {
        Inventory inventory = event.getView().getTopInventory();
        int size = inventory.getSize();
        if ((inventory.getType().equals((Object)InventoryType.WORKBENCH) || inventory.getType().equals((Object)InventoryType.CARTOGRAPHY)) && CombinedMapItemHandler.containsCombinedMaps(event.getNewItems().values()) && event.getNewItems().keySet().stream().anyMatch(i -> i < size)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerSwitchSlot(PlayerItemHeldEvent event) {
        ItemStack replacement;
        int slot;
        PlayerInventory inventory = event.getPlayer().getInventory();
        ItemStack currentItem = inventory.getItem(slot = event.getNewSlot());
        MapView currentMapView = MapUtils.getItemMapView(currentItem);
        if (currentMapView != null && ImageFrame.imageMapManager.isMapDeleted(currentMapView) && !ImageFrame.exemptMapIdsFromDeletion.satisfies(currentMapView.getId())) {
            inventory.setItem(slot, new ItemStack(Material.MAP, currentItem.getAmount()));
        }
        if ((replacement = ImageFilledMapUtils.processImageFilledMap(inventory.getItem(slot))) != null) {
            inventory.setItem(slot, replacement);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack replacement;
        if (event.getAction().equals((Object)Action.PHYSICAL)) {
            return;
        }
        EntityEquipment equipment = event.getPlayer().getEquipment();
        EquipmentSlot hand = event.getHand();
        if (hand == null) {
            return;
        }
        ItemStack currentItem = equipment.getItem(hand);
        MapView currentMapView = MapUtils.getItemMapView(currentItem);
        if (currentMapView != null && ImageFrame.imageMapManager.isMapDeleted(currentMapView) && !ImageFrame.exemptMapIdsFromDeletion.satisfies(currentMapView.getId())) {
            equipment.setItem(hand, new ItemStack(Material.MAP, currentItem.getAmount()));
        }
        if ((replacement = ImageFilledMapUtils.processImageFilledMap(equipment.getItem(hand))) != null) {
            equipment.setItem(hand, replacement);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        ItemFrame itemFrame;
        ItemStack itemStack;
        MapView mapView;
        Entity entity;
        ItemStack replacement;
        EquipmentSlot hand;
        EntityEquipment equipment = event.getPlayer().getEquipment();
        ItemStack currentItem = equipment.getItem(hand = event.getHand());
        MapView currentMapView = MapUtils.getItemMapView(currentItem);
        if (currentMapView != null && ImageFrame.imageMapManager.isMapDeleted(currentMapView) && !ImageFrame.exemptMapIdsFromDeletion.satisfies(currentMapView.getId())) {
            equipment.setItem(hand, new ItemStack(Material.MAP, currentItem.getAmount()));
        }
        if ((replacement = ImageFilledMapUtils.processImageFilledMap(equipment.getItem(hand))) != null) {
            equipment.setItem(hand, replacement);
        }
        if ((entity = event.getRightClicked()) instanceof ItemFrame && (mapView = MapUtils.getItemMapView(itemStack = (itemFrame = (ItemFrame)entity).getItem())) != null && ImageFrame.imageMapManager.isMapDeleted(mapView) && !ImageFrame.exemptMapIdsFromDeletion.satisfies(mapView.getId())) {
            itemFrame.setItem(new ItemStack(Material.MAP, itemStack.getAmount()), false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        ItemFrame itemFrame;
        ItemStack itemStack;
        MapView mapView;
        Entity entity = event.getEntity();
        if (entity instanceof ItemFrame && (mapView = MapUtils.getItemMapView(itemStack = (itemFrame = (ItemFrame)entity).getItem())) != null && ImageFrame.imageMapManager.isMapDeleted(mapView) && !ImageFrame.exemptMapIdsFromDeletion.satisfies(mapView.getId())) {
            itemFrame.setItem(new ItemStack(Material.MAP, itemStack.getAmount()), false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        ItemStack replacement;
        Item item = event.getItem();
        ItemStack currentItem = item.getItemStack();
        MapView currentMapView = MapUtils.getItemMapView(currentItem);
        if (currentMapView != null && ImageFrame.imageMapManager.isMapDeleted(currentMapView) && !ImageFrame.exemptMapIdsFromDeletion.satisfies(currentMapView.getId())) {
            item.setItemStack(new ItemStack(Material.MAP, currentItem.getAmount()));
        }
        if ((replacement = ImageFilledMapUtils.processImageFilledMap(item.getItemStack())) != null) {
            item.setItemStack(replacement);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (ModernEventsUtils.modernEventsExists()) {
            return;
        }
        Chunk chunk = event.getChunk();
        Scheduler.executeOrScheduleSync((Plugin)ImageFrame.plugin, () -> {
            for (Entity entity : chunk.getEntities()) {
                ItemFrame itemFrame;
                ItemStack itemStack;
                MapView mapView;
                if (!(entity instanceof ItemFrame) || (mapView = MapUtils.getItemMapView(itemStack = (itemFrame = (ItemFrame)entity).getItem())) == null || !ImageFrame.imageMapManager.isMapDeleted(mapView) || ImageFrame.exemptMapIdsFromDeletion.satisfies(mapView.getId())) continue;
                Scheduler.runTask((Plugin)ImageFrame.plugin, () -> itemFrame.setItem(new ItemStack(Material.MAP, itemStack.getAmount()), false), (Entity)itemFrame);
            }
        }, chunk);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        PlayerInventory inventory = event.getPlayer().getInventory();
        ImageFilledMapUtils.processImageFilledMaps(SlotAccessor.of(arg_0 -> Events.lambda$onPlayerJoin$7((Inventory)inventory, arg_0), (arg_0, arg_1) -> Events.lambda$onPlayerJoin$8((Inventory)inventory, arg_0, arg_1)), inventory.getSize());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerInventory inventory = event.getPlayer().getInventory();
        ImageFilledMapUtils.processImageFilledMaps(SlotAccessor.of(arg_0 -> Events.lambda$onPlayerQuit$9((Inventory)inventory, arg_0), (arg_0, arg_1) -> Events.lambda$onPlayerQuit$10((Inventory)inventory, arg_0, arg_1)), inventory.getSize());
    }

    private static /* synthetic */ void lambda$onPlayerQuit$10(Inventory inventory, int i, ItemStack s) {
        inventory.setItem(i, s);
    }

    private static /* synthetic */ ItemStack lambda$onPlayerQuit$9(Inventory inventory, int i) {
        return inventory.getItem(i);
    }

    private static /* synthetic */ void lambda$onPlayerJoin$8(Inventory inventory, int i, ItemStack s) {
        inventory.setItem(i, s);
    }

    private static /* synthetic */ ItemStack lambda$onPlayerJoin$7(Inventory inventory, int i) {
        return inventory.getItem(i);
    }

    public static class ModernEvents
    implements Listener {
        @EventHandler(priority=EventPriority.NORMAL)
        public void onEntityLoad(EntitiesLoadEvent event) {
            for (Entity entity : event.getEntities()) {
                ItemFrame itemFrame;
                ItemStack itemStack;
                MapView mapView;
                if (!(entity instanceof ItemFrame) || (mapView = MapUtils.getItemMapView(itemStack = (itemFrame = (ItemFrame)entity).getItem())) == null || !ImageFrame.imageMapManager.isMapDeleted(mapView) || ImageFrame.exemptMapIdsFromDeletion.satisfies(mapView.getId())) continue;
                Scheduler.runTask((Plugin)ImageFrame.plugin, () -> itemFrame.setItem(new ItemStack(Material.MAP, itemStack.getAmount()), false), (Entity)itemFrame);
            }
        }
    }
}

