/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.media;

import com.loohp.imageframe.media.MediaFrame;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TimedMediaFrameIterator
implements Iterator<BufferedImage> {
    private final Iterator<MediaFrame> backing;
    private final int stepMs;
    private MediaFrame current;
    private int elapsedInFrame = 0;
    private boolean finished = false;

    public TimedMediaFrameIterator(Iterator<MediaFrame> backing, int stepMs) {
        this.backing = backing;
        this.stepMs = stepMs;
        if (backing.hasNext()) {
            this.current = backing.next();
        } else {
            this.finished = true;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.finished;
    }

    @Override
    public BufferedImage next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        MediaFrame result = this.current;
        if (this.current.getDurationMs() == -1) {
            return result.getImage();
        }
        this.elapsedInFrame += this.stepMs;
        while (this.current.getDurationMs() != -1 && this.elapsedInFrame >= this.current.getDurationMs()) {
            this.elapsedInFrame -= this.current.getDurationMs();
            if (this.backing.hasNext()) {
                this.current = this.backing.next();
                continue;
            }
            this.finished = true;
            break;
        }
        return result.getImage();
    }
}

