/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonObject;
import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import com.loohp.imageframe.media.MediaFrame;
import com.loohp.imageframe.media.MediaLoader;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapCreateInfo;
import com.loohp.imageframe.objectholders.ImageMapLoaderPriority;
import com.loohp.imageframe.objectholders.ImageMapManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

public abstract class ImageMapLoader<T extends ImageMap, C extends ImageMapCreateInfo> {
    protected final List<MediaLoader> mediaLoaders = new CopyOnWriteArrayList<MediaLoader>();

    protected ImageMapLoader() {
    }

    public abstract Key getIdentifier();

    public String getLegacyType() {
        return null;
    }

    public abstract Class<T> getImageMapClass();

    public abstract Class<C> getImageMapCreateInfoClass();

    public abstract List<String> getExtraPermissions();

    public abstract boolean isSupported(String var1);

    public ImageMapLoaderPriority getPriority(String imageType) {
        return ImageMapLoaderPriority.NORMAL;
    }

    public void registerMediaLoaderFirst(MediaLoader mediaLoader) {
        this.mediaLoaders.add(0, mediaLoader);
    }

    public void registerMediaLoaderLast(MediaLoader mediaLoader) {
        this.mediaLoaders.add(mediaLoader);
    }

    public void registerMediaLoaderBefore(Key identifier, MediaLoader mediaLoader) {
        int index = this.indexOfMediaLoader(identifier);
        if (index < 0) {
            this.registerMediaLoaderFirst(mediaLoader);
        } else {
            this.mediaLoaders.add(index, mediaLoader);
        }
    }

    public void registerMediaLoaderAfter(Key identifier, MediaLoader mediaLoader) {
        int index = this.indexOfMediaLoader(identifier);
        if (index < 0) {
            this.registerMediaLoaderLast(mediaLoader);
        } else {
            this.mediaLoaders.add(index + 1, mediaLoader);
        }
    }

    protected int indexOfMediaLoader(Key identifier) {
        for (int i = 0; i < this.mediaLoaders.size(); ++i) {
            if (!this.mediaLoaders.get(i).getIdentifier().equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    public Iterator<MediaFrame> tryLoadMedia(String url) throws IOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (MediaLoader mediaLoader : this.mediaLoaders) {
            try {
                if (!mediaLoader.shouldTryRead(url)) continue;
                return mediaLoader.tryLoad(url);
            }
            catch (Exception e) {
                exceptions.add(new IOException("Unable to read or download media with MediaLoader " + mediaLoader.getIdentifier(), e));
            }
        }
        IOException e = new IOException("Unable to read or download media with ImageMapLoader " + this.getIdentifier().asString() + ", does this url directly links to the gif? (" + url + ")");
        for (IOException ex : exceptions) {
            e.addSuppressed(ex);
        }
        throw e;
    }

    public abstract Future<T> create(C var1) throws Exception;

    public abstract Future<T> load(ImageMapManager var1, JsonObject var2) throws Exception;
}

