/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.media.TimedMediaFrameIterator;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapLoader;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.IntPosition;
import com.loohp.imageframe.objectholders.LazyDataSource;
import com.loohp.imageframe.objectholders.LazyMappedBufferedImage;
import com.loohp.imageframe.objectholders.MapPacketSentCallback;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.objectholders.StandardLazyMappedBufferedImage;
import com.loohp.imageframe.objectholders.URLAnimatedImageMapLoader;
import com.loohp.imageframe.objectholders.URLImageMap;
import com.loohp.imageframe.objectholders.URLImageMapCreateInfo;
import com.loohp.imageframe.storage.ImageFrameStorage;
import com.loohp.imageframe.utils.CollectionUtils;
import com.loohp.imageframe.utils.MapUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class URLAnimatedImageMap
extends URLImageMap {
    protected final LazyMappedBufferedImage[][] cachedImages;
    protected byte[][][] cachedColors;
    protected int[][] fakeMapIds;
    protected Set<Integer> fakeMapIdsSet;
    protected int pausedAt;
    protected int tickOffset;

    protected URLAnimatedImageMap(ImageMapManager manager, ImageMapLoader<?, ?> loader, int imageIndex, String name, String url, LazyMappedBufferedImage[][] cachedImages, List<MapView> mapViews, List<Integer> mapIds, List<Map<String, MapCursor>> mapMarkers, int width, int height, DitheringType ditheringType, UUID creator, Map<UUID, ImageMapAccessPermissionType> hasAccess, long creationTime, int pausedAt, int tickOffset) {
        super(manager, loader, imageIndex, name, url, mapViews, mapIds, mapMarkers, width, height, ditheringType, creator, hasAccess, creationTime);
        this.cachedImages = cachedImages;
        this.pausedAt = pausedAt;
        this.tickOffset = tickOffset;
        this.cacheControlTask.loadCacheIfManual();
    }

    @Override
    public void loadColorCache() {
        if (this.cachedImages == null) {
            return;
        }
        if (this.cachedImages[0] == null) {
            return;
        }
        byte[][][] cachedColors = new byte[this.cachedImages.length][][];
        int[][] fakeMapIds = new int[cachedColors.length][];
        HashSet<Integer> fakeMapIdsSet = new HashSet<Integer>();
        BufferedImage[] combined = new BufferedImage[this.cachedImages[0].length];
        for (int i3 = 0; i3 < combined.length; ++i3) {
            combined[i3] = new BufferedImage(this.width * 128, this.height * 128, 2);
        }
        Graphics2D[] g = (Graphics2D[])Arrays.stream(combined).map(i -> i.createGraphics()).toArray(Graphics2D[]::new);
        int index = 0;
        for (LazyMappedBufferedImage[] lazyMappedBufferedImageArray : this.cachedImages) {
            int f = 0;
            for (LazyMappedBufferedImage image : lazyMappedBufferedImageArray) {
                g[f++].drawImage(image.get(), index % this.width * 128, index / this.width * 128, 128, 128, null);
            }
            ++index;
        }
        for (LazyMappedBufferedImage[] lazyMappedBufferedImageArray : g) {
            lazyMappedBufferedImageArray.dispose();
        }
        byte[][] combinedData = new byte[combined.length][];
        for (int i2 = 0; i2 < combined.length; ++i2) {
            combinedData[i2] = MapUtils.toMapPaletteBytes(combined[i2], this.ditheringType);
        }
        int i2 = 0;
        for (LazyMappedBufferedImage[] images : this.cachedImages) {
            byte[][] data = new byte[images.length][];
            int[] mapIds = new int[data.length];
            Arrays.fill(mapIds, -1);
            byte[] lastDistinctFrame = null;
            for (int u = 0; u < images.length; ++u) {
                int mapId;
                byte[] b = new byte[16384];
                for (int y = 0; y < 128; ++y) {
                    int offset = (i2 / this.width * 128 + y) * (this.width * 128) + i2 % this.width * 128;
                    System.arraycopy(combinedData[u], offset, b, y * 128, 128);
                }
                if (u != 0 && Arrays.equals(b, lastDistinctFrame)) continue;
                data[u] = b;
                mapIds[u] = mapId = ImageMapManager.getNextFakeMapId();
                fakeMapIdsSet.add(mapId);
                lastDistinctFrame = b;
            }
            cachedColors[i2] = data;
            fakeMapIds[i2] = mapIds;
            ++i2;
        }
        this.cachedColors = cachedColors;
        this.fakeMapIds = fakeMapIds;
        this.fakeMapIdsSet = fakeMapIdsSet;
    }

    @Override
    public boolean applyUpdate(JsonObject json) {
        this.pausedAt = json.get("pausedAt").getAsInt();
        this.tickOffset = json.get("tickOffset").getAsInt();
        return super.applyUpdate(json);
    }

    @Override
    public boolean hasColorCached() {
        return this.cachedColors != null;
    }

    @Override
    public void unloadColorCache() {
        this.cachedColors = null;
    }

    @Override
    public void update(boolean save) throws Exception {
        List<BufferedImage> images = CollectionUtils.toList(new TimedMediaFrameIterator(this.loader.tryLoadMedia(this.url), 50));
        for (int i = 0; i < this.cachedImages.length; ++i) {
            this.cachedImages[i] = new LazyMappedBufferedImage[images.size()];
        }
        int index = 0;
        HashMap<IntPosition, StandardLazyMappedBufferedImage> previousImages = new HashMap<IntPosition, StandardLazyMappedBufferedImage>();
        for (BufferedImage image : images) {
            image = MapUtils.resize(image, this.width, this.height);
            int i = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    IntPosition intPosition = new IntPosition(x, y);
                    BufferedImage subImage = MapUtils.getSubImage(image, x, y);
                    LazyMappedBufferedImage previousFile = (LazyMappedBufferedImage)previousImages.get(intPosition);
                    LazyMappedBufferedImage file = previousFile == null || !MapUtils.areImagesEqual(subImage, previousFile.getIfLoaded()) ? StandardLazyMappedBufferedImage.fromImage(subImage) : previousFile;
                    this.cachedImages[i++][index] = file;
                    previousImages.put(intPosition, (StandardLazyMappedBufferedImage)file);
                }
            }
            ++index;
        }
        this.reloadColorCache();
        Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(this));
        if (save) {
            this.save();
        }
    }

    @Override
    public boolean requiresAnimationService() {
        return true;
    }

    @Override
    public int getCurrentPositionInSequenceWithOffset() {
        if (this.isAnimationPaused()) {
            return this.pausedAt;
        }
        int sequenceLength = this.getSequenceLength();
        int currentPosition = (int)(this.manager.getCurrentAnimationTick() % (long)sequenceLength) - this.tickOffset;
        if (currentPosition < 0) {
            currentPosition = sequenceLength + currentPosition;
        }
        return currentPosition;
    }

    @Override
    public boolean isAnimationPaused() {
        return this.pausedAt >= 0;
    }

    @Override
    public synchronized void setAnimationPause(boolean pause) throws Exception {
        if (this.pausedAt < 0 && pause) {
            this.pausedAt = this.getCurrentPositionInSequenceWithOffset();
            this.save();
        } else if (this.pausedAt >= 0 && !pause) {
            this.setCurrentPositionInSequence(this.pausedAt);
            this.pausedAt = -1;
            this.save();
        }
    }

    @Override
    public void setCurrentPositionInSequence(int position) {
        int sequenceLength = this.getSequenceLength();
        this.tickOffset = (int)(this.manager.getCurrentAnimationTick() % (long)sequenceLength) - position % sequenceLength;
    }

    @Override
    public synchronized void setAnimationPlaybackTime(double seconds) throws Exception {
        int totalTicks = this.getSequenceLength();
        int ticks = seconds < 0.0 ? totalTicks + (int)Math.ceil((seconds + 1.0) * 20.0) : (int)Math.floor(seconds * 20.0);
        ticks = Math.min(Math.max(0, ticks), totalTicks - 1);
        if (this.isAnimationPaused()) {
            this.pausedAt = ticks;
            this.save();
        } else {
            this.setCurrentPositionInSequence(ticks);
            this.save();
        }
    }

    @Override
    public byte[] getRawAnimationColors(int currentTick, int index) {
        if (this.cachedColors == null) {
            return null;
        }
        byte[][] colors = this.cachedColors[index];
        if (colors == null) {
            return null;
        }
        return colors[currentTick % colors.length];
    }

    @Override
    public int getAnimationFakeMapId(int currentTick, int index, boolean lookbehind) {
        if (this.fakeMapIds == null) {
            return -1;
        }
        int[] mapIds = this.fakeMapIds[index];
        if (mapIds == null) {
            return -1;
        }
        int mapIdIndex = currentTick % mapIds.length;
        int mapId = mapIds[mapIdIndex];
        if (mapId >= 0 || !lookbehind) {
            return mapId;
        }
        while (mapIdIndex >= 0) {
            mapId = mapIds[mapIdIndex];
            if (mapId >= 0) {
                return mapId;
            }
            --mapIdIndex;
        }
        return mapId;
    }

    @Override
    public void sendAnimationFakeMaps(Collection<? extends Player> players, MapPacketSentCallback completionCallback) {
        int length = this.getSequenceLength();
        for (int currentTick = 0; currentTick < length; ++currentTick) {
            for (int index = 0; index < this.fakeMapIds.length; ++index) {
                int mapId;
                int[] mapIds = this.fakeMapIds[index];
                if (mapIds == null || currentTick >= mapIds.length || (mapId = mapIds[currentTick]) < 0) continue;
                MapUtils.sendImageMap(mapId, (MapView)this.mapViews.get(index), currentTick, players, completionCallback);
            }
        }
    }

    @Override
    public Set<Integer> getFakeMapIds() {
        return this.fakeMapIdsSet;
    }

    @Override
    public MapView getMapViewFromMapId(int mapId) {
        MapView mapView = super.getMapViewFromMapId(mapId);
        if (mapView != null) {
            return mapView;
        }
        if (!this.fakeMapIdsSet.contains(mapId)) {
            return null;
        }
        for (int i = 0; i < this.fakeMapIds.length; ++i) {
            int[] ids = this.fakeMapIds[i];
            if (ids == null || !Arrays.stream(ids).anyMatch(id -> id == mapId)) continue;
            return (MapView)this.mapViews.get(i);
        }
        return null;
    }

    @Override
    public int getSequenceLength() {
        return this.cachedImages[0].length;
    }

    @Override
    public ImageMap deepClone(String name, UUID creator) throws Exception {
        URLAnimatedImageMap imageMap = ((URLAnimatedImageMapLoader)this.loader).create(new URLImageMapCreateInfo(this.manager, name, this.url, this.width, this.height, this.ditheringType, creator)).get();
        List<Map<String, MapCursor>> newList = imageMap.getMapMarkers();
        int i = 0;
        for (Map<String, MapCursor> map : this.getMapMarkers()) {
            Map<String, MapCursor> newMap = newList.get(i++);
            for (Map.Entry<String, MapCursor> entry : map.entrySet()) {
                MapCursor mapCursor = entry.getValue();
                newMap.put(entry.getKey(), new MapCursor(mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), mapCursor.getType(), mapCursor.isVisible(), mapCursor.getCaption()));
            }
        }
        return imageMap;
    }

    @Override
    public void save(ImageFrameStorage storage, boolean saveAsCopy) throws Exception {
        if (this.imageIndex < 0) {
            throw new IllegalStateException("ImageMap with index < 0 cannot be saved");
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", this.loader.getIdentifier().asString());
        json.addProperty("index", this.imageIndex);
        json.addProperty("name", this.name);
        json.addProperty("url", this.url);
        json.addProperty("width", this.width);
        json.addProperty("height", this.height);
        if (this.ditheringType != null) {
            json.addProperty("ditheringType", this.ditheringType.getName());
        }
        json.addProperty("creator", this.creator.toString());
        json.addProperty("pausedAt", this.pausedAt);
        json.addProperty("tickOffset", this.tickOffset);
        JsonObject accessJson = new JsonObject();
        for (Map.Entry<UUID, ImageMapAccessPermissionType> entry : this.accessControl.getPermissions().entrySet()) {
            accessJson.addProperty(entry.getKey().toString(), entry.getValue().name());
        }
        json.add("hasAccess", accessJson);
        json.addProperty("creationTime", this.creationTime);
        JsonArray mapDataJson = new JsonArray();
        int u = 0;
        for (int i = 0; i < this.mapViews.size(); ++i) {
            JsonObject dataJson = new JsonObject();
            dataJson.addProperty("mapid", (Number)this.mapIds.get(i));
            JsonArray framesArray = new JsonArray();
            for (LazyMappedBufferedImage image : this.cachedImages[i]) {
                int index;
                LazyDataSource source;
                if (image.canSetSource(source = storage.getSource(this.imageIndex, (index = u++) + ".png"))) {
                    if (saveAsCopy) {
                        image.saveCopy(source);
                    } else {
                        image.setSource(source);
                    }
                    framesArray.add(index + ".png");
                    continue;
                }
                String fileName = image.getSource().getFileName();
                if (saveAsCopy) {
                    image.saveCopy(source.withFileName(fileName));
                }
                framesArray.add(fileName);
            }
            dataJson.add("images", framesArray);
            JsonArray markerArray = new JsonArray();
            for (Map.Entry entry : ((Map)this.mapMarkers.get(i)).entrySet()) {
                MapCursor marker = (MapCursor)entry.getValue();
                JsonObject markerData = new JsonObject();
                markerData.addProperty("name", (String)entry.getKey());
                markerData.addProperty("x", marker.getX());
                markerData.addProperty("y", marker.getY());
                markerData.addProperty("type", marker.getType().name());
                markerData.addProperty("direction", marker.getDirection());
                markerData.addProperty("visible", marker.isVisible());
                markerData.addProperty("caption", marker.getCaption());
                markerArray.add(markerData);
            }
            dataJson.add("markers", markerArray);
            mapDataJson.add(dataJson);
        }
        json.add("mapdata", mapDataJson);
        storage.saveImageMapData(this.imageIndex, json);
    }

    public static class URLAnimatedImageMapRenderer
    extends ImageMap.ImageMapRenderer {
        private final URLAnimatedImageMap parent;

        public URLAnimatedImageMapRenderer(URLAnimatedImageMap parent, int index) {
            super(parent.getManager(), parent, index);
            this.parent = parent;
        }

        @Override
        public MutablePair<byte[], Collection<MapCursor>> renderMap(MapView mapView, int currentTick, Player player) {
            byte[] colors = this.parent.getRawAnimationColors(currentTick, this.index);
            Collection<MapCursor> cursors = this.parent.getMapMarkers().get(this.index).values();
            return new MutablePair<byte[], Collection<MapCursor>>(colors, cursors);
        }

        @Override
        public MutablePair<byte[], Collection<MapCursor>> renderMap(MapView mapView, Player player) {
            return this.renderMap(mapView, this.parent.getCurrentPositionInSequenceWithOffset(), player);
        }
    }
}

