/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.api.events;

import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.map.MapView;

public class HDMapPreRespondEvent
extends Event {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Player player;
    private final int mapId;
    private final ImageMap imageMap;
    private final MapView mapView;
    private boolean requestAccepted;
    private BufferedImage image;

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public HDMapPreRespondEvent(Player player, int mapId, ImageMap imageMap, MapView mapView, boolean requestAccepted, BufferedImage image) {
        super(!Scheduler.isPrimaryThread());
        this.player = player;
        this.mapId = mapId;
        this.imageMap = imageMap;
        this.mapView = mapView;
        this.requestAccepted = requestAccepted;
        this.image = image;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getMapId() {
        return this.mapId;
    }

    public ImageMap getImageMap() {
        return this.imageMap;
    }

    public MapView getMapView() {
        return this.mapView;
    }

    public boolean isRequestAccepted() {
        return this.requestAccepted;
    }

    public void setRequestAccepted(boolean requestAccepted) {
        this.requestAccepted = requestAccepted;
    }

    public BufferedImage getImage() {
        return this.image == null ? null : ImageUtils.copy(this.image);
    }

    public void setImage(BufferedImage image) {
        this.image = image == null ? null : ImageUtils.copy(image);
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }
}

