/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.libs.com.loohp.platformscheduler.platform.folia;

import com.loohp.imageframe.libs.com.loohp.platformscheduler.platform.PlatformScheduler;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.platform.folia.FoliaScheduledTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements PlatformScheduler {
    @Override
    public boolean isPrimaryThread() {
        return Bukkit.isPrimaryThread();
    }

    @Override
    public boolean isGlobalTickThread() {
        return Bukkit.isGlobalTickThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(Entity entity) {
        return Bukkit.isOwnedByCurrentRegion((Entity)entity);
    }

    @Override
    public boolean isOwnedByCurrentRegion(Location location) {
        return Bukkit.isOwnedByCurrentRegion((Location)location);
    }

    @Override
    public boolean isOwnedByCurrentRegion(Chunk chunk) {
        return this.isOwnedByCurrentRegion(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    @Override
    public boolean isOwnedByCurrentRegion(World world, int chunkX, int chunkZ) {
        return Bukkit.isOwnedByCurrentRegion((World)world, (int)chunkX, (int)chunkZ);
    }

    @Override
    public boolean isOwnedByCurrentRegion(Location location, int squareRadiusChunks) {
        return Bukkit.isOwnedByCurrentRegion((Location)location, (int)squareRadiusChunks);
    }

    @Override
    public boolean isOwnedByCurrentRegion(Chunk chunk, int squareRadiusChunks) {
        return this.isOwnedByCurrentRegion(chunk.getWorld(), chunk.getX(), chunk.getZ(), squareRadiusChunks);
    }

    @Override
    public boolean isOwnedByCurrentRegion(World world, int chunkX, int chunkZ, int squareRadiusChunks) {
        return Bukkit.isOwnedByCurrentRegion((World)world, (int)chunkX, (int)chunkZ, (int)squareRadiusChunks);
    }

    @Override
    public void executeOrScheduleSync(Plugin plugin, Runnable task) {
        if (this.isGlobalTickThread()) {
            task.run();
        } else {
            Bukkit.getGlobalRegionScheduler().run(plugin, st -> task.run());
        }
    }

    @Override
    public void executeOrScheduleSync(Plugin plugin, Runnable task, Entity entity) {
        this.executeOrScheduleSync(plugin, task, null, entity);
    }

    @Override
    public void executeOrScheduleSync(Plugin plugin, Runnable task, Runnable retired, Entity entity) {
        if (this.isOwnedByCurrentRegion(entity)) {
            task.run();
        } else {
            entity.getScheduler().run(plugin, st -> task.run(), retired);
        }
    }

    @Override
    public void executeOrScheduleSync(Plugin plugin, Runnable task, Location location) {
        if (this.isOwnedByCurrentRegion(location)) {
            task.run();
        } else {
            Bukkit.getRegionScheduler().execute(plugin, location, task);
        }
    }

    @Override
    public void executeOrScheduleSync(Plugin plugin, Runnable task, Chunk chunk) {
        this.executeOrScheduleSync(plugin, task, chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    @Override
    public void executeOrScheduleSync(Plugin plugin, Runnable task, World world, int chunkX, int chunkZ) {
        if (this.isOwnedByCurrentRegion(world, chunkX, chunkZ)) {
            task.run();
        } else {
            Bukkit.getRegionScheduler().execute(plugin, world, chunkX, chunkZ, task);
        }
    }

    public FoliaScheduledTask runTask(Plugin plugin, Runnable task, Entity entity) {
        return this.runTask(plugin, task, null, entity);
    }

    public FoliaScheduledTask runTaskLater(Plugin plugin, Runnable task, long delay, Entity entity) {
        return this.runTaskLater(plugin, task, null, delay, entity);
    }

    public FoliaScheduledTask runTaskTimer(Plugin plugin, Runnable task, long delay, long period, Entity entity) {
        return this.runTaskTimer(plugin, task, null, delay, period, entity);
    }

    public FoliaScheduledTask runTask(Plugin plugin, Runnable task, Runnable retired, Entity entity) {
        return new FoliaScheduledTask(entity.getScheduler().run(plugin, st -> task.run(), retired));
    }

    public FoliaScheduledTask runTaskLater(Plugin plugin, Runnable task, Runnable retired, long delay, Entity entity) {
        return new FoliaScheduledTask(entity.getScheduler().runDelayed(plugin, st -> task.run(), retired, delay));
    }

    public FoliaScheduledTask runTaskTimer(Plugin plugin, Runnable task, Runnable retired, long delay, long period, Entity entity) {
        return new FoliaScheduledTask(entity.getScheduler().runAtFixedRate(plugin, st -> task.run(), retired, Math.max(1L, delay), period));
    }

    public FoliaScheduledTask runTask(Plugin plugin, Runnable task, Location location) {
        return new FoliaScheduledTask(Bukkit.getRegionScheduler().run(plugin, location, st -> task.run()));
    }

    public FoliaScheduledTask runTaskLater(Plugin plugin, Runnable task, long delay, Location location) {
        return new FoliaScheduledTask(Bukkit.getRegionScheduler().runDelayed(plugin, location, st -> task.run(), delay));
    }

    public FoliaScheduledTask runTaskTimer(Plugin plugin, Runnable task, long delay, long period, Location location) {
        return new FoliaScheduledTask(Bukkit.getRegionScheduler().runAtFixedRate(plugin, location, st -> task.run(), Math.max(1L, delay), period));
    }

    public FoliaScheduledTask runTask(Plugin plugin, Runnable task, Chunk chunk) {
        return this.runTask(plugin, task, chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public FoliaScheduledTask runTaskLater(Plugin plugin, Runnable task, long delay, Chunk chunk) {
        return this.runTaskLater(plugin, task, delay, chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public FoliaScheduledTask runTaskTimer(Plugin plugin, Runnable task, long delay, long period, Chunk chunk) {
        return this.runTaskTimer(plugin, task, delay, period, chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public FoliaScheduledTask runTask(Plugin plugin, Runnable task, World world, int chunkX, int chunkZ) {
        return new FoliaScheduledTask(Bukkit.getRegionScheduler().run(plugin, world, chunkX, chunkZ, st -> task.run()));
    }

    public FoliaScheduledTask runTaskLater(Plugin plugin, Runnable task, long delay, World world, int chunkX, int chunkZ) {
        return new FoliaScheduledTask(Bukkit.getRegionScheduler().runDelayed(plugin, world, chunkX, chunkZ, st -> task.run(), delay));
    }

    public FoliaScheduledTask runTaskTimer(Plugin plugin, Runnable task, long delay, long period, World world, int chunkX, int chunkZ) {
        return new FoliaScheduledTask(Bukkit.getRegionScheduler().runAtFixedRate(plugin, world, chunkX, chunkZ, st -> task.run(), Math.max(1L, delay), period));
    }

    public FoliaScheduledTask runTask(Plugin plugin, Runnable task) {
        return new FoliaScheduledTask(Bukkit.getGlobalRegionScheduler().run(plugin, st -> task.run()));
    }

    public FoliaScheduledTask runTaskLater(Plugin plugin, Runnable task, long delay) {
        return new FoliaScheduledTask(Bukkit.getGlobalRegionScheduler().runDelayed(plugin, st -> task.run(), delay));
    }

    public FoliaScheduledTask runTaskTimer(Plugin plugin, Runnable task, long delay, long period) {
        return new FoliaScheduledTask(Bukkit.getGlobalRegionScheduler().runAtFixedRate(plugin, st -> task.run(), Math.max(1L, delay), period));
    }

    public FoliaScheduledTask runTaskAsynchronously(Plugin plugin, Runnable task) {
        return new FoliaScheduledTask(Bukkit.getAsyncScheduler().runNow(plugin, st -> task.run()));
    }

    public FoliaScheduledTask runTaskLaterAsynchronously(Plugin plugin, Runnable task, long delay) {
        return new FoliaScheduledTask(Bukkit.getAsyncScheduler().runDelayed(plugin, st -> task.run(), delay * 50L, TimeUnit.MILLISECONDS));
    }

    public FoliaScheduledTask runTaskTimerAsynchronously(Plugin plugin, Runnable task, long delay, long period) {
        return new FoliaScheduledTask(Bukkit.getAsyncScheduler().runAtFixedRate(plugin, st -> task.run(), Math.max(1L, delay * 50L), period * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> task, Entity entity) {
        return this.callSyncMethod(plugin, task, task, entity);
    }

    @Override
    public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> task, Callable<T> retired, Entity entity) {
        CompletableFuture future = new CompletableFuture();
        Runnable runnable = FoliaScheduler.toFuture(future, task);
        Runnable runnableRetired = FoliaScheduler.toFuture(future, retired);
        entity.getScheduler().run(plugin, st -> runnable.run(), runnableRetired);
        return future;
    }

    @Override
    public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> task, Location location) {
        CompletableFuture future = new CompletableFuture();
        Runnable runnable = FoliaScheduler.toFuture(future, task);
        Bukkit.getRegionScheduler().run(plugin, location, st -> runnable.run());
        return future;
    }

    @Override
    public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> task, Chunk chunk) {
        return this.callSyncMethod(plugin, task, chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    @Override
    public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> task, World world, int chunkX, int chunkZ) {
        CompletableFuture future = new CompletableFuture();
        Runnable runnable = FoliaScheduler.toFuture(future, task);
        Bukkit.getRegionScheduler().run(plugin, world, chunkX, chunkZ, st -> runnable.run());
        return future;
    }

    @Override
    public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> task) {
        CompletableFuture future = new CompletableFuture();
        Runnable runnable = FoliaScheduler.toFuture(future, task);
        Bukkit.getGlobalRegionScheduler().run(plugin, st -> runnable.run());
        return future;
    }

    private static <T> Runnable toFuture(CompletableFuture<T> future, Callable<T> task) {
        return () -> {
            try {
                future.complete(task.call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
    }
}

