/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils.dithering;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.bukkit.map.MapPalette;

public class FloydSteinbergDithering {
    private static final C3[] PALETTE;

    private static C3 findClosestPaletteColor(C3 c) {
        C3 closest = PALETTE[0];
        for (C3 n : PALETTE) {
            if (n.diff(c) >= closest.diff(c)) continue;
            closest = n;
        }
        return closest;
    }

    private static int clampColor(int c) {
        return Math.max(0, Math.min(255, c));
    }

    public static byte[] floydSteinbergDithering(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        C3[][] d = new C3[h][w];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                d[y][x] = new C3(new Color(img.getRGB(x, y), true));
            }
        }
        byte[] result = new byte[w * h];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                C3 oldColor = d[y][x];
                if (oldColor.isTransparent()) {
                    result[y * w + x] = 0;
                    continue;
                }
                C3 newColor = FloydSteinbergDithering.findClosestPaletteColor(oldColor);
                result[y * w + x] = MapPalette.matchColor((int)FloydSteinbergDithering.clampColor(newColor.r), (int)FloydSteinbergDithering.clampColor(newColor.g), (int)FloydSteinbergDithering.clampColor(newColor.b));
                C3 err = oldColor.sub(newColor);
                if (x + 1 < w) {
                    d[y][x + 1] = d[y][x + 1].add(err.mul(0.4375));
                }
                if (x - 1 >= 0 && y + 1 < h) {
                    d[y + 1][x - 1] = d[y + 1][x - 1].add(err.mul(0.1875));
                }
                if (y + 1 < h) {
                    d[y + 1][x] = d[y + 1][x].add(err.mul(0.3125));
                }
                if (x + 1 >= w || y + 1 >= h) continue;
                d[y + 1][x + 1] = d[y + 1][x + 1].add(err.mul(0.0625));
            }
        }
        return result;
    }

    static {
        LinkedHashSet<Byte> bytes = new LinkedHashSet<Byte>();
        for (int i = 0; i < 0x1000000; ++i) {
            bytes.add(MapPalette.matchColor((Color)new Color(i)));
        }
        LinkedHashSet<C3> values = new LinkedHashSet<C3>();
        Iterator iterator = bytes.iterator();
        while (iterator.hasNext()) {
            byte b = (Byte)iterator.next();
            values.add(new C3(MapPalette.getColor((byte)b)));
        }
        PALETTE = values.toArray(new C3[0]);
    }

    static class C3 {
        private final int r;
        private final int g;
        private final int b;
        private final boolean transparent;

        public C3(Color color) {
            this(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() < 128);
        }

        public C3(int r, int g, int b) {
            this(r, g, b, false);
        }

        public C3(int r, int g, int b, boolean transparent) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.transparent = transparent;
        }

        public C3 add(C3 o) {
            return new C3(this.r + o.r, this.g + o.g, this.b + o.b, this.transparent);
        }

        public int diff(C3 o) {
            int rDiff = o.r - this.r;
            int gDiff = o.g - this.g;
            int bDiff = o.b - this.b;
            return rDiff * rDiff + gDiff * gDiff + bDiff * bDiff;
        }

        public C3 mul(double d) {
            return new C3((int)(d * (double)this.r), (int)(d * (double)this.g), (int)(d * (double)this.b), this.transparent);
        }

        public C3 sub(C3 o) {
            return new C3(this.r - o.r, this.g - o.g, this.b - o.b, this.transparent);
        }

        public boolean isTransparent() {
            return this.transparent;
        }
    }
}

