/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.libs.org.simpleyaml.configuration.file;

import com.loohp.imageframe.libs.org.simpleyaml.configuration.Configuration;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.LoadableConfiguration;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.MemoryConfiguration;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.comments.format.CommentFormatter;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.file.FileConfigurationOptions;
import com.loohp.imageframe.libs.org.simpleyaml.exceptions.InvalidConfigurationException;
import com.loohp.imageframe.libs.org.simpleyaml.utils.Validate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public abstract class FileConfiguration
extends MemoryConfiguration
implements LoadableConfiguration {
    public FileConfiguration() {
    }

    public FileConfiguration(Configuration defaults) {
        super(defaults);
    }

    public void save(File file) throws IOException {
        Validate.notNull(file, "File cannot be null");
        File parents = file.getParentFile();
        if (parents != null && !parents.exists() && !parents.mkdirs()) {
            throw new IOException("Cannot create successfully all needed parent directories!");
        }
        this.save(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), this.options().charset()));
    }

    public void save(String file) throws IOException {
        Validate.notNull(file, "File cannot be null");
        this.save(new File(file));
    }

    @Override
    public void save(Writer writer) throws IOException {
        Validate.notNull(writer, "Writer cannot be null");
        try {
            writer.write(this.saveToString());
        }
        finally {
            writer.close();
        }
    }

    public void load(String file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        Validate.notNull(file, "File cannot be null");
        this.load(new File(file));
    }

    public void load(File file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        Validate.notNull(file, "File cannot be null");
        this.load(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public void load(InputStream stream) throws IOException, InvalidConfigurationException {
        Validate.notNull(stream, "Stream cannot be null");
        this.load(new InputStreamReader(stream, this.options().charset()));
    }

    @Override
    public void load(Reader reader) throws IOException, InvalidConfigurationException {
        Validate.notNull(reader, "Reader cannot be null");
        try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
            this.loadFromString(builder.toString());
        }
    }

    @Override
    public FileConfigurationOptions options() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }

    public String buildHeader() {
        FileConfiguration defaults;
        String defaultsHeader;
        FileConfigurationOptions options = this.options();
        if (!options.copyHeader()) {
            return "";
        }
        Configuration def = this.getDefaults();
        if (def instanceof FileConfiguration && (defaultsHeader = (defaults = (FileConfiguration)def).buildHeader()) != null && !defaultsHeader.isEmpty()) {
            return defaultsHeader;
        }
        String header = options.header();
        CommentFormatter headerFormatter = options.headerFormatter();
        if (headerFormatter != null) {
            String headerDump = headerFormatter.dump(header);
            return headerDump != null ? headerDump : "";
        }
        return header != null && !header.isEmpty() ? header + '\n' : "";
    }
}

