/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.imageio.ImageIO;

public class FileLazyMappedBufferedImage {
    private File file;
    private BufferedImage strongReference;
    private WeakReference<BufferedImage> weakReference;

    public static FileLazyMappedBufferedImage fromFile(File file) {
        return new FileLazyMappedBufferedImage(file, null, null);
    }

    public static FileLazyMappedBufferedImage fromImage(BufferedImage image) {
        return new FileLazyMappedBufferedImage(null, image, null);
    }

    public static FileLazyMappedBufferedImage fromImageToFile(File file, BufferedImage image) throws IOException {
        ImageIO.write((RenderedImage)image, "png", file);
        return new FileLazyMappedBufferedImage(file, null, new WeakReference<BufferedImage>(image));
    }

    private FileLazyMappedBufferedImage(File file, BufferedImage strongReference, WeakReference<BufferedImage> weakReference) {
        if (file == null && strongReference == null) {
            throw new IllegalArgumentException("One of file and strongReference must not be null");
        }
        if (file != null && strongReference != null) {
            throw new IllegalArgumentException("File and strongReference cannot both be not null");
        }
        this.file = file;
        this.strongReference = strongReference;
        this.weakReference = weakReference;
    }

    public File getFile() {
        return this.file;
    }

    public boolean canSetFile(File file) {
        if (this.file != null) {
            return this.file.equals(file);
        }
        return file != null;
    }

    public synchronized void setFile(File file) {
        if (this.file != null) {
            if (this.file.equals(file)) {
                return;
            }
            throw new IllegalStateException("Cannot change file location");
        }
        if (file == null) {
            throw new IllegalArgumentException("Cannot set file to null");
        }
        try {
            ImageIO.write((RenderedImage)this.strongReference, "png", file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.file = file;
        this.weakReference = new WeakReference<BufferedImage>(this.strongReference);
        this.strongReference = null;
    }

    public synchronized BufferedImage get() {
        BufferedImage image;
        if (this.strongReference != null) {
            return this.strongReference;
        }
        if (this.weakReference != null && (image = (BufferedImage)this.weakReference.get()) != null) {
            return image;
        }
        try {
            image = ImageIO.read(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.weakReference = new WeakReference<BufferedImage>(image);
        return image;
    }

    public synchronized BufferedImage getIfLoaded() {
        if (this.strongReference != null) {
            return this.strongReference;
        }
        return (BufferedImage)this.weakReference.get();
    }
}

