/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.polar;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.hollowcube.polar.ChunkSelector;
import net.hollowcube.polar.PolarLoader;
import net.hollowcube.polar.PolarWorld;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.anvil.AnvilLoader;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.NotNull;

public class AnvilPolar {
    @NotNull
    public static PolarWorld anvilToPolar(@NotNull Path path) throws IOException {
        return AnvilPolar.anvilToPolar(path, -4, 19, ChunkSelector.all());
    }

    @NotNull
    public static PolarWorld anvilToPolar(@NotNull Path path, @NotNull ChunkSelector selector) throws IOException {
        return AnvilPolar.anvilToPolar(path, -4, 19, selector);
    }

    @NotNull
    public static PolarWorld anvilToPolar(@NotNull Path path, int minSection, int maxSection) throws IOException {
        return AnvilPolar.anvilToPolar(path, minSection, maxSection, ChunkSelector.all());
    }

    @NotNull
    public static PolarWorld anvilToPolar(@NotNull Path path, int minSection, int maxSection, @NotNull ChunkSelector selector) throws IOException {
        InstanceContainer instance = new InstanceContainer(UUID.randomUUID(), DimensionType.OVERWORLD);
        AnvilLoader anvilLoader = new AnvilLoader(path);
        ArrayList<Chunk> anvilChunks = new ArrayList<Chunk>();
        try (Stream<Path> files = Files.walk(path.resolve("region"), 1, new FileVisitOption[0]);){
            for (Path regionFile : files.toList()) {
                if (!regionFile.getFileName().toString().endsWith(".mca")) continue;
                String[] nameParts = regionFile.getFileName().toString().split("\\.");
                int regionX = Integer.parseInt(nameParts[1]);
                int regionZ = Integer.parseInt(nameParts[2]);
                anvilChunks.addAll(AnvilPolar.readAnvilChunks(instance, anvilLoader, regionX, regionZ, minSection, maxSection, selector));
            }
        }
        PolarWorld world = new PolarWorld(7, 4556, PolarWorld.DEFAULT_COMPRESSION, (byte)minSection, (byte)maxSection, new byte[0], List.of());
        PolarLoader polarLoader = new PolarLoader(world);
        polarLoader.saveChunks(anvilChunks);
        return world;
    }

    @NotNull
    private static List<Chunk> readAnvilChunks(@NotNull Instance instance, @NotNull AnvilLoader anvilLoader, int regionX, int regionZ, int minSection, int maxSection, @NotNull ChunkSelector selector) throws IOException {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                Chunk chunk;
                int chunkX = x + regionX * 32;
                int chunkZ = z + regionZ * 32;
                if (!selector.test(chunkX, chunkZ) || (chunk = anvilLoader.loadChunk(instance, chunkX, chunkZ)) == null) continue;
                chunks.add(chunk);
            }
        }
        return chunks;
    }
}

