/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.polar;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.hollowcube.polar.PolarChunk;
import net.hollowcube.polar.PolarDataConverter;
import net.hollowcube.polar.PolarReader;
import net.hollowcube.polar.PolarSection;
import net.hollowcube.polar.PolarWorld;
import net.hollowcube.polar.PolarWorldAccess;
import net.hollowcube.polar.PolarWriter;
import net.hollowcube.polar.StreamingPolarLoader;
import net.hollowcube.polar.UnsafeOps;
import net.minestom.server.MinecraftServer;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentBlockState;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.exception.ExceptionManager;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.ChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockManager;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarLoader
implements ChunkLoader {
    static final Logger logger = LoggerFactory.getLogger(PolarLoader.class);
    private static final BlockManager BLOCK_MANAGER = MinecraftServer.getBlockManager();
    private static final ExceptionManager EXCEPTION_HANDLER = MinecraftServer.getExceptionManager();
    private final Map<String, Integer> biomeReadCache = new ConcurrentHashMap<String, Integer>();
    private final Map<Integer, String> biomeWriteCache = new ConcurrentHashMap<Integer, String>();
    private final Path savePath;
    private final ReentrantReadWriteLock worldDataLock = new ReentrantReadWriteLock();
    private final PolarWorld worldData;
    private PolarWorldAccess worldAccess = PolarWorldAccess.DEFAULT;
    private boolean parallel = false;
    private boolean loadLighting = true;
    private int plainsBiomeId = 0;

    @ApiStatus.Experimental
    @NotNull
    public static CompletableFuture<Void> streamLoad(@NotNull InstanceContainer instance, @NotNull ReadableByteChannel is, long fileSize, @Nullable PolarDataConverter dataConverter, @Nullable PolarWorldAccess worldAccess, boolean loadLighting) {
        StreamingPolarLoader loader = new StreamingPolarLoader(instance, Objects.requireNonNullElse(dataConverter, PolarDataConverter.NOOP), worldAccess, loadLighting);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread.startVirtualThread(() -> {
            try {
                loader.loadAllSequential(is, fileSize);
                future.complete(null);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public PolarLoader(@NotNull Path path) throws IOException {
        this(path, Files.exists(path, new LinkOption[0]) ? PolarReader.read(Files.readAllBytes(path)) : new PolarWorld());
    }

    public PolarLoader(@NotNull Path savePath, @NotNull PolarWorld worldData) {
        this.savePath = savePath;
        this.worldData = worldData;
    }

    public PolarLoader(@NotNull InputStream inputStream) throws IOException {
        try (InputStream inputStream2 = inputStream;){
            this.worldData = PolarReader.read(inputStream.readAllBytes());
            this.savePath = null;
        }
    }

    public PolarLoader(@NotNull PolarWorld world) {
        this.worldData = world;
        this.savePath = null;
    }

    @NotNull
    public PolarWorld world() {
        return this.worldData;
    }

    @Contract(value="_ -> this")
    @NotNull
    public PolarLoader setWorldAccess(@NotNull PolarWorldAccess worldAccess) {
        this.worldAccess = worldAccess;
        this.plainsBiomeId = this.worldAccess.getBiomeId(Biome.PLAINS.name());
        if (this.plainsBiomeId == -1) {
            throw new IllegalStateException("Plains biome not found");
        }
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public PolarLoader setParallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public PolarLoader setLoadLighting(boolean loadLighting) {
        this.loadLighting = loadLighting;
        return this;
    }

    @Override
    public boolean supportsParallelLoading() {
        return this.parallel;
    }

    @Override
    public void loadInstance(@NotNull Instance instance) {
        byte[] userData = this.worldData.userData();
        if (userData.length > 0) {
            this.worldAccess.loadWorldData(instance, NetworkBuffer.wrap(userData, 0, userData.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Chunk loadChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        Chunk chunk;
        this.worldDataLock.readLock().lock();
        PolarChunk chunkData = this.worldData.chunkAt(chunkX, chunkZ);
        this.worldDataLock.readLock().unlock();
        if (chunkData == null) {
            return null;
        }
        Chunk chunk2 = chunk = instance.getChunkSupplier().createChunk(instance, chunkX, chunkZ);
        synchronized (chunk2) {
            int sectionY = chunk.getMinSection();
            for (PolarSection sectionData : chunkData.sections()) {
                if (sectionData.isEmpty()) {
                    ++sectionY;
                    continue;
                }
                Section section = chunk.getSection(sectionY);
                this.loadSection(sectionData, section);
                ++sectionY;
            }
            for (PolarChunk.BlockEntity blockEntity : chunkData.blockEntities()) {
                PolarLoader.loadBlockEntity(chunk, blockEntity);
            }
            this.worldAccess.loadHeightmaps(chunk, chunkData.heightmaps());
            byte[] userData = chunkData.userData();
            if (userData.length > 0) {
                this.worldAccess.loadChunkData(chunk, NetworkBuffer.wrap(userData, 0, userData.length));
            }
        }
        return chunk;
    }

    private void loadSection(@NotNull PolarSection sectionData, @NotNull Section section) {
        String[] rawBlockPalette = sectionData.blockPalette();
        Block[] blockPalette = new Block[rawBlockPalette.length];
        for (int i = 0; i < rawBlockPalette.length; ++i) {
            try {
                blockPalette[i] = ArgumentBlockState.staticParse(rawBlockPalette[i]);
                continue;
            }
            catch (ArgumentSyntaxException e) {
                logger.error("Failed to parse block state: {} ({})", (Object)rawBlockPalette[i], (Object)e.getMessage());
                blockPalette[i] = Block.AIR;
            }
        }
        if (blockPalette.length == 1) {
            section.blockPalette().fill(blockPalette[0].stateId());
        } else {
            int[] paletteData = sectionData.blockData();
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int index = y * 16 * 16 + z * 16 + x;
                        section.blockPalette().set(x, y, z, blockPalette[paletteData[index]].stateId());
                    }
                }
            }
        }
        String[] rawBiomePalette = sectionData.biomePalette();
        int[] biomePalette = new int[rawBiomePalette.length];
        for (int i = 0; i < rawBiomePalette.length; ++i) {
            biomePalette[i] = this.biomeReadCache.computeIfAbsent(rawBiomePalette[i], name -> {
                int biomeId = this.worldAccess.getBiomeId((String)name);
                if (biomeId == -1) {
                    logger.error("Failed to find biome: {}", name);
                    biomeId = this.plainsBiomeId;
                }
                return biomeId;
            });
        }
        if (biomePalette.length == 1) {
            section.biomePalette().fill(biomePalette[0]);
        } else {
            int[] paletteData = sectionData.biomeData();
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    for (int x = 0; x < 4; ++x) {
                        int index = x + z * 4 + y * 16;
                        int paletteIndex = paletteData[index];
                        if (paletteIndex >= biomePalette.length) {
                            logger.error("Invalid biome palette index. This is probably a corrupted world, but it has been loaded with plains instead. No data has been written.");
                            section.biomePalette().set(x, y, z, this.plainsBiomeId);
                        }
                        section.biomePalette().set(x, y, z, biomePalette[paletteIndex]);
                    }
                }
            }
        }
        if (this.loadLighting && sectionData.blockLightContent() != PolarSection.LightContent.MISSING) {
            UnsafeOps.unsafeUpdateBlockLightArray(section.blockLight(), PolarLoader.getLightArray(sectionData.blockLightContent(), sectionData.blockLight()));
        }
        if (this.loadLighting && sectionData.skyLightContent() != PolarSection.LightContent.MISSING) {
            UnsafeOps.unsafeUpdateSkyLightArray(section.skyLight(), PolarLoader.getLightArray(sectionData.skyLightContent(), sectionData.skyLight()));
        }
    }

    static byte[] getLightArray(@NotNull PolarSection.LightContent content, byte @Nullable [] data) {
        return switch (content) {
            default -> throw new MatchException(null, null);
            case PolarSection.LightContent.MISSING -> null;
            case PolarSection.LightContent.EMPTY -> LightCompute.EMPTY_CONTENT;
            case PolarSection.LightContent.FULL -> LightCompute.CONTENT_FULLY_LIT;
            case PolarSection.LightContent.PRESENT -> data;
        };
    }

    @NotNull
    static Block createBlockEntity(@NotNull Chunk chunk, @NotNull PolarChunk.BlockEntity blockEntity) {
        Block block = chunk.getBlock(blockEntity.x(), blockEntity.y(), blockEntity.z(), Block.Getter.Condition.TYPE);
        if (blockEntity.id() != null) {
            block = block.withHandler(BLOCK_MANAGER.getHandlerOrDummy(blockEntity.id()));
        }
        if (blockEntity.data() != null) {
            block = block.withNbt(blockEntity.data());
        }
        return block;
    }

    static void loadBlockEntity(@NotNull Chunk chunk, @NotNull PolarChunk.BlockEntity blockEntity) {
        Block block = PolarLoader.createBlockEntity(chunk, blockEntity);
        chunk.setBlock(blockEntity.x(), blockEntity.y(), blockEntity.z(), block);
    }

    @Override
    public boolean supportsParallelSaving() {
        return this.parallel;
    }

    @Override
    public void saveInstance(@NotNull Instance instance) {
        this.worldData.userData(NetworkBuffer.makeArray(b -> this.worldAccess.saveWorldData(instance, (NetworkBuffer)b)));
        DimensionType dimensionType = MinecraftServer.getDimensionTypeRegistry().get(instance.getDimensionType());
        byte minSection = (byte)(dimensionType.minY() / 16);
        byte maxSection = (byte)(dimensionType.maxY() / 16 - 1);
        if (minSection == this.worldData.minSection() && this.worldData.maxSection() == maxSection) {
            this.saveChunks(instance.getChunks());
            return;
        }
        this.worldDataLock.writeLock().lock();
        this.worldData.setSectionCount(minSection, maxSection);
        this.worldDataLock.writeLock().unlock();
        this.saveChunks(instance.getChunks());
    }

    @Override
    public void unloadChunk(Chunk chunk) {
        this.updateChunkData(new Short2ObjectOpenHashMap<String>(), chunk);
    }

    @Override
    public void saveChunks(@NotNull Collection<Chunk> chunks) {
        Short2ObjectOpenHashMap blockCache = new Short2ObjectOpenHashMap();
        chunks.forEach(c -> this.updateChunkData(blockCache, (Chunk)c));
        if (this.savePath != null) {
            try {
                Files.write(this.savePath, PolarWriter.write(this.worldData), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                EXCEPTION_HANDLER.handleException(new RuntimeException("Failed to save world", e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChunkData(@NotNull Short2ObjectMap<String> blockCache, @NotNull Chunk chunk) {
        DimensionType dimension = chunk.getInstance().getCachedDimensionType();
        ArrayList<PolarChunk.BlockEntity> blockEntities = new ArrayList<PolarChunk.BlockEntity>();
        PolarSection[] sections = new PolarSection[dimension.height() / 16];
        assert (sections.length == chunk.getSections().size()) : "World height mismatch";
        int[][] heightmaps = new int[32][];
        byte[] userData = new byte[]{};
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            for (int i = 0; i < sections.length; ++i) {
                int sectionY = i + chunk.getMinSection();
                Section section = chunk.getSection(sectionY);
                ArrayList<String> blockPalette = new ArrayList<String>();
                int[] blockData = null;
                if (section.blockPalette().count() == 0) {
                    blockPalette.add("air");
                } else {
                    int[] localBlockData = new int[4096];
                    section.blockPalette().getAll((x, sectionLocalY, z, blockStateId) -> {
                        int blockIndex = x + sectionLocalY * 16 * 16 + z * 16;
                        String namespace = blockCache.computeIfAbsent((short)blockStateId, unused -> this.blockToString(Block.fromStateId(blockStateId)));
                        int paletteId = blockPalette.indexOf(namespace);
                        if (paletteId == -1) {
                            paletteId = blockPalette.size();
                            blockPalette.add(namespace);
                        }
                        localBlockData[blockIndex] = paletteId;
                    });
                    blockData = localBlockData;
                    for (int sectionLocalY2 = 0; sectionLocalY2 < 16; ++sectionLocalY2) {
                        for (int z2 = 0; z2 < 16; ++z2) {
                            for (int x2 = 0; x2 < 16; ++x2) {
                                String handlerId;
                                int y2 = sectionLocalY2 + sectionY * 16;
                                Block block = chunk.getBlock(x2, y2, z2, Block.Getter.Condition.CACHED);
                                if (block == null) continue;
                                String string = handlerId = block.handler() == null ? null : block.handler().getKey().asString();
                                if (handlerId == null && !block.hasNbt()) continue;
                                blockEntities.add(new PolarChunk.BlockEntity(x2, y2, z2, handlerId, block.nbt()));
                            }
                        }
                    }
                }
                ArrayList biomePalette = new ArrayList();
                int[] biomeData = new int[64];
                section.biomePalette().getAll((x, y, z, id) -> {
                    String biomeId = this.biomeWriteCache.computeIfAbsent(id, this.worldAccess::getBiomeName);
                    int paletteId = biomePalette.indexOf(biomeId);
                    if (paletteId == -1) {
                        paletteId = biomePalette.size();
                        biomePalette.add(biomeId);
                    }
                    biomeData[x + z * 4 + y * 4 * 4] = paletteId;
                });
                byte[] blockLight = section.blockLight().array();
                byte[] skyLight = section.skyLight().array();
                sections[i] = new PolarSection(blockPalette.toArray(new String[0]), blockData, biomePalette.toArray(new String[0]), biomeData, this.getLightContent(blockLight), blockLight, this.getLightContent(skyLight), skyLight);
            }
            this.worldAccess.saveHeightmaps(chunk, heightmaps);
            userData = NetworkBuffer.makeArray(b -> this.worldAccess.saveChunkData(chunk, (NetworkBuffer)b));
        }
        this.worldDataLock.writeLock().lock();
        this.worldData.updateChunkAt(chunk.getChunkX(), chunk.getChunkZ(), new PolarChunk(chunk.getChunkX(), chunk.getChunkZ(), sections, blockEntities, heightmaps, userData));
        this.worldDataLock.writeLock().unlock();
    }

    @NotNull
    private PolarSection.LightContent getLightContent(byte @Nullable [] data) {
        if (data == null) {
            return PolarSection.LightContent.MISSING;
        }
        if (data.length == 0 || Arrays.equals(data, LightCompute.EMPTY_CONTENT)) {
            return PolarSection.LightContent.EMPTY;
        }
        if (Arrays.equals(data, LightCompute.CONTENT_FULLY_LIT)) {
            return PolarSection.LightContent.FULL;
        }
        return PolarSection.LightContent.PRESENT;
    }

    @Override
    public void saveChunk(@NotNull Chunk chunk) {
        this.saveChunks(List.of(chunk));
    }

    @NotNull
    private String blockToString(@NotNull Block block) {
        StringBuilder builder = new StringBuilder(block.name());
        if (block.properties().isEmpty()) {
            return builder.toString();
        }
        builder.append('[');
        for (Map.Entry<String, String> entry : block.properties().entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(']');
        return builder.toString();
    }
}

