/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.polar;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PolarSection {
    public static final int BLOCK_PALETTE_SIZE = 4096;
    public static final int BIOME_PALETTE_SIZE = 64;
    private final boolean empty;
    private final String @NotNull [] blockPalette;
    private final int @Nullable [] blockData;
    private final String @NotNull [] biomePalette;
    private final int @Nullable [] biomeData;
    private final LightContent blockLightContent;
    private final byte @Nullable [] blockLight;
    private final LightContent skyLightContent;
    private final byte @Nullable [] skyLight;

    public PolarSection() {
        this.empty = true;
        this.blockPalette = new String[]{"minecraft:air"};
        this.blockData = null;
        this.biomePalette = new String[]{"minecraft:plains"};
        this.biomeData = null;
        this.blockLightContent = LightContent.MISSING;
        this.blockLight = null;
        this.skyLightContent = LightContent.MISSING;
        this.skyLight = null;
    }

    public PolarSection(String @NotNull [] blockPalette, int @Nullable [] blockData, String @NotNull [] biomePalette, int @Nullable [] biomeData, @NotNull LightContent blockLightContent, byte @Nullable [] blockLight, @NotNull LightContent skyLightContent, byte @Nullable [] skyLight) {
        this.empty = false;
        this.blockPalette = blockPalette;
        this.blockData = blockData;
        this.biomePalette = biomePalette;
        this.biomeData = biomeData;
        this.blockLightContent = blockLightContent;
        this.blockLight = blockLight;
        this.skyLightContent = skyLightContent;
        this.skyLight = skyLight;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @NotNull
    public @NotNull String @NotNull [] blockPalette() {
        return this.blockPalette;
    }

    public int[] blockData() {
        assert (this.blockData != null) : "must check length of blockPalette() before using blockData()";
        return this.blockData;
    }

    @NotNull
    public @NotNull String @NotNull [] biomePalette() {
        return this.biomePalette;
    }

    public int[] biomeData() {
        assert (this.biomeData != null) : "must check length of biomePalette() before using biomeData()";
        return this.biomeData;
    }

    @NotNull
    public LightContent blockLightContent() {
        return this.blockLightContent;
    }

    public byte[] blockLight() {
        return this.blockLight;
    }

    @NotNull
    public LightContent skyLightContent() {
        return this.skyLightContent;
    }

    public byte[] skyLight() {
        return this.skyLight;
    }

    public static enum LightContent {
        MISSING,
        EMPTY,
        FULL,
        PRESENT;

        public static final LightContent[] VALUES;

        static {
            VALUES = LightContent.values();
        }
    }
}

