/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.polar;

import java.util.ArrayList;
import net.hollowcube.polar.PolarChunk;
import net.hollowcube.polar.PolarSection;
import net.hollowcube.polar.PolarWorld;
import org.jetbrains.annotations.NotNull;

public class WorldHeightUtil {
    @NotNull
    public static PolarWorld updateWorldHeight(@NotNull PolarWorld world, byte minSection, byte maxSection) {
        assert (minSection <= maxSection) : "minSection cannot be less than maxSection";
        ArrayList<PolarChunk> chunks = new ArrayList<PolarChunk>(world.chunks().size());
        for (PolarChunk chunk : world.chunks()) {
            chunks.add(WorldHeightUtil.updateChunkHeight(chunk, minSection, maxSection));
        }
        return new PolarWorld(world.version(), world.dataVersion(), world.compression(), minSection, maxSection, world.userData(), chunks);
    }

    @NotNull
    public static PolarChunk updateChunkHeight(@NotNull PolarChunk chunk, byte minSection, byte maxSection) {
        PolarSection[] sections = new PolarSection[maxSection - minSection + 1];
        for (int i = 0; i <= maxSection - minSection; ++i) {
            sections[i] = i < chunk.sections().length ? chunk.sections()[i] : new PolarSection();
        }
        return new PolarChunk(chunk.x(), chunk.z(), sections, chunk.blockEntities(), chunk.heightmaps(), chunk.userData());
    }
}

