/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.advancements;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.advancements.AdvancementTab;
import net.minestom.server.advancements.FrameType;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.network.packet.server.play.AdvancementsPacket;
import org.jetbrains.annotations.Nullable;

public class Advancement {
    protected AdvancementTab tab;
    private boolean achieved;
    private Component title;
    private Component description;
    private ItemStack icon;
    private FrameType frameType;
    private String background;
    private boolean toast;
    private boolean hidden;
    private float x;
    private float y;
    private String identifier;
    private Advancement parent;
    private AdvancementsPacket.Criteria criteria;
    private boolean sendTelemetryData;

    public Advancement(Component title, Component description, Material icon, FrameType frameType, float x, float y) {
        this(title, description, ItemStack.of(icon), frameType, x, y, false);
    }

    public Advancement(Component title, Component description, ItemStack icon, FrameType frameType, float x, float y) {
        this(title, description, icon, frameType, x, y, false);
    }

    public Advancement(Component title, Component description, ItemStack icon, FrameType frameType, float x, float y, boolean sendTelemetryData) {
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.frameType = frameType;
        this.x = x;
        this.y = y;
        this.sendTelemetryData = sendTelemetryData;
    }

    public boolean isAchieved() {
        return this.achieved;
    }

    public Advancement setAchieved(boolean achieved) {
        this.achieved = achieved;
        this.update();
        return this;
    }

    @Nullable
    public AdvancementTab getTab() {
        return this.tab;
    }

    protected void setTab(@Nullable AdvancementTab tab) {
        this.tab = tab;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
        this.update();
    }

    public Component getDescription() {
        return this.description;
    }

    public void setDescription(Component description) {
        this.description = description;
        this.update();
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
        this.update();
    }

    public boolean hasToast() {
        return this.toast;
    }

    public Advancement showToast(boolean toast) {
        this.toast = toast;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Advancement setHidden(boolean hidden) {
        this.hidden = hidden;
        this.update();
        return this;
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void setFrameType(FrameType frameType) {
        this.frameType = frameType;
        this.update();
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
        this.update();
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
        this.update();
    }

    protected void setBackground(String background) {
        this.background = background;
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Nullable
    protected Advancement getParent() {
        return this.parent;
    }

    protected void setParent(@Nullable Advancement parent) {
        this.parent = parent;
    }

    protected AdvancementsPacket.ProgressMapping toProgressMapping() {
        AdvancementsPacket.AdvancementProgress advancementProgress = new AdvancementsPacket.AdvancementProgress(List.of(this.criteria));
        return new AdvancementsPacket.ProgressMapping(this.identifier, advancementProgress);
    }

    protected AdvancementsPacket.DisplayData toDisplayData() {
        return new AdvancementsPacket.DisplayData(this.title, this.description, this.icon, this.frameType, this.getFlags(), this.background, this.x, this.y);
    }

    protected AdvancementsPacket.AdvancementMapping toMapping() {
        Advancement parent = this.getParent();
        String parentIdentifier = parent != null ? parent.getIdentifier() : null;
        AdvancementsPacket.Advancement adv = new AdvancementsPacket.Advancement(parentIdentifier, this.toDisplayData(), List.of(new AdvancementsPacket.Requirement(List.of(this.criteria.criterionIdentifier()))), this.sendTelemetryData);
        return new AdvancementsPacket.AdvancementMapping(this.getIdentifier(), adv);
    }

    protected AdvancementsPacket getUpdatePacket() {
        return new AdvancementsPacket(false, List.of(this.toMapping()), List.of(), List.of(this.toProgressMapping()), true);
    }

    protected void update() {
        this.updateCriteria();
        if (this.tab != null) {
            this.tab.sendPacketsToViewers(this.tab.removePacket, this.tab.createPacket());
        }
    }

    protected void updateCriteria() {
        Long achievedDate = this.achieved ? Long.valueOf(System.currentTimeMillis()) : null;
        AdvancementsPacket.CriterionProgress progress = new AdvancementsPacket.CriterionProgress(achievedDate);
        this.criteria = new AdvancementsPacket.Criteria(this.identifier, progress);
    }

    private int getFlags() {
        byte result = 0;
        if (this.background != null) {
            result = (byte)(result | 1);
        }
        if (this.hasToast()) {
            result = (byte)(result | 2);
        }
        if (this.isHidden()) {
            result = (byte)(result | 4);
        }
        return result;
    }
}

