/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.minestom.server.entity.Entity;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.play.EntitySoundEffectPacket;
import net.minestom.server.network.packet.server.play.SetTitleSubTitlePacket;
import net.minestom.server.network.packet.server.play.SetTitleTextPacket;
import net.minestom.server.network.packet.server.play.SetTitleTimePacket;
import net.minestom.server.network.packet.server.play.SoundEffectPacket;
import net.minestom.server.network.packet.server.play.StopSoundPacket;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.TickUtils;

public class AdventurePacketConvertor {
    private static final Object2IntMap<NamedTextColor> NAMED_TEXT_COLOR_ID_MAP = new Object2IntArrayMap<NamedTextColor>(16);

    public static int getBossBarOverlayValue(BossBar.Overlay overlay) {
        return overlay.ordinal();
    }

    public static byte getBossBarFlagValue(Collection<BossBar.Flag> flags) {
        byte val = 0;
        for (BossBar.Flag flag : flags) {
            val = (byte)(val | flag.ordinal());
        }
        return val;
    }

    public static int getBossBarColorValue(BossBar.Color color) {
        return color.ordinal();
    }

    public static int getSoundSourceValue(Sound.Source source) {
        return source.ordinal();
    }

    public static int getNamedTextColorValue(NamedTextColor color) {
        return NAMED_TEXT_COLOR_ID_MAP.getInt(color);
    }

    public static ServerPacket createSoundPacket(Sound sound, double x, double y, double z) {
        SoundEvent minestomSound = SoundEvent.fromKey(sound.name());
        if (minestomSound == null) {
            minestomSound = SoundEvent.of(sound.name(), null);
        }
        long seed = sound.seed().orElse(ThreadLocalRandom.current().nextLong());
        return new SoundEffectPacket(minestomSound, sound.source(), (int)x, (int)y, (int)z, sound.volume(), sound.pitch(), seed);
    }

    public static ServerPacket createSoundPacket(Sound sound, Sound.Emitter emitter) {
        if (emitter == Sound.Emitter.self()) {
            throw new IllegalArgumentException("you must replace instances of Emitter.self() before calling this method");
        }
        if (!(emitter instanceof Entity)) {
            throw new IllegalArgumentException("you can only call this method with entities");
        }
        Entity entity = (Entity)emitter;
        SoundEvent minestomSound = SoundEvent.fromKey(sound.name());
        if (minestomSound == null) {
            minestomSound = SoundEvent.of(sound.name(), null);
        }
        long seed = sound.seed().orElse(ThreadLocalRandom.current().nextLong());
        return new EntitySoundEffectPacket(minestomSound, sound.source(), entity.getEntityId(), sound.volume(), sound.pitch(), seed);
    }

    @Deprecated(forRemoval=true)
    public static ServerPacket createEntitySoundPacket(Sound sound, Entity entity) {
        return AdventurePacketConvertor.createSoundPacket(sound, entity);
    }

    public static ServerPacket createSoundStopPacket(SoundStop stop) {
        Key soundKey;
        byte flags = 0;
        Sound.Source source = stop.source();
        String sound = null;
        if (source != null) {
            flags = (byte)(flags | 1);
        }
        if ((soundKey = stop.sound()) != null) {
            flags = (byte)(flags | 2);
            sound = soundKey.asString();
        }
        return new StopSoundPacket(flags, source, sound);
    }

    public static <T> ServerPacket createTitlePartPacket(TitlePart<T> part, T value) {
        if (part == TitlePart.TITLE) {
            return new SetTitleTextPacket((Component)value);
        }
        if (part == TitlePart.SUBTITLE) {
            return new SetTitleSubTitlePacket((Component)value);
        }
        if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            return new SetTitleTimePacket(TickUtils.fromDuration(times.fadeIn(), 50), TickUtils.fromDuration(times.stay(), 50), TickUtils.fromDuration(times.fadeOut(), 50));
        }
        throw new IllegalArgumentException("Unknown TitlePart " + String.valueOf(part));
    }

    static {
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.BLACK, 0);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.DARK_BLUE, 1);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.DARK_GREEN, 2);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.DARK_AQUA, 3);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.DARK_RED, 4);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.DARK_PURPLE, 5);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.GOLD, 6);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.GRAY, 7);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.DARK_GRAY, 8);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.BLUE, 9);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.GREEN, 10);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.AQUA, 11);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.RED, 12);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.LIGHT_PURPLE, 13);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.YELLOW, 14);
        NAMED_TEXT_COLOR_ID_MAP.put(NamedTextColor.WHITE, 15);
    }
}

